/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import java.util.Arrays;
import java.util.HashSet;

public class TestDashboardRelatedEntitiesDelete
extends FuncTestCase {
    private static final String GROUP_DELETE = "group_delete";
    private static final String GROUP_ADMIN = "jira-administrators";
    private static final String PROJECT_DELETE_NAME = "project_delete";
    private static final int PROJECT_DELETE_ID = 10010;
    private static final int ROLE_DELETE_ID = 10010;
    private static final String ROLE_DELETE_NAME = "role_delete";
    private static final int DASHBOARD_PROJECT_ID = 10013;
    private SharedEntityInfo dashboardCopy;
    private SharedEntityInfo roleDashboard;
    private SharedEntityInfo groupDashboard;
    private SharedEntityInfo projectDashboard;

    protected void setUpTest() {
        this.dashboardCopy = new SharedEntityInfo("Dashboard for Administrator", "Copy of 'System Dashboard'", true, TestSharingPermissionUtils.createPublicPermissions(), null, null);
        this.groupDashboard = new SharedEntityInfo("group_dashboard", null, true, new HashSet<GroupTestSharingPermission>(Arrays.asList(new GroupTestSharingPermission(GROUP_DELETE), new GroupTestSharingPermission(GROUP_ADMIN))), null, null);
        this.projectDashboard = new SharedEntityInfo("project_dashboard", null, true, TestSharingPermissionUtils.createProjectPermissions(10010L, -1L, PROJECT_DELETE_NAME, null), null, null);
        this.roleDashboard = new SharedEntityInfo("role_dashboard", null, true, TestSharingPermissionUtils.createProjectPermissions(10010L, 10010L, PROJECT_DELETE_NAME, ROLE_DELETE_NAME), null, null);
        this.administration.restoreData("sharedpages/TestDashboardRelatedEntitiesDelete.xml");
    }

    public void testDeleteGroup() {
        this.administration.usersAndGroups().deleteGroup(GROUP_DELETE);
        this.groupDashboard.setSharingPermissions(TestSharingPermissionUtils.createGroupPermissions(GROUP_ADMIN));
        this.navigation.dashboard().navigateToMy();
        this.assertions.getDashboardAssertions().assertDashboardPages(Arrays.asList(this.dashboardCopy, this.groupDashboard, this.projectDashboard, this.roleDashboard), Dashboard.Table.OWNED);
    }

    public void testDeleteRole() {
        this.administration.roles().deleteRole(10010L);
        this.roleDashboard.setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions());
        this.navigation.dashboard().navigateToMy();
        this.assertions.getDashboardAssertions().assertDashboardPages(Arrays.asList(this.dashboardCopy, this.groupDashboard, this.projectDashboard, this.roleDashboard), Dashboard.Table.OWNED);
    }
}

