/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TestVersionCustomField
extends FuncTestCase {
    public void testOrderingOfOptions() {
        this.administration.restoreData("TestVersionCustomField.xml");
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("filterform");
        String[] fixForVersions = this.tester.getDialog().getOptionsFor("fixfor");
        String[] affectsVersions = this.tester.getDialog().getOptionsFor("version");
        String[] cfSingleVersions = this.tester.getDialog().getOptionsFor("customfield_10000");
        String[] cfVersions = this.tester.getDialog().getOptionsFor("customfield_10001");
        TestVersionCustomField.assertEquals((Object)this.getUnifiedVersions(affectsVersions), (Object)EasyList.build((Object)"New Version 4", (Object)"New Version 1", (Object)"New Version 5", (Object)"New Version 6"));
        TestVersionCustomField.assertEquals((Object)this.getUnifiedVersions(affectsVersions), (Object)this.getUnifiedVersions(fixForVersions));
        TestVersionCustomField.assertEquals((Object)this.getUnifiedVersions(affectsVersions), (Object)this.getUnifiedVersions(cfSingleVersions));
        TestVersionCustomField.assertEquals((Object)this.getUnifiedVersions(affectsVersions), (Object)this.getUnifiedVersions(cfVersions));
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "Test issue 1");
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        fixForVersions = this.tester.getDialog().getOptionsFor("fixVersions");
        affectsVersions = this.tester.getDialog().getOptionsFor("versions");
        cfSingleVersions = this.tester.getDialog().getOptionsFor("customfield_10000");
        cfVersions = this.tester.getDialog().getOptionsFor("customfield_10001");
        TestVersionCustomField.assertEquals((Object)this.getUnifiedVersions(fixForVersions), (Object)EasyList.build((Object)"New Version 5", (Object)"New Version 6", (Object)"New Version 4", (Object)"New Version 1"));
        TestVersionCustomField.assertEquals((Object)this.getUnifiedVersions(affectsVersions), (Object)EasyList.build((Object)"New Version 4", (Object)"New Version 1", (Object)"New Version 5", (Object)"New Version 6"));
        TestVersionCustomField.assertEquals((Object)this.getUnifiedVersions(affectsVersions), (Object)this.getUnifiedVersions(cfSingleVersions));
        TestVersionCustomField.assertEquals((Object)this.getUnifiedVersions(affectsVersions), (Object)this.getUnifiedVersions(cfVersions));
    }

    private List getUnifiedVersions(String[] options) {
        ArrayList<Object> allVersions;
        if (Arrays.asList(options).contains("Unknown")) {
            allVersions = new ArrayList<String>(Arrays.asList(options));
            allVersions.remove("Unknown");
        } else {
            allVersions = new ArrayList();
            allVersions.addAll(this.getReleasedVersions(options, 2));
            allVersions.addAll(this.getUnreleasedVersions(options, 2));
        }
        return allVersions;
    }

    private List getReleasedVersions(String[] options, int expected) {
        return this.getVersions(options, expected, "Released Versions");
    }

    private List getUnreleasedVersions(String[] options, int expected) {
        return this.getVersions(options, expected, "Unreleased Versions");
    }

    private List getVersions(String[] options, int expected, String flag) {
        List<String> versions = Arrays.asList(options);
        int i = versions.indexOf(flag) + 1;
        return versions.subList(i, i + expected);
    }
}

