/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.apache.oro.text.regex.MalformedPatternException;

public class TestCustomFieldMultiUserPicker
extends JIRAWebTest {
    public TestCustomFieldMultiUserPicker(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testCreateAndSetDefaultValue() throws MalformedPatternException {
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.submit("nextBtn");
        this.setFormElement("fieldName", "Developers");
        this.submit("nextBtn");
        this.checkCheckbox("associatedScreens", "1");
        this.submit("Update");
        this.assertTextPresent("View Custom Fields");
        this.assertTextPresent("Multi User Picker");
        this.assertTextPresent("Developers");
        String fieldId = this.getRegexMatch("customfield_(\\d+)");
        TestCustomFieldMultiUserPicker.assertNotNull((Object)fieldId);
        this.clickLink("config_customfield_" + fieldId);
        this.clickLinkWithText("Edit Default Value");
        this.submit("Set Default");
        this.assertTextNotPresent("fred");
        this.assertTextPresent("Default Configuration Scheme for Developers");
        this.clickLinkWithText("Edit Default Value");
        this.assertFormElementEquals("customfield_" + fieldId, "");
        this.setFormElement("customfield_" + fieldId, "fred");
        this.submit("Set Default");
        this.assertTextPresent("Fred Normal");
        this.assertTextPresent("Default Configuration Scheme for Developers");
        this.clickLinkWithText("Edit Default Value");
        this.assertFormElementEquals("customfield_" + fieldId, "fred");
        this.setFormElement("customfield_" + fieldId, "fred, admin");
        this.submit("Set Default");
        this.assertTextPresent("Fred Normal");
        this.assertTextSequence(new String[]{"Administrator", "and", "Fred Normal"});
        this.assertTextPresent("Default Configuration Scheme for Developers");
        this.clickLinkWithText("Edit Default Value");
        this.assertFormElementEquals("customfield_" + fieldId, "admin, fred");
        this.setFormElement("customfield_" + fieldId, "admin");
        this.submit("Set Default");
        this.assertTextNotPresent("Fred Normal");
        this.assertTextPresent("Default Configuration Scheme for Developers");
        this.clickLinkWithText("Edit Default Value");
        this.assertFormElementEquals("customfield_" + fieldId, "admin");
        this.setFormElement("customfield_" + fieldId, "");
        this.submit("Set Default");
        this.assertTextNotPresent("Fred Normal");
        this.assertTextPresent("Default Configuration Scheme for Developers");
        this.clickLinkWithText("Edit Default Value");
        this.assertFormElementEquals("customfield_" + fieldId, "");
    }
}

