/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestCascadingSelectCustomField
extends JIRAWebTest {
    private static final String CUSTOMFIELD_10000 = "customfield_10000";
    private static final String CUSTOMFIELD_10000_OPTION = "customfield_10000:1";
    private static final String CUSTOMFIELD_10000_1 = "customfield_10000:1";
    private static final String CASCADING_SELECT_NAME = "asdf";
    private static final String UPDATE_FIELD_TEXT = "Update the fields of the issue to relate to the new project.";
    private static final String ERROR_PRESENT_FOR_BAD_OPTION = "The option 'a1' is invalid for parent option 'test'";
    private static final String HOMO_PID_OPTION = "10001_1_pid";
    private static final String MONKEY_PID_OPTION = "10000_1_pid";
    private static final String MOVE_ISSUES_CONFIRMATION_TEXT = "Move Issues: Confirmation";
    private static final String FAILURE_ERROR_FOR_OPTION_SELECT = "The option 'p1' is invalid for parent option 'stuff'";

    public TestCascadingSelectCustomField(String name) {
        super(name);
    }

    public void testMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.gotoIssue("HSP-1");
        this.clickLink("move_issue");
        this.setFormElement("pid", "10001");
        this.submit("Next >>");
        this.assertTextPresent(UPDATE_FIELD_TEXT);
        this.assertTextPresent(CASCADING_SELECT_NAME);
        this.selectOption(CUSTOMFIELD_10000, "test");
        this.selectOption("customfield_10000:1", "t1");
        this.submit("Next >>");
        this.assertTextPresent("stuff");
        this.assertTextPresent("s1");
        this.assertTextPresent("test");
        this.assertTextPresent("t1");
        this.submit("Move");
        this.assertTextPresent("test");
        this.assertTextPresent("t1");
    }

    public void testMoveIssueWithCascadingSelectCustomFieldWithBadValues() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.gotoIssue("HSP-1");
        this.clickLink("move_issue");
        this.setFormElement("pid", "10001");
        this.submit("Next >>");
        this.assertTextPresent(UPDATE_FIELD_TEXT);
        this.assertTextPresent(CASCADING_SELECT_NAME);
        this.selectOption(CUSTOMFIELD_10000, "test");
        this.selectOption("customfield_10000:1", "a1");
        this.submit("Next >>");
        this.assertTextPresent(ERROR_PRESENT_FOR_BAD_OPTION);
    }

    public void testBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts() {
        this.restoreData("TestBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.selectOption(MONKEY_PID_OPTION, "monkey");
        this.selectOption(HOMO_PID_OPTION, "homosapien");
        this.submit("Next");
        this.selectOption(CUSTOMFIELD_10000, "test");
        this.selectOption("customfield_10000:1", "t1");
        this.submit("Next");
        this.selectOption(CUSTOMFIELD_10000, "stuff");
        this.selectOption("customfield_10000:1", "s1");
        this.submit("Next");
        this.assertTextPresent(MOVE_ISSUES_CONFIRMATION_TEXT);
    }

    public void testEditIssueWithCascadingSelectField() {
        this.restoreData("TestBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.gotoIssue("HSP-1");
        this.clickLink("edit_issue");
        this.selectOption(CUSTOMFIELD_10000, "cranky");
        this.selectOption("customfield_10000:1", "p1");
        this.submit("Update");
        this.assertTextPresent(CASCADING_SELECT_NAME);
        this.assertTextPresent("cranky");
        this.assertTextPresent("p1");
        this.clickLink("edit_issue");
        this.selectOption(CUSTOMFIELD_10000, "stuff");
        this.selectOption("customfield_10000:1", "p1");
        this.submit("Update");
        this.assertTextPresent(FAILURE_ERROR_FOR_OPTION_SELECT);
    }

    public void testCreateIssueWithCascadingSelect() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.createIssueStep1();
        this.setFormElement("summary", "Test summary");
        this.selectOption(CUSTOMFIELD_10000, "cranky");
        this.selectOption("customfield_10000:1", "s1");
        this.submit("Create");
        this.assertTextPresent("The option 's1' is invalid for parent option 'cranky'");
        this.selectOption(CUSTOMFIELD_10000, "stuff");
        this.selectOption("customfield_10000:1", "s1");
        this.submit("Create");
        this.assertTextPresent(CASCADING_SELECT_NAME);
        this.assertTextPresent("stuff");
        this.assertTextPresent("s1");
    }

    public void testCreateIssueWithCascadingSelectChoosingOptionsNoneForParent() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.createIssueStep1();
        this.setFormElement("summary", "Test summary");
        this.selectOption(CUSTOMFIELD_10000, "None");
        this.submit("Create");
        this.assertTextNotPresent("asdf:");
    }

    public void testCreateIssueWithCascadingSelectChoosingOptionsNoneForChild() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.createIssueStep1();
        this.setFormElement("summary", "Test summary");
        this.selectOption(CUSTOMFIELD_10000, "stuff");
        this.selectOption("customfield_10000:1", "None");
        this.submit("Create");
        this.assertTextPresent("stuff");
    }

    public void testSetDefaultNoneOptionsForCascadingSelect() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("config_customfield_10000");
        this.clickLinkWithText("Edit Default Value");
        this.selectOption(CUSTOMFIELD_10000, "None");
        this.submit();
    }

    public void testIssueNavigatorSearchCascadingSelectWithAllOption() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.clickLink("find_link");
        this.selectOption("pid", "homosapien");
        this.submit("show");
        this.selectOption(CUSTOMFIELD_10000, "Any");
        this.submit("show");
        this.assertTextPresent("This is a test bug for the subversion plugin");
    }
}

