/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestCommentDelete
extends JIRAWebTest {
    public TestCommentDelete(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestCommentDelete.xml");
    }

    public void testDeleteOwnCommentWithOwnPermission() {
        this.logout();
        this.login("detkin", "detkin");
        this.gotoIssue("TST-1");
        this.clickLink("delete_comment_10020");
        this.submit("Delete");
        this.assertLinkNotPresent("delete_comment_10020");
    }

    public void testDeleteCommentWithAllPermission() {
        this.gotoIssue("TST-1");
        this.clickLink("delete_comment_10020");
        this.submit("Delete");
        this.assertLinkNotPresent("delete_comment_10020");
    }

    public void testDeleteOthersCommentWithOwnPermission() {
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.assertLinkNotPresent("delete_comment_10020");
    }

    public void testDeleteCommentLinkNotAvailableWithNonEditableWorkflowState() {
        this.gotoIssue("TST-1");
        this.clickLinkWithText("Close Issue");
        this.submit("Close Issue");
        this.assertLinkNotPresent("delete_comment_10020");
    }

    public void testDeleteCommentReindexesIssue() {
        this.clickLink("find_link");
        this.setFormElement("query", "\"Unique Comment\"");
        this.setFormElement("body", "true");
        this.submit("show");
        this.assertTextPresent("TST-1");
        this.gotoIssue("TST-1");
        this.clickLink("delete_comment_10020");
        this.submit("Delete");
        this.clickLink("find_link");
        this.setFormElement("query", "\"Unique Comment\"");
        this.setFormElement("body", "true");
        this.submit("show");
        this.assertTextNotPresent("TST-1");
        this.assertTextPresent("No matching issues found");
    }

    public void testDeleteCommentWithNoPermissions() {
        this.removeRolePermission(36, 10002);
        this.removeRolePermission(37, 10000);
        this.gotoPage("/secure/DeleteComment!default.jspa?id=10020");
        this.assertTextSequence(new String[]{"Delete Comment", "You do not have the permission for this comment."});
    }

    public void testDeleteCommentWithNonEditableWorkflowState() {
        this.gotoIssue("TST-1");
        this.clickLinkWithText("Close Issue");
        this.submit("Close Issue");
        this.gotoPage("/secure/DeleteComment!default.jspa?id=10020");
        this.assertTextSequence(new String[]{"Delete Comment", "You do not have the permission for this comment."});
    }

    public void testOneCanNotDeleteCommentThatOneCanNotSee() {
        this.gotoIssue("TST-1");
        this.addCommentOnCurrentIssue("This comment is visible by developers only!", "Developers");
        this.assertTextPresent("This comment is visible by developers only!");
        this.addUserToGroup("barney", "jira-administrators");
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.assertTextNotPresent("This comment is visible by developers only!");
        this.gotoPage("/secure/DeleteComment!default.jspa?id=10030");
        this.assertTextSequence(new String[]{"Delete Comment", "You do not have the permission for this comment."});
        this.gotoPage("/secure/DeleteComment!default.jspa?id=100301");
        this.assertTextSequence(new String[]{"Delete Comment", "You do not have the permission for this comment."});
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue("TST-1");
        this.assertTextPresent("This comment is visible by developers only!");
    }

    public void testOneCanNotEditCommentThatOneCanNotSee() {
        this.gotoIssue("TST-1");
        this.addCommentOnCurrentIssue("This comment is visible by developers only!", "Developers");
        this.assertTextPresent("This comment is visible by developers only!");
        this.addUserToGroup("barney", "jira-administrators");
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.assertTextNotPresent("This comment is visible by developers only!");
        this.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=10030");
        this.assertTextSequence(new String[]{"Edit Comment", "You do not have the permission for this comment."});
        this.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=100301");
        this.assertTextSequence(new String[]{"Edit Comment", "You do not have the permission for this comment."});
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue("TST-1");
        this.assertTextPresent("This comment is visible by developers only!");
    }
}

