/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class TestAddComment
extends JIRAWebTest {
    private static final String smartQuoteOpen = "\u201c";
    private static final String smartQuoteClose = "\u201d";
    private static final String htmlEscQuote = "&quot;";
    private static final String chineseChars = "\u963f\u725b\u54e5";
    private static final String fiveHTMLquotes = "&quot;&quot;&quot;&quot;&quot;";
    private static final String TEST_ADD_COMMENT_XML = "TestAddComment.xml";

    public TestAddComment(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testCannotAddCommentWithoutIssue() {
        this.gotoPage("/secure/AddComment.jspa");
        this.assertTextPresent("Add Comment");
        this.assertTextPresent("The issue no longer exists.");
        this.assertTextPresent("You do not have permission to comment on issues in this project.");
    }

    public void testCommentVisiblityOrdering() {
        this.restoreData(TEST_ADD_COMMENT_XML);
        String FIRST_GROUP_NAME = "a group";
        String LAST_GROUP_NAME = "z group";
        this.createGroup("a group");
        this.createGroup("z group");
        this.addUserToGroup("admin", "a group");
        this.addUserToGroup("admin", "z group");
        this.gotoIssue("HSP-1");
        this.clickLink("comment_issue");
        this.setWorkingForm("jiraform");
        String[] commentLevels = this.getDialog().getOptionsFor("commentLevel");
        TestAddComment.assertEquals((int)9, (int)commentLevels.length);
        TestAddComment.assertEquals((String)"All Users", (String)commentLevels[0]);
        TestAddComment.assertEquals((String)"Administrators", (String)commentLevels[1]);
        TestAddComment.assertEquals((String)"Developers", (String)commentLevels[2]);
        TestAddComment.assertEquals((String)"Users", (String)commentLevels[3]);
        TestAddComment.assertEquals((String)"a group", (String)commentLevels[4]);
        TestAddComment.assertEquals((String)"jira-administrators", (String)commentLevels[5]);
        TestAddComment.assertEquals((String)"jira-developers", (String)commentLevels[6]);
        TestAddComment.assertEquals((String)"jira-users", (String)commentLevels[7]);
        TestAddComment.assertEquals((String)"z group", (String)commentLevels[8]);
    }

    public void testAddCommentWithVisibility() {
        String allUsersComment = "This is a comment assigned to all users";
        String jiraUsersGroupComment = "this comment visible to jira-users group";
        String jiraUsersRoleComment = "this is a comment visible to Users role";
        String jiraDevelopersGroupComment = "this is a comment visible to jira-developers group";
        String jiraDevelopersRoleComment = "this is a comment visible to Developers role";
        String jiraAdminsGroupComment = "this is a comment visible to jira-admin group";
        String jiraAdminsRoleComment = "this is a comment visible to Administrators role";
        this.restoreData("TestBlankInstancePlusAFewUsers.xml");
        this.displayAllIssues();
        this.clickLinkWithText("test bug");
        this.addComment("All Users", allUsersComment);
        this.addComment("jira-users", jiraUsersGroupComment);
        this.addComment("Users", jiraUsersRoleComment);
        this.addComment("jira-developers", jiraDevelopersGroupComment);
        this.addComment("Developers", jiraDevelopersRoleComment);
        this.addComment("jira-administrators", jiraAdminsGroupComment);
        this.addComment("Administrators", jiraAdminsRoleComment);
        List userComments = EasyList.build((Object)allUsersComment, (Object)jiraUsersRoleComment, (Object)jiraUsersGroupComment);
        List devComments = EasyList.build((Object)jiraDevelopersGroupComment, (Object)jiraDevelopersRoleComment);
        List adminComments = EasyList.build((Object)jiraAdminsGroupComment, (Object)jiraAdminsRoleComment);
        this.checkCommentVisibility("fred", "HSP-5", userComments, EasyList.mergeLists((List)devComments, (List)adminComments, null));
        this.checkCommentVisibility("admin", "HSP-5", EasyList.mergeLists((List)userComments, (List)devComments, (List)adminComments), null);
        this.checkCommentVisibility("devman", "HSP-5", EasyList.mergeLists((List)devComments, (List)userComments, null), adminComments);
        this.checkCommentVisibility("onlyadmin", "HSP-5", EasyList.mergeLists((List)adminComments, (List)userComments, null), devComments);
    }

    public void testAddCommentErrorWhenLoggedOut() {
        this.restoreData(TEST_ADD_COMMENT_XML);
        this.logout();
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        String theCommentEscaped = "comment with html &lt;input type=&quot;input&quot; id=&quot;invalid&quot;/&gt;";
        this.gotoPage("/secure/AddComment.jspa?id=10000&comment=" + theComment);
        this.assertTextPresent("You are not logged in, and do not have the permissions required to comment on the selected issue as a guest.");
        this.assertTextNotPresent(theComment);
        this.assertTextPresentBeforeText("If you wish to use the comment text you have typed (shown below), please copy it now. This text will be lost when you leave this screen.", theCommentEscaped);
    }

    public void testAddCommentErrorWhenNoPermission() {
        this.restoreData(TEST_ADD_COMMENT_XML);
        this.removeGroupPermission("Default Permission Scheme", 15, "jira-users");
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        String theCommentEscaped = "comment with html &lt;input type=&quot;input&quot; id=&quot;invalid&quot;/&gt;";
        this.gotoPage("/secure/AddComment.jspa?id=10000&comment=" + theComment);
        this.assertTextPresent("Administrator, you do not have the permission to comment on this issue.");
        this.assertTextNotPresent(theComment);
        this.assertTextPresentBeforeText("If you wish to use the comment text you have typed (shown below), please copy it now. This text will be lost when you leave this screen.", theCommentEscaped);
    }

    public void testAddCommentErrorWhenIssueDoesNotExist() {
        this.restoreData(TEST_ADD_COMMENT_XML);
        this.deleteIssue("HSP-1");
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        String theCommentEscaped = "comment with html &lt;input type=&quot;input&quot; id=&quot;invalid&quot;/&gt;";
        this.gotoPage("/secure/AddComment.jspa?id=10000&comment=" + theComment);
        this.assertTextPresent("The issue no longer exists.");
        this.assertTextNotPresent(theComment);
        this.assertTextPresentBeforeText("If you wish to use the comment text you have typed (shown below), please copy it now. This text will be lost when you leave this screen.", theCommentEscaped);
    }

    private void addComment(String visibleTo, String comment) {
        this.clickLink("comment_issue");
        this.selectOption("commentLevel", visibleTo);
        this.setFormElement("comment", comment);
        this.submit();
    }

    public void testAddCommentWithGroupButNotLoggedIn() throws Exception {
        String key = this.addIssue("homosapien", "HSP", "Bug", "Test Issue");
        this.gotoIssue(key);
        this.assertTextPresent("Test Issue");
        String id = this.getIssueIdWithIssueKey(key);
        this.gotoPage("/secure/AddComment.jspa?id=" + id + "&comment=Hello");
        this.assertTextPresent("Test Issue");
        this.assertTextPresent("Hello");
        this.assertTextNotPresent("Ahoj");
        this.gotoPage("/secure/AddComment.jspa?id=" + id + "&comment=Ahoj&commentLevel=group%3Ajira-users");
        this.assertTextPresent("Test Issue");
        this.assertTextPresent("Hello");
        this.assertTextPresent("Ahoj");
        this.addBrowseProjectPermissionToAnonymous();
        this.addCreateCommentPermissionToAnonymous();
        this.activateTimeTracking();
        this.logout();
        this.gotoPage("/secure/AddComment.jspa?id=" + id + "&comment=Hola&commentLevel=group%3Ajira-users");
        this.assertTextNotPresent("NullPointerException");
        this.assertTextPresent("You cannot add a comment for specific groups or roles, as your session has expired. Please log in and try again.");
        this.login("admin", "admin");
    }

    public void testAddCommentCheckUpdatedDate() throws ParseException {
        this.restoreData(TEST_ADD_COMMENT_XML);
        this.gotoIssue("HSP-1");
        String startTag = "<span class=\"date\">";
        String startTagNoQuote = "<span class=date>";
        this.assertTextSequence(new String[]{"Created:", "14/Aug/06 04:26 PM", "Updated:", "<span class=\"date\">", "14/Aug/06 04:26 PM", "</span>", "</font>", "</td>"});
        String commentText = "This is my first test comment!";
        this.assertTextNotPresent("This is my first test comment!");
        this.clickLink("comment_issue");
        this.setFormElement("comment", "This is my first test comment!");
        this.submit();
        this.assertTextPresent("This is my first test comment!");
        String responseText = this.getResponseText();
        String commentSource = responseText.substring(responseText.indexOf("added a comment"));
        String dateString = commentSource.substring(commentSource.indexOf("<span class=date>") + "<span class=date>".length(), commentSource.indexOf("</span>"));
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yy hh:mm a");
        Date date = format.parse(dateString);
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm a");
        String timeString = timeFormat.format(date);
        this.assertTextSequence(new String[]{"Created:", "14/Aug/06 04:26 PM", "Updated:", "<span class=\"date\">", "Today " + timeString, "</span>", "</font>", "</td>"});
    }

    private void addBrowseProjectPermissionToAnonymous() {
        this.goToDefaultPermissionScheme();
        this.clickLink("add_perm_10");
        this.checkCheckbox("type", "group");
        this.submit(" Add ");
    }

    private void addCreateCommentPermissionToAnonymous() {
        this.goToDefaultPermissionScheme();
        this.clickLink("add_perm_15");
        this.checkCheckbox("type", "group");
        this.submit(" Add ");
    }

    private void goToDefaultPermissionScheme() {
        this.clickLink("admin_link");
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Default Permission Scheme");
    }
}

