/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import java.util.ArrayList;
import java.util.List;

public class TestBundledPlugins2
extends FuncTestCase {
    private static final List<String> plugins = new ArrayList<String>();

    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testBundledPluginsPresent() {
        this.navigation.gotoAdminSection("plugins");
        WebPageLocator webPageLocator = new WebPageLocator(this.tester);
        for (String pluginName : plugins) {
            this.log("Testing if plugin '" + pluginName + "' is enabled...");
            this.text.assertTextPresent(webPageLocator, pluginName);
            this.tester.clickLinkWithText(pluginName);
            this.tester.assertLinkNotPresentWithText("Enable plugin");
        }
    }

    static {
        plugins.add("Shared Application Access Layer API");
        plugins.add("Shared Application Access Layer JIRA Plugin");
        plugins.add("Atlassian Template Renderer API");
        plugins.add("Atlassian Template Renderer Velocity 1.6 Plugin");
        plugins.add("Atlassian REST - Module Types");
        plugins.add("Gadget Dashboard Plugin");
        plugins.add("Gadget Renderer Plugin");
        plugins.add("Gadget Directory Plugin");
        plugins.add("Gadget Spec Publisher Plugin");
        plugins.add("JIRA REST Plugin");
        plugins.add("Atlassian OAuth Consumer Plugin");
        plugins.add("JIRA OAuth Consumer SPI Plugin");
        plugins.add("Atlassian OAuth Service Provider Plugin");
        plugins.add("JIRA OAuth Service Provider SPI Plugin");
        plugins.add("JIRA Activity Stream Plugin");
        plugins.add("JIRA Gadgets Plugin");
    }
}

