/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.ztests.bulk.BulkChangeIssues;

public class TestBulkWorkflowTransition
extends BulkChangeIssues {
    protected static final String NOT_AVAILABLE_BULK_EDIT = "NOTE: This field is not available for bulk update operations.";
    protected static final String WORKFLOW_TRANSITION_CHOOSE_ERROR_TEXT = "Please select a transition to execute";
    protected static final String WORKFLOW_TRANSITION_EDIT_TEXT = "Select and edit the fields available on this transition.";
    protected static final String WORKFLOW_TRANSITION_MULTI_PROJECT_ERROR = "NOTE: This operation can be performed only on issues from ONE project.";
    protected static final String WORKFLOW_TRANSITION_SELECTION_TEXT = "Select the workflow transition to execute on the associated issues";
    private boolean afterJdk13;
    private static final String COMMENT_1 = "This issue is resolved now.";
    private static final String COMMENT_2 = "Viewable by developers group.";
    private static final String COMMENT_3 = "Viewable by Developers role.";
    protected Navigation navigation;

    public TestBulkWorkflowTransition(String name) {
        super(name);
    }

    public void setUp() {
        this.init();
        this.afterJdk13 = this.isAfterJdk13();
        FuncTestHelperFactory factory = new FuncTestHelperFactory(this.tester, this.getEnvironmentData());
        this.navigation = factory.getNavigation();
    }

    public void tearDown() {
        super.tearDown();
    }

    public void testBulkTransitionSessionTimeouts() {
        TestBulkWorkflowTransition.log("Bulk Transition - Test that you get redirected to the session timeout page when jumping into the wizard");
        this.restoreBlankInstance();
        this.beginAt("secure/views/bulkedit/BulkWorkflowTransitionDetails.jspa");
        this.verifyAtSessionTimeoutPage();
        this.beginAt("secure/views/bulkedit/BulkWorkflowTransitionDetailsValidation.jspa");
        this.verifyAtSessionTimeoutPage();
        this.beginAt("secure/views/bulkedit/BulkWorkflowTransitionEditValidation.jspa");
        this.verifyAtSessionTimeoutPage();
    }

    public void testNotAvailableFields() {
        this.restoreData("TestBulkWorkflowTransition.xml");
        this.grantGlobalPermission(33, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("jira_2_6");
        this.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
        this.assertTableRowsEqual("editfields", 14, new String[][]{{"N/A", "Change Attachment:", NOT_AVAILABLE_BULK_EDIT}});
        this.assertTableRowsEqual("editfields", 25, new String[][]{{"N/A", "Change Summary:", NOT_AVAILABLE_BULK_EDIT}});
        this.assertTableRowsEqual("editfields", 27, new String[][]{{"N/A", "Change Time Tracking:", NOT_AVAILABLE_BULK_EDIT}});
        this.assertTableRowsEqual("editfields", 1, new String[][]{{"N/A", "Change Fix Version/s:", WORKFLOW_TRANSITION_MULTI_PROJECT_ERROR}});
        this.assertTableRowsEqual("editfields", 5, new String[][]{{"N/A", "Change Patched Version:", WORKFLOW_TRANSITION_MULTI_PROJECT_ERROR}});
        this.assertTableRowsEqual("editfields", 15, new String[][]{{"N/A", "Change Component/s:", WORKFLOW_TRANSITION_MULTI_PROJECT_ERROR}});
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testResolutionErrorIfNotSelected() {
        this.grantGlobalPermission(33, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("jira_2_6");
        this.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
        this.navigation.clickOnNext();
        this.assertTextPresent("The selected resolution is invalid.");
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testWorkflowTransitionCompleteWalkthrough() {
        this.restoreData("TestBulkWorkflowTransition.xml");
        this.enableAttachments();
        this.setShownFields("Attachment");
        this.grantGlobalPermission(33, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("jira_5_5");
        this.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
        this.assertAllFieldsPresent();
        this.assertWikiRendererCommentField();
        this.editAllFields();
        this.navigation.clickOnNext();
        this.assertTextPresent("Please confirm the details of this operation");
        this.assertAllEditFieldsInUpdatedFieldTable();
        this.navigation.clickOnNext();
        this.assertTextInTable("issuetable", "Resolved");
        this.assertTextInTable("issuetable", "Fixed");
        this.gotoIssue("TSTWO-6");
        this.assertTableRowsEqual("tab1", 0, new String[][]{{"Test Run Date:", "29/Nov/05 04:27 PM"}});
        this.assertTableRowsEqual("tab1", 1, new String[][]{{"Operating System:", "Linux"}});
        this.assertTableRowsEqual("tab1", 2, new String[][]{{"Test Run Number:", "1"}});
        this.assertTableRowsEqual("tab1", 3, new String[][]{{"Web Address:", "http://www.atlassian.com"}});
        this.assertTableRowsEqual("tab1", 4, new String[][]{{"Management Comments:", "Functional test - management comment"}});
        this.assertTableRowsEqual("tab1", 5, new String[][]{{"Affected Business Units:", "Development"}});
        this.assertTableRowsEqual("tab1", 6, new String[][]{{"Affected Users:", "Administrator"}});
        this.assertTableRowsEqual("tab1", 7, new String[][]{{"Related Projects:", "Test Project 1"}});
        this.assertTableRowsEqual("tab1", 8, new String[][]{{"End User:", "Administrator"}});
        this.assertTableRowsEqual("tab1", 9, new String[][]{{"LImtied Text Field:", "Func Test - Limited text Field"}});
        this.assertTableRowsEqual("tab1", 10, new String[][]{{"Release Date:", "21/Dec/05"}});
        this.assertTableRowsEqual("issuedetails", 1, new String[][]{{"Type:", "New Feature"}});
        this.assertTableRowsEqual("issuedetails", 2, new String[][]{{"Status:", "Resolved"}});
        this.assertTableRowsEqual("issuedetails", 3, new String[][]{{"Resolution:", "Fixed"}});
        this.assertTableRowsEqual("issuedetails", 4, new String[][]{{"Priority:", "Critical"}});
        this.assertTextPresent("Bulk Edit Comment");
        this.removeGlobalPermission(33, "jira-users");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Resolved", (Object)"resolution", (Object)"Fixed"), null, "TSTWO-6");
        this.assertIndexedFieldCorrect("//comments", EasyMap.build((Object)"comment", (Object)"&lt;p&gt;Bulk Edit Comment&lt;/p&gt;"), null, "TSTWO-6");
        this.assertIndexedFieldCorrect("//customfield/customfieldvalues", EasyMap.build((Object)"customfieldvalue", (Object)"Linux"), null, "TSTWO-6");
    }

    public void testWorkflowTransitionConcurrentIssueUpdate() {
        this.restoreData("TestBulkTransition.xml");
        this.clickLink("find_link");
        this.submit("show");
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10011", "on");
        this.checkCheckbox("bulkedit_10010", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.submit("Next");
        this.checkCheckbox("wftransition", "jira_2_6");
        this.submit("Next");
        this.selectOption("resolution", "Won't Fix");
        this.submit("Next");
        IssueTransitioner issueTransitioner = new IssueTransitioner();
        issueTransitioner.setEnvironmentData(this.getEnvironmentData());
        issueTransitioner.init();
        issueTransitioner.closeIssue("HSP-2");
        this.submit("Next");
        this.assertTextNotInTable("issueTable", new String[]{"Open", "Reopen"});
    }

    public void testWorkflowTransitionEditFieldErrors() {
        this.restoreData("TestBulkWorkflowTransition.xml");
        this.grantGlobalPermission(33, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("jira_5_5");
        this.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
        this.generateMultipleInputErrors();
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testWorkflowTransitionErrorOnWorkflowSelection() {
        this.restoreData("TestBulkWorkflowTransition.xml");
        this.grantGlobalPermission(33, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.clickOnNext();
        this.assertTextPresent(WORKFLOW_TRANSITION_CHOOSE_ERROR_TEXT);
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testBulkTransitionWithCommentVisibility() {
        this.restoreData("TestBulkWorkflowTransition.xml");
        this.enableCommentGroupVisibility(Boolean.TRUE);
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.checkCheckbox("bulkedit_10009", "on");
        this.checkCheckbox("bulkedit_10008", "on");
        this.submit("Next");
        this.assertTextPresent("Choose the operation you wish to perform");
        this.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.assertTextPresent(WORKFLOW_TRANSITION_SELECTION_TEXT);
        this.navigation.workflows().chooseWorkflowAction("jira_5_5");
        this.selectOption("resolution", "Fixed");
        this.checkCheckbox("commentaction", "comment");
        this.setFormElement("comment", COMMENT_1);
        this.navigation.clickOnNext();
        this.assertTextPresent("Please confirm the details of this operation");
        this.navigation.clickOnNext();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.checkCheckbox("bulkedit_10009", "on");
        this.checkCheckbox("bulkedit_10008", "on");
        this.submit("Next");
        this.assertTextPresent("Choose the operation you wish to perform");
        this.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.assertTextPresent(WORKFLOW_TRANSITION_SELECTION_TEXT);
        this.navigation.workflows().chooseWorkflowAction("jira_3_4");
        this.checkCheckbox("commentaction", "comment");
        this.selectOption("commentLevel", "jira-developers");
        this.setFormElement("comment", COMMENT_2);
        this.navigation.clickOnNext();
        this.assertTextPresent("Please confirm the details of this operation");
        this.navigation.clickOnNext();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.checkCheckbox("bulkedit_10009", "on");
        this.checkCheckbox("bulkedit_10008", "on");
        this.submit("Next");
        this.assertTextPresent("Choose the operation you wish to perform");
        this.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.assertTextPresent(WORKFLOW_TRANSITION_SELECTION_TEXT);
        this.navigation.workflows().chooseWorkflowAction("jira_5_5");
        this.selectOption("resolution", "Fixed");
        this.checkCheckbox("commentaction", "comment");
        this.selectOption("commentLevel", "Developers");
        this.setFormElement("comment", COMMENT_3);
        this.navigation.clickOnNext();
        this.assertTextPresent("Please confirm the details of this operation");
        this.navigation.clickOnNext();
        this.login("fred", "fred");
        this.gotoIssue("TSTWO-4");
        this.assertTextPresent(COMMENT_1);
        this.assertTextNotPresent(COMMENT_2);
        this.assertTextNotPresent(COMMENT_3);
        this.gotoIssue("TSTWO-5");
        this.assertTextPresent(COMMENT_1);
        this.assertTextNotPresent(COMMENT_2);
        this.assertTextNotPresent(COMMENT_3);
        this.gotoIssue("TSTWO-6");
        this.assertTextNotPresent(COMMENT_1);
        this.assertTextNotPresent(COMMENT_2);
        this.assertTextNotPresent(COMMENT_3);
        this.assertIndexedFieldCorrect("//comments", EasyMap.build((Object)"comment", (Object)"&lt;p&gt;This issue is resolved now.&lt;/p&gt;"), EasyMap.build((Object)"comment", (Object)"&lt;p&gt;Viewable by developers group.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by Developers role.&lt;/p&gt;"), "TSTWO-4");
        this.assertIndexedFieldCorrect("//comments", EasyMap.build((Object)"comment", (Object)"&lt;p&gt;This issue is resolved now.&lt;/p&gt;"), EasyMap.build((Object)"comment", (Object)"&lt;p&gt;Viewable by developers group.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by Developers role.&lt;/p&gt;"), "TSTWO-5");
        this.assertIndexedFieldCorrect("//comments", null, EasyMap.build((Object)"comment", (Object)"&lt;p&gt;This issue is resolved now.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by developers group.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by Developers role.&lt;/p&gt;"), "TSTWO-6");
        this.login("admin", "admin");
        this.gotoIssue("TSTWO-4");
        this.assertTextPresent(COMMENT_1);
        this.assertTextPresent(COMMENT_2);
        this.assertTextPresent(COMMENT_3);
        this.gotoIssue("TSTWO-5");
        this.assertTextPresent(COMMENT_1);
        this.assertTextPresent(COMMENT_2);
        this.assertTextPresent(COMMENT_3);
        this.gotoIssue("TSTWO-6");
        this.assertTextNotPresent(COMMENT_1);
        this.assertTextNotPresent(COMMENT_2);
        this.assertTextNotPresent(COMMENT_3);
        this.assertIndexedFieldCorrect("//comments", EasyMap.build((Object)"comment", (Object)"&lt;p&gt;This issue is resolved now.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by developers group.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by Developers role.&lt;/p&gt;"), null, "TSTWO-4");
        this.assertIndexedFieldCorrect("//comments", EasyMap.build((Object)"comment", (Object)"&lt;p&gt;This issue is resolved now.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by developers group.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by Developers role.&lt;/p&gt;"), null, "TSTWO-5");
        this.assertIndexedFieldCorrect("//comments", null, EasyMap.build((Object)"comment", (Object)"&lt;p&gt;This issue is resolved now.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by developers group.&lt;/p&gt;", (Object)"comment", (Object)"&lt;p&gt;Viewable by Developers role.&lt;/p&gt;"), "TSTWO-6");
    }

    private void assertAllEditFieldsInUpdatedFieldTable() {
        this.assertTableRowsEqual("updatedfields", 1, new String[][]{{"Assignee", "Administrator"}});
        this.assertTableRowsEqual("updatedfields", 2, new String[][]{{"Test Run Date", "29/Nov/05 04:27 PM"}});
        this.assertTableRowsEqual("updatedfields", 3, new String[][]{{"Test Run Number", "1"}});
        this.assertTableRowsEqual("updatedfields", 4, new String[][]{{"Release Date", "21/Dec/05"}});
        this.assertTableRowsEqual("updatedfields", 5, new String[][]{{"Management Comments", "Functional test - management comment"}});
        this.assertTableRowsEqual("updatedfields", 6, new String[][]{{"Affected Business Units", "Development"}});
        this.assertTableRowsEqual("updatedfields", 7, new String[][]{{"Affected Users", "Administrator"}});
        this.assertTableRowsEqual("updatedfields", 8, new String[][]{{"Related Projects", "Test Project 1"}});
        this.assertTableRowsEqual("updatedfields", 9, new String[][]{{"End User", "Administrator"}});
        this.assertTableRowsEqual("updatedfields", 10, new String[][]{{"LImtied Text Field", "Func Test - Limited text Field"}});
        this.assertTableRowsEqual("updatedfields", 11, new String[][]{{"Description", "Func Test - Description"}});
        this.assertTableRowsEqual("updatedfields", 12, new String[][]{{"Due Date", "29/Dec/05"}});
        this.assertTableRowsEqual("updatedfields", 13, new String[][]{{"Environment", "Func test environment"}});
        this.assertTableRowsEqual("updatedfields", 14, new String[][]{{"Issue Type", "New Feature"}});
        this.assertTableRowsEqual("updatedfields", 15, new String[][]{{"Operating System", "Linux"}});
        this.assertTableRowsEqual("updatedfields", 16, new String[][]{{"Priority", "Critical"}});
        this.assertTableRowsEqual("updatedfields", 17, new String[][]{{"Reporter", "Administrator"}});
        this.assertTableRowsEqual("updatedfields", 18, new String[][]{{"Web Address", "http://www.atlassian.com"}});
        this.assertTableRowsEqual("updatedfields", 19, new String[][]{{"Resolution", "Fixed"}});
        this.assertTableRowsEqual("updatedfields", 20, new String[][]{{"Comment", "Bulk Edit Comment"}});
    }

    private void assertAllFieldsPresent() {
        this.assertTextPresent("Change Resolution:");
        this.assertTextPresent("Change Fix Version/s:");
        this.assertTextPresent("Change Assignee:");
        this.assertTextPresent("Change Test Run Date:");
        this.assertTextPresent("Change Test Run Number:");
        this.assertTextPresent("Change Patched Version:");
        this.assertTextPresent("Change Release Date:");
        this.assertTextPresent("Change Management Comments:");
        this.assertTextPresent("Change Affected Business Units:");
        this.assertTextPresent("Change Affected Users:");
        this.assertTextPresent("Change Related Projects:");
        this.assertTextPresent("Change End User:");
        this.assertTextPresent("Change LImtied Text Field:");
        this.assertTextPresent("Change Affects Version/s:");
        this.assertTextPresent("Change Component/s:");
        this.assertTextPresent("Change Description:");
        this.assertTextPresent("Change Due Date:");
        this.assertTextPresent("Change Environment:");
        this.assertTextPresent("Change Import Id:");
        this.assertTextPresent("Change Issue Type:");
        this.assertTextPresent("Change Operating System:");
        this.assertTextPresent("Change Priority:");
        this.assertTextPresent("Change Read Only Field:");
        this.assertTextPresent("Change Reporter:");
        this.assertTextPresent("Change Summary:");
        this.assertTextPresent("Change Web Address:");
        this.assertTextPresent("Change Time Tracking:");
        this.assertTextPresent("Change Comment:");
    }

    private void assertWikiRendererCommentField() {
        if (this.afterJdk13) {
            this.assertTextPresent("comment-preview_link");
            this.assertLinkPresent("viewHelp");
        }
    }

    private void editAllFields() {
        this.checkCheckbox("actions", "resolution");
        this.selectOption("resolution", "Fixed");
        this.checkCheckbox("actions", "assignee");
        this.selectOption("assignee", "Administrator");
        this.checkCheckbox("actions", "customfield_10000");
        this.setFormElement("customfield_10000", "29/Nov/2005 04:27 PM");
        this.checkCheckbox("actions", "customfield_10003");
        this.setFormElement("customfield_10003", "1");
        this.checkCheckbox("actions", "customfield_10006");
        this.setFormElement("customfield_10006", "21/Dec/2005");
        this.checkCheckbox("actions", "customfield_10007");
        this.setFormElement("customfield_10007", "Functional test - management comment");
        this.checkCheckbox("actions", "customfield_10008");
        this.checkCheckbox("customfield_10008", "Development");
        this.checkCheckbox("actions", "customfield_10009");
        this.setFormElement("customfield_10009", "admin");
        this.checkCheckbox("actions", "customfield_10010");
        this.selectOption("customfield_10010", "Test Project 1");
        this.checkCheckbox("actions", "customfield_10013");
        this.setFormElement("customfield_10013", "admin");
        this.checkCheckbox("actions", "customfield_10014");
        this.setFormElement("customfield_10014", "Func Test - Limited text Field");
        this.checkCheckbox("actions", "description");
        this.setFormElement("description", "Func Test - Description");
        this.checkCheckbox("actions", "duedate");
        this.setFormElement("duedate", "29/Dec/2005");
        this.checkCheckbox("actions", "environment");
        this.setFormElement("environment", "Func test environment");
        this.checkCheckbox("actions", "issuetype");
        this.selectOption("issuetype", "New Feature");
        this.checkCheckbox("actions", "customfield_10002");
        this.selectOption("customfield_10002", "Linux");
        this.checkCheckbox("actions", "priority");
        this.selectOption("priority", "Critical");
        this.checkCheckbox("actions", "reporter");
        this.setFormElement("reporter", "admin");
        this.checkCheckbox("actions", "customfield_10004");
        this.setFormElement("customfield_10004", "http://www.atlassian.com");
        this.checkCheckbox("commentaction", "comment");
        this.setFormElement("comment", "Bulk Edit Comment");
    }

    private void generateMultipleInputErrors() {
        this.checkCheckbox("actions", "resolution");
        this.selectOption("resolution", "Fixed");
        this.checkCheckbox("actions", "duedate");
        this.setFormElement("duedate", "functest");
        this.checkCheckbox("actions", "customfield_10000");
        this.setFormElement("customfield_10000", "functest");
        this.checkCheckbox("actions", "customfield_10004");
        this.setFormElement("customfield_10004", "functest");
        this.checkCheckbox("actions", "customfield_10006");
        this.setFormElement("customfield_10006", "functest");
        this.checkCheckbox("actions", "customfield_10009");
        this.setFormElement("customfield_10009", "functest");
        this.navigation.clickOnNext();
        this.assertTextPresent("You did not enter a valid date. Please enter the date in the format");
        this.assertTextPresent("Invalid date / time format");
        this.assertTextPresent("Not a valid URL");
        this.assertTextPresent("Invalid date format. Please enter the date in the format \"d/MMM/yy\".");
    }

    private void verifyAtSessionTimeoutPage() {
        this.assertTextPresent("Your session timed out while you were in the process of performing a bulk workflow transition.");
    }

    protected void _testToOperationDetailsWorkflowTranisition() {
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.assertTextPresent("Select the issues you wish to operate on");
        this.bulkChangeChooseIssuesAll();
        this.assertTextPresent("Choose the operation you wish to perform");
        this.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.assertTextPresent(WORKFLOW_TRANSITION_SELECTION_TEXT);
    }

    protected void restoreWithGlobalWorkflowPermission(String restoreXml) {
        this.restoreData(restoreXml);
        this.grantGlobalPermission(33, "jira-users");
    }

    private static final class IssueTransitioner
    extends JIRAWebTest {
        public IssueTransitioner() {
            super("IssueTransitioner");
        }

        void closeIssue(String issueKey) {
            this.gotoIssue(issueKey);
            this.clickLink("action_id_2");
            this.submit("Close Issue");
        }
    }
}

