/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.webtests.ztests.bulk.TestBulkWorkflowTransition;

public class TestBulkWorkflowTranistionEnterprise
extends TestBulkWorkflowTransition {
    public TestBulkWorkflowTranistionEnterprise(String name) {
        super(name);
    }

    public void setUp() {
        this.init();
        FuncTestHelperFactory factory = new FuncTestHelperFactory(this.tester, this.getEnvironmentData());
        this.navigation = factory.getNavigation();
    }

    public void tearDown() {
        this.navigation.login("admin", "admin");
        this.removeGlobalPermission(33, "jira-users");
        super.tearDown();
    }

    public void testBulkWorkFlowTransitionMultipleWorkflowsExists() {
        this.restoreWithGlobalWorkflowPermission("TestBulkWorkflowTransitionEnterprise.xml");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.clickOnNext();
        this.navigation.workflows().assertStepOperationDetails();
        this.assertTablePresent("workflow_0");
        this.assertTablePresent("workflow_1");
    }

    public void testForMultipleTabs() {
        this.restoreWithGlobalWorkflowPermission("TestBulkWorkflowTransitionEnterprise.xml");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("jira_5_5");
        this.assertTextPresent("Select and edit the fields available on this transition.");
        this.assertTextPresent("Second Tab");
    }

    public void testForIssueSchemeConflictsBetweenProjects() {
        this.restoreWithGlobalWorkflowPermission("TestBulkWorkflowTransitionEnterprise2.xml");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("jira_5_5");
        this.assertTextPresent("Select and edit the fields available on this transition.");
        this.clickLinkWithText("Second Tab");
        this.assertTableRowsEqual("tab2", 17, new String[][]{{"N/A", "Change Security Level:", "NOTE: The projects of the selected issues are associated with different issue level security schemes."}});
        this.selectOption("resolution", "Fixed");
        this.navigation.clickOnNext();
        this.assertTextPresent("Please confirm the details of this operation");
        this.navigation.clickOnNext();
        this.assertTextInTable("issuetable", "Resolved");
        this.assertTextInTable("issuetable", "Fixed");
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testForIssueSchemeAvailableForIssuesOfProjects() {
        this.restoreWithGlobalWorkflowPermission("TestBulkWorkflowTransitionEnterprise3.xml");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("jira_5_5");
        this.assertTextPresent("Select and edit the fields available on this transition.");
        this.checkCheckbox("actions", "resolution");
        this.selectOption("resolution", "Fixed");
        this.clickLinkWithText("Second Tab");
        this.checkCheckbox("actions", "security");
        this.selectOption("security", "High");
        this.navigation.clickOnNext();
        this.assertTextInTable("updatedfields", "High");
        this.assertTextInTable("updatedfields", "Fixed");
        this.navigation.clickOnNext();
        this.gotoIssue("TST-1");
        this.assertTextPresent("High");
        this.assertTextPresent("Fixed");
        this.assertTextPresent("Resolved");
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testEnsurePostFunctionExecutedInWorkflow() {
        this.restoreWithGlobalWorkflowPermission("TestBulkWorkflowTransitionEnterprise.xml");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("Second Workflow_2_6");
        this.assertTextPresent("Select and edit the fields available on this transition.");
        this.checkCheckbox("actions", "resolution");
        this.selectOption("resolution", "Fixed");
        this.clickLinkWithText("Second Tab");
        this.checkCheckbox("actions", "description");
        this.setFormElement("description", "Functional Test description");
        this.navigation.clickOnNext();
        this.assertTextInTable("updatedfields", "Fixed");
        this.assertTextInTable("updatedfields", "Functional Test description");
        this.navigation.clickOnNext();
        this.gotoIssue("TSTWO-1");
        this.assertTextPresent("Post Function has been fired");
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testFunkyWorkflowName() {
        this.restoreWithGlobalWorkflowPermission("TestBulkWorkflowTransitionEnterprise4.xml");
        this._testToOperationDetailsWorkflowTranisition();
        this.checkCheckbox("wftransition", "Second_Workflow_4_3");
        this.submit("Next");
        this.assertTextPresent("Select and edit the fields available on this transition.");
    }

    public void testCustomFieldContextAndIssueTypeBehaviour() {
        this.restoreData("TestBulkWorkflowTranistionForCustomFieldContextAndIssueType.xml");
        this.displayAllIssues();
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10002", "on");
        this.checkCheckbox("bulkedit_10001", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.submit("Next");
        this.navigation.workflows().chooseWorkflowAction("jira_5_5");
        this.assertTextPresent("Select and edit the fields available on this transition.");
        this.checkCheckbox("actions", "resolution");
        this.selectOption("resolution", "Fixed");
        this.checkCheckbox("actions", "customfield_10000");
        this.setFormElement("customfield_10000", "Setting Monkey Custom Field");
        this.assertTableRowsEqual("editfields", 4, new String[][]{{"N/A", "Change Man Custom Field:", "NOTE: The field is not available for all issues with the same configuration."}});
        this.checkCheckbox("actions", "customfield_10010");
        this.checkCheckbox("customfield_10010", "Monkey");
        this.checkCheckbox("actions", "customfield_10011");
        this.setFormElement("customfield_10011", "Setting the global field");
        this.checkCheckbox("actions", "customfield_10012");
        this.setFormElement("customfield_10012", "8/Sep/06");
        this.navigation.clickOnNext();
        this.assertTextInTable("updatedfields", "Fixed");
        this.assertTextInTable("updatedfields", "Setting Monkey Custom Field");
        this.assertTextInTable("updatedfields", "Monkey");
        this.assertTextInTable("updatedfields", "Setting the global field");
        this.assertTextInTable("updatedfields", "08/Sep/06");
        this.navigation.clickOnNext();
        this.gotoIssue("MKY-2");
        this.assertTableRowsEqual("tab1", 0, new String[][]{{"Monkey Custom Field:", "Setting Monkey Custom Field"}});
        this.assertTableRowsEqual("tab1", 1, new String[][]{{"Man And Monkey Custom Field:", "Monkey"}});
        this.assertTableRowsEqual("tab1", 2, new String[][]{{"Global Field:", "Setting the global field"}});
        this.assertTableRowsEqual("tab1", 3, new String[][]{{"Bug Only Field:", "08/Sep/06"}});
        this.assertIndexedFieldCorrect("//customfields/customfield/customfieldvalues", EasyMap.build((Object)"customfieldvalue", (Object)"Setting Monkey Custom Field", (Object)"customfieldvalue", (Object)"Monkey", (Object)"customfieldvalue", (Object)"Setting the global field"), null, "MKY-2");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"resolution", (Object)"Fixed", (Object)"status", (Object)"Resolved"), null, "MKY-2");
    }
}

