/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.webtests.ztests.bulk.BulkChangeIssues;

public class TestBulkMoveIssues
extends BulkChangeIssues {
    protected static final String TARGET_PROJECT = "Target Project";
    protected static final String PROJECT_KEYWORD = "Project";
    protected static final String ERROR_MOVE_PERMISSION = "You do not have the permission to move one or more of the selected issues";
    protected static final String STD_ISSUE_SELECTION = "Select Projects and Issue Types";
    private static final String MONKEY_PID_OPTION = "10000_1_pid";
    protected static final String TARGET_PROJECT_ID = "10000_1_pid";
    protected static final String RANDOM_ISSUE_SUMMARY = "random_50";
    protected static final String CHECKBOX_RETAIN_PREFIX = "retain_";
    public static final String SAME_FOR_ALL = "sameAsBulkEditBean";
    private static final String BULK_EDIT_KEY = "10000_1_";

    public TestBulkMoveIssues(String name) {
        super(name);
    }

    public void testBulkMove() {
        TestBulkMoveIssues.log("Bulk Move - Tests for Standard Version");
        this.restoreData("TestBulkMoveIssues.xml");
        this.grantGlobalPermission(33, "jira-users");
        this._testMoveOperationUnavailableNoMovePermission();
        this._testMoveSTDComponentsAndVersionsRequiredFailure();
        this._testRetainRequiredComponentAndVersions();
        this._testDontRetainRequiredComponentAndVersions();
        this._testDontRetainNotRequiredComponentAndVersions();
        this._testRetainNotRequiredComponentAndVersions();
        this._testRetainNotRequiredNotSelectedComponentAndVersions();
        this._testDontRetainNotRequiredNotSelectedComponentAndVersions();
        this.removeGlobalPermission(33, "jira-users");
    }

    public void _testMoveOperationUnavailableNoMovePermission() {
        TestBulkMoveIssues.log("Bulk Move - move operation is not available without the move permission");
        this.removeGroupPermission("Default Permission Scheme", 25, "jira-developers");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.assertTextPresent(ERROR_MOVE_PERMISSION);
        this.grantGroupPermission("Default Permission Scheme", 25, "jira-developers");
    }

    public void _testMoveSTDComponentsAndVersionsRequiredFailure() {
        TestBulkMoveIssues.log("Bulk Move - STD - components and versions required - failure");
        this.setRequiredFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "neanderthal");
        this.clickOnNext();
        this.clickOnNext();
        this.assertErrorMsgFieldRequired("Component/s", "neanderthal", "components");
        this.assertErrorMsgFieldRequired("Fix Version/s", "neanderthal", "versions");
        this.assertErrorMsgFieldRequired("Affects Version/s", "neanderthal", "versions");
        this.resetFields();
    }

    public void _testRetainRequiredComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Retain, components and versions Required, Select new values");
        this.resetFields();
        this.addIssue("monkey", "MKY", "Bug", "issueKey1", "Major", null, null, null, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 5"}, null, "", "", null, null, null);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"summary", (Object)"issueKey2", (Object)"priority", (Object)"Major"), null, issueKey2);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"summary", (Object)"issueKey3", (Object)"priority", (Object)"Major", (Object)"version", (Object)"New Version 4"), null, issueKey3);
        this.setRequiredFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "homosapien");
        this.clickOnNext();
        this.assertTextPresent("Update Fields for Target Project");
        this.assertTextPresent("Issues not in the project <strong>homosapien</strong> will not retain values for <strong>Fix Version/s</strong>");
        this.assertTextPresent("Issues not in the project <strong>homosapien</strong> will not retain values for <strong>Affects Version/s</strong>");
        this.assertTextPresent("Issues not in the project <strong>homosapien</strong> will not retain values for <strong>Component/s</strong>");
        this.selectOption("components", "New Component 1");
        this.selectOption("fixVersions", "New Version 1");
        this.selectOption("versions", "New Version 2");
        this.selectCheckbox("retain_components");
        this.selectCheckbox("retain_fixVersions");
        this.selectCheckbox("retain_versions");
        this.clickOnNext();
        this.isStepConfirmation();
        this.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("issueKey1", "HSP");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkNotPresentWithText("monkey");
        this.assertTextPresentBeforeText("Component/s", "New Component 1");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 1");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 2");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)issueKey1, (Object)"component", (Object)"New Component 1", (Object)"fixVersion", (Object)"New Version 1", (Object)"version", (Object)"New Version 2"), null, issueKey1);
        this.gotoIssue(issueKey2);
        this.assertTextPresentBeforeText("Component/s", "New Component 2");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 1");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 2");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)issueKey2, (Object)"component", (Object)"New Component 2", (Object)"fixVersion", (Object)"New Version 1", (Object)"version", (Object)"New Version 2"), null, issueKey2);
        this.gotoIssue(issueKey3);
        this.assertTextPresentBeforeText("Component/s", "New Component 3");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 5");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 4");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)issueKey3, (Object)"component", (Object)"New Component 3", (Object)"fixVersion", (Object)"New Version 5", (Object)"version", (Object)"New Version 4"), null, issueKey3);
        this.resetFields();
    }

    public void _testDontRetainRequiredComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Dont Retain, components and versions Required, Select new values");
        this.addIssue("monkey", "MKY", "Bug", "issueKey1", "Major", null, null, null, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 5"}, null, "", "", null, null, null);
        this.setRequiredFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "homosapien");
        this.clickOnNext();
        this.assertTextPresent("Update Fields for Target Project");
        this.selectOption("components", "New Component 1");
        this.selectOption("fixVersions", "New Version 1");
        this.selectOption("versions", "New Version 2");
        this.assertCheckboxNotSelected("retain_components");
        this.assertCheckboxNotSelected("retain_fixVersions");
        this.assertCheckboxNotSelected("retain_versions");
        this.clickOnNext();
        this.isStepConfirmation();
        this.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("issueKey1", "HSP");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkNotPresentWithText("monkey");
        this.assertTextPresentBeforeText("Component/s", "New Component 1");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 1");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 2");
        this.gotoIssue(issueKey2);
        this.assertTextPresentBeforeText("Component/s", "New Component 1");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 1");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 2");
        this.gotoIssue(issueKey3);
        this.assertTextPresentBeforeText("Component/s", "New Component 1");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 1");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 2");
        this.resetFields();
    }

    public void _testDontRetainNotRequiredComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Dont Retain, components and versions Not Required, Select new values");
        this.addIssue("monkey", "MKY", "Bug", "Make this unique", "Major", null, null, new String[]{"New Version 3"}, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 3"}, null, "", "", null, null, null);
        this.resetFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "monkey");
        this.clickOnNext();
        this.isStepSetFields();
        this.assertTextPresentBeforeText("components", "Unknown");
        this.selectOption("fixVersions", "New Version 5");
        this.selectOption("versions", "New Version 5");
        this.assertCheckboxNotSelected("retain_components");
        this.assertCheckboxNotSelected("retain_fixVersions");
        this.assertCheckboxNotSelected("retain_versions");
        this.clickOnNext();
        this.isStepConfirmation();
        this.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("Make this unique", "MKY");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("monkey");
        this.assertLinkNotPresentWithText("homosapien");
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 5");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 5");
        this.gotoIssue(issueKey2);
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 5");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 5");
        this.gotoIssue(issueKey3);
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 5");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 5");
        this.resetFields();
    }

    private void isStepSetFields() {
        this.assertTextPresent("Update Fields for Target Project");
        TestBulkMoveIssues.log("Step Set Fields");
    }

    public void _testRetainNotRequiredComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Retain, components and versions Not Required, Select new values");
        this.addIssue("monkey", "MKY", "Bug", "issueKey1", "Major", null, null, new String[]{"New Version 3"}, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 3"}, null, "", "", null, null, null);
        this.resetFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "monkey");
        this.clickOnNext();
        this.isStepSetFields();
        this.assertTextPresentBeforeText("components", "Unknown");
        this.selectOption("fixVersions", "New Version 5");
        this.selectOption("versions", "New Version 5");
        this.selectCheckbox("retain_components");
        this.selectCheckbox("retain_fixVersions");
        this.selectCheckbox("retain_versions");
        this.clickOnNext();
        this.isStepConfirmation();
        this.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("issueKey1", "MKY");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("monkey");
        this.assertLinkNotPresentWithText("homosapien");
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 3");
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.gotoIssue(issueKey2);
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "None");
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.gotoIssue(issueKey3);
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 5");
        this.assertTextPresentBeforeText("Affects Version/s", "New Version 5");
        this.resetFields();
    }

    public void _testRetainNotRequiredNotSelectedComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Retain, components and versions Not Required, Dont Select new values");
        this.addIssue("monkey", "MKY", "Bug", "issueKey1", "Major", null, null, new String[]{"New Version 3"}, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 3"}, null, "", "", null, null, null);
        this.resetFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "monkey");
        this.clickOnNext();
        this.isStepSetFields();
        this.assertTextPresentBeforeText("components", "Unknown");
        this.selectCheckbox("retain_components");
        this.selectCheckbox("retain_fixVersions");
        this.selectCheckbox("retain_versions");
        this.clickOnNext();
        this.isStepConfirmation();
        this.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("issueKey1", "MKY");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("monkey");
        this.assertLinkNotPresentWithText("homosapien");
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "New Version 3");
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.gotoIssue(issueKey2);
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "None");
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.gotoIssue(issueKey3);
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "None");
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.resetFields();
    }

    public void _testDontRetainNotRequiredNotSelectedComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Dont Retain, components and versions Not Required, Dont Select new values");
        this.addIssue("monkey", "MKY", "Bug", "issueKey1", "Major", null, null, new String[]{"New Version 3"}, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 3"}, null, "", "", null, null, null);
        this.resetFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "monkey");
        this.clickOnNext();
        this.isStepSetFields();
        this.assertTextPresentBeforeText("components", "Unknown");
        this.assertCheckboxNotSelected("retain_components");
        this.assertCheckboxNotSelected("retain_fixVersions");
        this.assertCheckboxNotSelected("retain_versions");
        this.clickOnNext();
        this.isStepConfirmation();
        this.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("issueKey1", "MKY");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("monkey");
        this.assertLinkNotPresentWithText("homosapien");
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "None");
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.gotoIssue(issueKey2);
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "None");
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.gotoIssue(issueKey3);
        this.assertTextPresentBeforeText("Component/s", "None");
        this.assertTextPresentBeforeText("Fix Version/s", "None");
        this.assertTextPresentBeforeText("Affects Version/s", "None");
        this.resetFields();
    }
}

