/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.webtests.ztests.bulk.BulkChangeIssues;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class TestBulkDeleteIssues
extends BulkChangeIssues {
    private boolean mailServerExists = false;
    private static final String SESSION_TIMEOUT_MESSAGE = "Your session timed out while you were in the process bulk deleting issues.";

    public TestBulkDeleteIssues(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
    }

    public void testBulkDeleteIssues() {
        this.restoreData("TestBulkChangeInitialised.xml");
        this.mailServerExists = this.isMailServerExists();
        this.removeGlobalPermission(33, "jira-users");
        this._testBulkDeleteIssueWithoutBulkChangePermission();
        this.grantGlobalPermission(33, "jira-users");
        this._testBulkDeleteOneIssueInCurrentPage();
        this._testBulkDeleteOneIssueInAllPages();
        this._testBulkDeleteAllIssuesInCurrentPage();
        this._testBulkDeleteAllIssuesInAllPages();
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testBulkDeleteIssuesLimited() throws Exception {
        this.restoreData("TestBulkDeleteIssuesLimited.xml");
        this.mailServerExists = this.isMailServerExists();
        this.displayAllIssues();
        this.assertTextPresent("Bulk changes are currently limited to 1,000 issues.");
        this.clickLinkWithText("maximum 1,000 issues");
        this.assertTextPresent("Bulk changes are currently limited to 1,000 issues.");
        this.bulkChangeChooseIssuesAll();
        WebLink webLink = this.getDialog().getResponse().getLinkWithID("bulkedit_chooseissues");
        String[] tempMax = webLink.getParameterValues("tempMax");
        TestBulkDeleteIssues.assertEquals((int)1, (int)tempMax.length);
        TestBulkDeleteIssues.assertEquals((String)"1000", (String)tempMax[0]);
        this.bulkChangeChooseOperationDelete(this.mailServerExists);
        this.bulkChangeConfirm();
        this.displayAllIssues();
        this.assertIssueNavigatorDisplaying("1", "50", "1031");
    }

    public void _testBulkDeleteIssueWithoutBulkChangePermission() {
        TestBulkDeleteIssues.log("Bulk Change - Delete Operation: No global Bulk Change permission");
        String summary = "BulkDeleteWithoutBulkChangePermission";
        this.addCurrentPageLink();
        this.addIssue(summary);
        this.displayAllIssues();
        this.assertTextNotPresent("Bulk Change");
    }

    public void _testBulkDeleteOneIssueInCurrentPage() {
        TestBulkDeleteIssues.log("Bulk Change - Delete Operation: ONE issue from CURRENT page");
        String summary = "DeleteOneIssueInCurrentPages";
        this.addCurrentPageLink();
        String key = this.addIssue(summary);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)key, (Object)"summary", (Object)summary), null, key);
        this.displayAllIssues();
        this.bulkChangeIncludeCurrentPage();
        this.bulkChangeSelectIssue(key);
        this.bulkChangeChooseOperationDelete(this.mailServerExists);
        this.assertLinkPresentWithText(summary);
        this.bulkChangeConfirm();
        this.checkIssueIsDeleted(summary);
        this.assertIssueNotIndexed(key);
    }

    private void assertIssueNotIndexed(String key) {
        TestBulkDeleteIssues.log("Checking that item " + key + " was deleted in the index.");
        this.assertPageDoesNotExist("Index was not removed", "/si/jira.issueviews:issue-xml/" + key + "/" + key + ".xml?jira.issue.searchlocation=index");
    }

    public void _testBulkDeleteOneIssueInAllPages() {
        TestBulkDeleteIssues.log("Bulk Change - Delete Operation: ONE issue from ALL pages");
        String summary = "DeleteOneIssueInAllPages";
        String key = this.addIssue(summary);
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue(key);
        this.bulkChangeChooseOperationDelete(this.mailServerExists);
        this.assertLinkPresentWithText(summary);
        this.bulkChangeConfirm();
        this.checkIssueIsDeleted(summary);
        this.assertIssueNotIndexed(key);
    }

    public void _testBulkDeleteAllIssuesInCurrentPage() {
        TestBulkDeleteIssues.log("Bulk Change - Delete Operation: All issue from CURRENT page");
        String prefix = "pre_";
        this.addIssues(prefix, 50);
        this.addCurrentPageLink();
        List issueIds = this.getAllIssueIdsFromBulkEditTable();
        this.displayAllIssues();
        this.bulkChangeIncludeCurrentPage();
        this.bulkChangeChooseIssuesAll();
        this.bulkChangeChooseOperationDelete(this.mailServerExists);
        this.checkIssuesAreListed(prefix, 50);
        this.bulkChangeConfirm();
        this.checkIssuesAreNotListed(prefix, 50);
        for (String key : issueIds) {
            this.assertIssueNotIndexed(key);
        }
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)"HSP-40"), null, "HSP-40");
    }

    private List getAllIssueIdsFromBulkEditTable() {
        this.displayAllIssues();
        ArrayList<String> issueIds = new ArrayList<String>();
        try {
            WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
            for (int i = 1; i < issueTable.getRowCount(); ++i) {
                String key = issueTable.getTableCell(i, 1).asText().trim();
                issueIds.add(key);
            }
        }
        catch (SAXException e) {
            TestBulkDeleteIssues.fail((String)"table not found ... issuetable");
        }
        return issueIds;
    }

    public void _testBulkDeleteAllIssuesInAllPages() {
        TestBulkDeleteIssues.log("Bulk Change - Delete Operation: All issue from ALL pages");
        this.addCurrentPageLink();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.bulkChangeChooseOperationDelete(this.mailServerExists);
        this.bulkChangeConfirm();
        this.displayAllIssues();
        this.assertTextPresent("No matching issues found");
    }

    public void testBulkDeleteSessionTimeouts() {
        TestBulkDeleteIssues.log("Bulk Delete - Test that you get redirected to the session timeout page when jumping into the wizard");
        this.restoreBlankInstance();
        this.beginAt("secure/views/bulkedit/BulkDeleteDetails.jspa");
        this.assertTextPresent(SESSION_TIMEOUT_MESSAGE);
        this.beginAt("secure/BulkDeleteDetailsValidation.jspa");
        this.assertTextPresent(SESSION_TIMEOUT_MESSAGE);
    }
}

