/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class TestIssueFileAttachments
extends JIRAWebTest {
    private static String issueKey;
    private static final String DUMMY_FILE_NAME = "DummyAttachment";
    private static final String DUMMY_FILE_CONTENT = "This is a dummy file with no real purpose in life.";
    private static final String DUMMY_FILE_COMMENT = "Dummy file attatchment.";
    private static final String DELLINK_PREFIX = "del_";
    private static final String LOGIN = "log in";
    private static final String LOGIN_BUTTON = "login";

    public TestIssueFileAttachments(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueFileAttatchements() {
        this.restoreBlankInstance();
        try {
            this.enableAttachments();
            issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 1: File Attatchments", "Minor", null, null, null, "Administrator", "test environment 1", "test description for global", null, null, null);
            this.authorizedFileAttach();
            this.authorizedFileDownload();
            this.cancelAttachmentDeletion();
            this.confirmAttachmentDeletion();
            this._testWeirdFilename();
        }
        finally {
            this.deleteIssue(issueKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueFileAttachmentEnableThumbnailsAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.enableAttachments();
            this.logout();
            this.login("admin", "admin");
            this.gotoAdmin();
            this.clickLink("attachments");
            this.assertTextNotPresent("OFF");
            this.clickLinkWithText("Edit Configuration");
            this.checkCheckbox("thumbnailsEnabled", "false");
            this.submit("Update");
            this.assertTextPresentAfterText("OFF", "Enable Thumbnails");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComponentAndVersionOrdering() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.enableAttachments();
            this.checkComponentOrdering("10000");
            this.checkVersionOrdering("10000");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    public void checkComponentOrdering(String issueId) {
        TestIssueFileAttachments.log("Testing ordering for components field");
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageAttachments.jspa?id=" + issueId);
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 3"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageAttachments.jspa?id=" + issueId);
        this.assertTextSequence(new String[]{"Component/s", "New Component 2", "New Component 3"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageAttachments.jspa?id=" + issueId);
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageAttachments.jspa?id=" + issueId);
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2", "New Component 3"});
    }

    public void checkVersionOrdering(String issueId) {
        String[] versionFields = new String[]{"versions", "fixVersions"};
        String[] versionFieldNames = new String[]{"Affects Version/s", "Fix Version/s"};
        for (int i = 0; i < versionFields.length; ++i) {
            String versionField = versionFields[i];
            String versionFieldName = versionFieldNames[i];
            TestIssueFileAttachments.log("Testing ordering for versions field '" + versionField + "'");
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageAttachments.jspa?id=" + issueId);
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageAttachments.jspa?id=" + issueId);
            this.assertTextSequence(new String[]{versionFieldName, "New Version 4", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageAttachments.jspa?id=" + issueId);
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageAttachments.jspa?id=" + issueId);
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=" + issueId);
            this.tester.setWorkingForm("jiraform");
            this.uncheckCheckbox(versionField);
            this.tester.submit("Update");
        }
    }

    public void authorizedFileAttach() {
        TestIssueFileAttachments.log("Issue File Attachment: Test simple attachment of a file by an authorized user.");
        this.attachFile(issueKey);
        this.assertTextPresent(DUMMY_FILE_NAME);
    }

    public void authorizedFileDownload() {
        TestIssueFileAttachments.log("Issue File Attachment: Test viewing attachment of a file by an authorized user.");
        this.gotoIssue(issueKey);
        this.assertLinkPresentWithText(DUMMY_FILE_NAME);
        this.clickLinkWithText(DUMMY_FILE_NAME);
        this.assertTextPresent(DUMMY_FILE_CONTENT);
        this.beginAt("/secure/Dashboard.jspa");
    }

    public void cancelAttachmentDeletion() {
        TestIssueFileAttachments.log("Issue File Attachment: Test cancel deletion of file attachment");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description", null, null, null);
        String issueId = this.getIssueIdWithIssueKey(issueKey);
        String attachmentId = this.attachFile(issueKey);
        this.gotoAttachmentDeletionScreen(attachmentId, DUMMY_FILE_NAME);
        this.assertFormElementPresent("ManageAttachments.jspa?id=" + issueId);
        this.clickButton("cancelButton");
        this.assertTextNotPresent("Remove Attachment:");
        this.assertLinkPresent(DELLINK_PREFIX + attachmentId);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.deleteIssue(issueKey);
    }

    public void confirmAttachmentDeletion() {
        TestIssueFileAttachments.log("Issue File Attachment: Test confirm deletion of file attachment");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description", null, null, null);
        String attachmentId = this.attachFile(issueKey);
        this.gotoAttachmentDeletionScreen(attachmentId, DUMMY_FILE_NAME);
        this.submit("Delete");
        this.assertTextNotPresent("Remove Attachment:");
        this.assertLinkNotPresent(DELLINK_PREFIX + attachmentId);
        this.deleteIssue(issueKey);
    }

    public void _testWeirdFilename() {
        String filename = "(test'file)";
        String encodedFilename = "(test&apos;file)";
        this.gotoIssue(issueKey);
        this.clickLink("attach_file");
        this.attachFile(TestIssueFileAttachments.generateAttachment(filename, DUMMY_FILE_CONTENT), DUMMY_FILE_COMMENT);
        this.assertTextPresent(filename);
        this.clickLinkWithText(filename);
        this.gotoPage("/browse/" + issueKey);
        TestIssueFileAttachments.log("Checking that " + encodedFilename + " is correctly placed in XML issue view");
        this.clickLinkWithText("XML");
        TestIssueFileAttachments.assertTrue((boolean)"text/xml".equals(this.getDialog().getResponse().getContentType()));
        this.assertTextPresent(encodedFilename);
        this.gotoPage("/browse/" + issueKey);
        TestIssueFileAttachments.assertTrue((boolean)this.getDialog().getResponse().getContentType().equals("text/html"));
        TestIssueFileAttachments.log("Checking that " + filename + " is correctly placed in Word view");
        this.clickLinkWithText("Word");
        this.assertTextPresent(filename);
        this.gotoPage("/browse/" + issueKey);
        TestIssueFileAttachments.assertTrue((boolean)this.getDialog().getResponse().getContentType().equals("text/html"));
        TestIssueFileAttachments.log("Checking that " + filename + " is correctly placed in printable issue view");
        this.clickLinkWithText("Printable");
        this.assertTextPresent(filename);
        this.gotoPage("/browse/" + issueKey);
    }

    public void testCommentVisibility() {
        this.restoreData("TestBlankInstancePlusAFewUsers.xml");
        this.enableAttachments();
        String roleUsers = "role:10000";
        String roleDev = "role:10001";
        String roleAdmin = "role:10002";
        this.enableAttachments();
        this.enableCommentGroupVisibility(Boolean.TRUE);
        String USER_COMMENT1 = "should be viewable by jira-users";
        String USER_COMMENT2 = "should be viewable by All Users";
        String ADMIN_COMMENT1 = "should be viewable by admins group";
        String ADMIN_COMMENT2 = "should be viewable by admins role";
        String DEV_COMMENT1 = "should be viewable by developer group";
        String DEV_COMMENT2 = "should be viewable by developer role";
        this.attachFileWithcomment("HSP-2", TestIssueFileAttachments.generateAttachment("filename1", "some text"), ADMIN_COMMENT1, "group:jira-administrators");
        this.attachFileWithcomment("HSP-2", TestIssueFileAttachments.generateAttachment("filename2", "some text"), ADMIN_COMMENT2, roleAdmin);
        this.attachFileWithcomment("HSP-2", TestIssueFileAttachments.generateAttachment("filename3", "some text"), DEV_COMMENT1, "group:jira-developers");
        this.attachFileWithcomment("HSP-2", TestIssueFileAttachments.generateAttachment("filename4", "some text"), DEV_COMMENT2, roleDev);
        this.attachFileWithcomment("HSP-2", TestIssueFileAttachments.generateAttachment("filename5", "some text"), USER_COMMENT1, "group:jira-users");
        this.attachFileWithcomment("HSP-2", TestIssueFileAttachments.generateAttachment("filename6", "some text"), USER_COMMENT2, roleUsers);
        List devComments = EasyList.build((Object)DEV_COMMENT1, (Object)DEV_COMMENT2);
        List adminComments = EasyList.build((Object)ADMIN_COMMENT1, (Object)ADMIN_COMMENT2);
        List userComments = EasyList.build((Object)USER_COMMENT1, (Object)USER_COMMENT2);
        this.checkCommentVisibility("devman", "HSP-2", EasyList.mergeLists((List)devComments, (List)userComments, null), adminComments);
        this.checkCommentVisibility("onlyadmin", "HSP-2", EasyList.mergeLists((List)adminComments, (List)userComments, null), devComments);
        this.checkCommentVisibility("fred", "HSP-2", userComments, EasyList.mergeLists((List)devComments, (List)adminComments, null));
    }

    public void testDeleteOwnAttachmentWithOwnPermission() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.logout();
        this.login("detkin", "detkin");
        String attachmentId = this.attachFile("TST-1");
        this.gotoAttachmentDeletionScreen(attachmentId, DUMMY_FILE_NAME);
        this.submit("Delete");
        this.assertTextNotPresent("Remove Attachment:");
        this.assertLinkNotPresent(DELLINK_PREFIX + attachmentId);
    }

    public void testDeleteAttachmentWithAllPermission() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.logout();
        this.login("detkin", "detkin");
        String attachmentId = this.attachFile("TST-1");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue("TST-1");
        this.clickLinkWithText("File Attachments");
        this.gotoAttachmentDeletionScreen(attachmentId, DUMMY_FILE_NAME);
        this.submit("Delete");
        this.assertTextNotPresent("Remove Attachment:");
        this.assertLinkNotPresent(DELLINK_PREFIX + attachmentId);
    }

    public void testDeleteOthersAttachmentWithOwnPermission() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.logout();
        this.login("detkin", "detkin");
        String attachmentId = this.attachFile("TST-1");
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.clickLinkWithText("File Attachments");
        this.assertTextNotPresent("Remove Attachment:");
        this.assertLinkNotPresent(DELLINK_PREFIX + attachmentId);
    }

    public void testManageAttachmentLinkShowsWithNoCreatePermAndOnlyDeleteOwn() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.logout();
        this.login("detkin", "detkin");
        this.attachFile("TST-1");
        this.logout();
        this.login("admin", "admin");
        this.removeRolePermission(19, 10000);
        this.logout();
        this.login("detkin", "detkin");
        this.gotoIssue("TST-1");
        this.assertLinkWithTextExists("File Attachments");
    }

    public void testManageAttachmentLinkHiddenWithNoCreatePermAndOnlyDeleteOwnNoAuthoredAttachment() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.logout();
        this.login("detkin", "detkin");
        this.attachFile("TST-1");
        this.logout();
        this.login("admin", "admin");
        this.removeRolePermission(19, 10000);
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.assertLinkWithTextNotPresent("File Attachments");
    }

    public void testManageAttachmentLinkShowsWithNoCreatePermAndDeleteAllNoAuthoredAttachment() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.logout();
        this.login("detkin", "detkin");
        this.attachFile("TST-1");
        this.logout();
        this.login("admin", "admin");
        this.removeRolePermission(19, 10000);
        this.logout();
        this.login("detkin", "detkin");
        this.gotoIssue("TST-1");
        this.assertLinkWithTextExists("File Attachments");
    }

    public void testAttachmentLinksPresentWhenUserHasCreatePermission() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.attachFile("TST-1");
        this.gotoIssue("TST-1");
        this.assertLinkPresent("attach_file");
        this.assertLinkPresentWithText("File Attachments");
        this.clickLinkWithText("File Attachments");
        this.assertLinkPresentWithText("Attach more files");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Download");
    }

    public void testAddAttachmentLinksNotPresentWhenUserHasNoCreatePermission() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.attachFile("TST-1");
        this.removeRolePermission(19, 10000);
        this.gotoIssue("TST-1");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkPresentWithText("File Attachments");
        this.clickLinkWithText("File Attachments");
        this.assertLinkNotPresentWithText("Attach more files");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Download");
    }

    public void testModifyAttachmentLinksNotPresentWhenIssueInNonEditableWorkflowState() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.attachFile("TST-1");
        this.gotoIssue("TST-1");
        this.clickLinkWithText("Close Issue");
        this.submit("Close Issue");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkPresentWithText("File Attachments");
        this.clickLinkWithText("File Attachments");
        this.assertLinkNotPresentWithText("Attach more files");
        this.assertLinkNotPresentWithText("Delete");
        this.assertLinkPresentWithText("Download");
    }

    public void attachFileWithcomment(String issueKey, File attachment, String comment, String commentLevel) {
        this.gotoIssue(issueKey);
        this.clickLink("attach_file");
        this.assertTextPresent("Attach File");
        WebForm[] wfs = null;
        try {
            wfs = this.getTestContext().getWebClient().getCurrentPage().getForms();
        }
        catch (SAXException e) {
            TestIssueFileAttachments.log(e.getMessage(), e);
        }
        WebForm wf = wfs[1];
        UploadFileSpec[] attachments = new UploadFileSpec[]{new UploadFileSpec(attachment)};
        wf.setParameter("filename.1", attachments);
        wf.setParameter("comment", comment);
        wf.setParameter("commentLevel", commentLevel);
        this.submit("Attach");
    }

    public void testManageAttachmentsWithNoPermissions() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        File image = new File(this.environmentData.getXMLDataLocation(), "xss_exploit_files/1179826282.png");
        this.attachFile("TST-1", image);
        this.gotoIssue("TST-1");
        this.assertLinkPresentWithText("File Attachments:");
        this.assertLinkPresentWithText("Image Attachments:");
        this.logout();
        this.login("admin", "admin");
        this.removeRolePermission(19, 10000);
        this.removeRolePermission(38, 10000);
        this.removeRolePermission(39, 10000);
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.assertLinkNotPresentWithText("File Attachments:");
        this.assertLinkNotPresentWithText("Image Attachments:");
        this.gotoPage("/secure/ManageAttachments.jspa?id=10000");
        this.assertLinkNotPresentWithText("Attach more files");
        this.assertLinkNotPresentWithText("Delete");
        this.assertLinkPresentWithText("Download");
    }

    public void testManageAttachmentsWhenNotLoggedIn() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.attachFile("TST-1");
        this.logout();
        this.gotoPage("/secure/ManageAttachments.jspa?id=10000");
        this.assertTextNotPresent("This page allows you to manage the attachments for a particular issue");
        this.assertTextSequence(new String[]{"You are not logged in.", "You cannot view this URL as a guest."});
    }

    public void testCreateAttachmentsWithNoPermissions() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.attachFile("TST-1");
        this.logout();
        this.login("admin", "admin");
        this.removeRolePermission(19, 10000);
        this.removeRolePermission(38, 10000);
        this.removeRolePermission(39, 10000);
        this.logout();
        this.login("barney", "barney");
        this.gotoPage("/secure/AttachFile!default.jspa?id=10000");
        this.assertTextPresent("You do not have permission to create attachments for this issue.");
        this.assertSubmitButtonNotPresent("Attach");
    }

    public void testDeleteAttachmentsWithNoPermissions() {
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
        this.attachFile("TST-1");
        this.logout();
        this.login("admin", "admin");
        this.removeRolePermission(19, 10000);
        this.removeRolePermission(38, 10000);
        this.removeRolePermission(39, 10000);
        this.logout();
        this.login("barney", "barney");
        this.gotoPage("/secure/DeleteAttachment!default.jspa?id=10000&deleteAttachmentId=10010");
        this.submit("Delete");
        this.assertTextPresent("You do not have permission to delete attachment with id: 10010");
    }

    public void testViewAttachmentsWithNoPermissions() throws IOException, SAXException {
        this.restoreData("TestViewAttachmentServletPermissionViolation.xml");
        this.enableAttachments();
        this.attachFile("HSP-1");
        this.logout();
        this.login("joe");
        this.gotoPage("/secure/attachment/10020/DummyAttachment");
        this.assertTextSequence(new String[]{"ACCESS DENIED", "It seems that you have tried to perform an operation which you are not permitted to perform."});
        this.assertTextNotPresent("You cannot view this URL as a guest");
        this.assertLinkWithTextNotPresent(LOGIN);
        this.assertTextNotPresent("os_destination=%2Fsecure%2Fattachment%2F10020%2FDummyAttachment");
        String header = this.getDialog().getResponse().getHeaderField("cache-control");
        TestIssueFileAttachments.assertNotNull((Object)header);
        TestIssueFileAttachments.assertTrue((header.indexOf("no-cache") != -1 ? 1 : 0) != 0);
        this.logout();
        this.gotoPage("/secure/attachment/10020/DummyAttachment");
        this.assertTextSequence(new String[]{"ACCESS DENIED", "It seems that you have tried to perform an operation which you are not permitted to perform."});
        this.assertTextPresent("You cannot view this URL as a guest");
        this.assertLinkWithTextExists(LOGIN);
        this.assertTextPresent("os_destination=%2Fsecure%2Fattachment%2F10020%2FDummyAttachment");
        header = this.getDialog().getResponse().getHeaderField("cache-control");
        TestIssueFileAttachments.assertNotNull((Object)header);
        TestIssueFileAttachments.assertTrue((header.indexOf("no-cache") != -1 ? 1 : 0) != 0);
        this.clickLinkWithText(LOGIN);
        this.setFormElement("os_username", "admin");
        this.setFormElement("os_password", "admin");
        this.clickButton(LOGIN_BUTTON);
        header = this.getDialog().getResponse().getHeaderField("cache-control");
        TestIssueFileAttachments.assertNull((Object)header);
        this.assertTextPresent(DUMMY_FILE_CONTENT);
    }

    public void testCreateAttachmentsWhenAttachmentsAreDisabled() {
        this.restoreData("TestDeleteAttachments.xml");
        this.gotoPage("/secure/AttachFile!default.jspa?id=10000");
        this.submit("Attach");
        this.assertTextPresent("Attachments have been disabled for this instance of JIRA.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentLinksNotPresentWhenIssueOperationPluginDisabled() {
        try {
            this.restoreData("TestDeleteAttachments.xml");
            this.enableAttachments();
            this.attachFile("TST-1");
            this.gotoIssue("TST-1");
            this.assertLinkPresentWithText("File Attachments");
            this.clickLinkWithText("File Attachments");
            this.assertLinkPresentWithText("Attach more files");
            this.gotoAdmin();
            this.clickLink("plugins");
            this.clickLinkWithText("Issue Operations Plugin");
            this.clickLink("disable-com.atlassian.jira.plugin.system.issueoperations:attach-file");
            this.gotoIssue("TST-1");
            this.assertLinkPresentWithText("File Attachments");
            this.clickLinkWithText("File Attachments");
            this.assertLinkNotPresentWithText("Attach more files");
        }
        finally {
            this.gotoAdmin();
            this.clickLink("plugins");
            this.clickLinkWithText("Issue Operations Plugin");
            this.clickLink("enable-com.atlassian.jira.plugin.system.issueoperations:attach-file");
        }
    }

    private String attachFile(String issueKey) {
        return this.attachFile(issueKey, null);
    }

    private String attachFile(String issueKey, File attachFile) {
        this.gotoIssue(issueKey);
        this.assertLinkPresent("attach_file");
        this.clickLink("attach_file");
        if (attachFile == null) {
            File file = TestIssueFileAttachments.generateAttachment(DUMMY_FILE_NAME, DUMMY_FILE_CONTENT);
            this.attachFile(file, DUMMY_FILE_COMMENT);
        } else {
            this.attachFile(attachFile, attachFile.getAbsolutePath());
        }
        try {
            String[] strings;
            WebLink[] webLinks = this.getDialog().getResponse().getMatchingLinks(new HTMLElementPredicate(){

                public boolean matchesCriteria(Object o, Object argument) {
                    WebLink link = (WebLink)o;
                    return link.getID() != null && link.getID().startsWith(TestIssueFileAttachments.DELLINK_PREFIX);
                }
            }, null);
            if (webLinks == null || webLinks.length == 0) {
                TestIssueFileAttachments.fail((String)"Unable to find attachment id: No attachment delete links present.");
            }
            if ((strings = webLinks[0].getParameterValues("deleteAttachmentId")) == null || strings.length != 1 || StringUtils.isBlank((String)strings[0])) {
                TestIssueFileAttachments.fail((String)"Unable to find attachement id: Delete attachement link does not list attachment.");
            }
            return strings[0];
        }
        catch (Exception e) {
            TestIssueFileAttachments.fail((String)("Unable to retrieve Attachment Id, ex: " + e.getMessage()));
            return "fail";
        }
    }

    private void gotoAttachmentDeletionScreen(String attachmentId, String fileName) {
        this.clickLink(DELLINK_PREFIX + attachmentId);
        this.assertTextPresentBeforeText("Remove Attachment:", fileName);
    }
}

