/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.assertions.HTMLAssertionsImpl;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.File;

public class TestIssueFileAttachmentErrors
extends JIRAWebTest {
    public TestIssueFileAttachmentErrors(String name) {
        super(name);
    }

    protected void setUpHttpUnitOptions() {
        TestIssueFileAttachmentErrors.log("not running normal test setup for " + this.getName());
        JIRAEnvironmentData jiraEnvironmentData = this.getEnvironmentData();
        this.tester.getTestContext().setBaseUrl(jiraEnvironmentData.getBaseUrl().toExternalForm());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestDeleteAttachments.xml");
        this.enableAttachments();
    }

    public void tearDown() {
        TestIssueFileAttachmentErrors.log("not running normal test teardown for " + this.getName());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
    }

    public void testViewAttachmentWithNonNumericId() {
        this.assertErrorResponse("/secure/attachment/idontparse/DummyAttachment", 404, "Attachment not found (id idontparse)");
    }

    public void testViewAttachmentWithNoPath() {
        this.assertErrorResponse("/secure/attachment/", 400, "Invalid attachment path");
    }

    public void testFileNotFoundWhenAttachmentNotOnDisk() {
        File file = TestIssueFileAttachmentErrors.generateAttachment("DummyAttachment", "This is a dummy file with no real purpose in life.");
        this.attachFile("TST-1", file, "");
        file = new File(this.administration.getCurrentAttachmentPath() + FS + "TST" + FS + "TST-1", "10010_DummyAttachment");
        if (!file.delete()) {
            TestIssueFileAttachmentErrors.fail((String)("Could not delete file '" + file.getAbsolutePath() + "' from server"));
        }
        this.assertErrorResponse("/secure/attachment/10010/DummyAttachment", 500, "Could not find the specified attachment on the server");
    }

    private void assertErrorResponse(String url, int errorCode, String message) {
        this.tester.beginAt(url);
        TestIssueFileAttachmentErrors.assertEquals((int)errorCode, (int)this.tester.getDialog().getResponse().getResponseCode());
        new HTMLAssertionsImpl().assertResponseContains(this.tester, message);
    }
}

