/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.locator.NodeLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.WebTestCaseWrapper;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.xml.sax.SAXException;

public class TestAttachFile
extends JIRAWebTest {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String SAMPLE_IE_USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)";
    private static final FilenameFilter NO_DOT_FILES = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.charAt(0) != '.';
        }
    };
    private static final String MIME_SNIFFING_WORKAROUND = "workaround";
    private static final String MIME_SNIFFING_OWNED = "insecure";
    private static final String MIME_SNIFFING_PARANOID = "secure";
    private static final String LOGIN = "log in";
    private static final String SIGNUP = "sign up";

    public TestAttachFile(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestFullAnonymousPermissions.xml");
        this.enableAttachments();
    }

    public void tearDown() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        super.tearDown();
    }

    public void testAttachFileLoggedIn() {
        this.disallowAnonymousAttachmentCreation();
        this.gotoIssue("MKY-2");
        this.clickLink("attach_file");
        this.assertTextPresent("Use this form to attach multiple files to this issue. You can also explain what the files are for using a comment.");
        this.assertSubmitButtonPresent("Attach");
    }

    public void testJessionIdLinksDontAppear() throws SAXException {
        this.restoreData("TestAttachmentsWithJessionId.xml");
        this.gotoIssue("MKY-1");
        this.tester.clickLinkWithText("File Attachments:");
        this.tester.assertTextPresent("This page allows you to manage the attachments for a particular issue. Only users with administrative privileges to remove an issue can remove attachments.");
        this.getDialog().getWebClient().clearContents();
        this.gotoPage("/browse/MKY-1");
        this.assertJSessionIdNOTInLinkWith("File Attachments:");
        this.assertJSessionIdNOTInLinkWith("Resolve Issue");
        this.assertJSessionIdNOTInLinkWith("Close Issue");
        this.assertJSessionIdNOTInLinkWith("Assign");
        this.assertJSessionIdNOTInLinkWith("Attach file");
        this.assertJSessionIdNOTInLinkWith("Clone");
        this.assertJSessionIdNOTInLinkWith("Comment");
        this.assertJSessionIdNOTInLinkWith("Delete");
        this.tester.clickLinkWithText("File Attachments:");
        this.tester.assertTextPresent("This page allows you to manage the attachments for a particular issue. Only users with administrative privileges to remove an issue can remove attachments.");
    }

    private void assertJSessionIdNOTInLinkWith(String text) throws SAXException {
        WebLink link = this.getDialog().getResponse().getLinkWith(text);
        TestAttachFile.assertNotNull((String)("Cant find link with text :" + text), (Object)link);
        this.verifyJessionIdNOTInUrl(link.getURLString());
    }

    private void verifyJessionIdNOTInUrl(String url) {
        String JSESSIONID = "jsessionid";
        int index = url.indexOf("jsessionid");
        TestAttachFile.assertTrue((index == -1 ? 1 : 0) != 0);
    }

    public void testAttachNoFileError() {
        this.gotoIssue("MKY-2");
        this.clickLink("attach_file");
        this.assertTextPresent("Use this form to attach multiple files to this issue. You can also explain what the files are for using a comment.");
        this.assertTextNotPresent("Errors");
        this.assertTextNotPresent("Please indicate the file you wish to upload");
        this.submit("Attach");
        this.assertTextPresent("Errors");
        this.assertTextPresent("Please indicate the file you wish to upload");
    }

    public void testAttachFileLoggedOutNoAnonymousPermission() {
        this.disallowAnonymousAttachmentCreation();
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.gotoIssue("MKY-2");
        this.assertLinkNotPresent("attach_file");
        this.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.assertTextPresent("You do not have permission to create attachments for this issue.");
        this.assertTextPresent("You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.assertTextSequence(new String[]{"To attach a file on an issue first ", "for an account"});
        this.assertLinkWithTextExists(LOGIN);
        this.assertLinkWithTextExists(SIGNUP);
        this.assertSubmitButtonNotPresent("Attach");
        this.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.assertTextNotPresent("You do not have permission to create attachments for this issue.");
        this.assertTextNotPresent("You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.assertSubmitButtonNotPresent("Attach");
    }

    public void testAttachFileLoggedOutWithAnonymousPermission() {
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.gotoIssue("MKY-2");
        this.clickLink("attach_file");
        this.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.assertTextPresent("Use this form to attach multiple files to this issue. You can also explain what the files are for using a comment.");
        this.assertSubmitButtonPresent("Attach");
        this.assertTextNotPresent("You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.assertTextNotPresent("You do not have permission to create attachments for this issue.");
        this.assertTextNotPresent("You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.assertSubmitButtonNotPresent("Attach");
    }

    public void testAttachFileLoggedInWithoutPermission() {
        this.disallowAnyoneAttachmentCreation();
        this.gotoIssue("MKY-2");
        this.assertLinkNotPresent("attach_file");
        this.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.assertTextPresent("You do not have permission to create attachments for this issue.");
        this.assertSubmitButtonNotPresent("Attach");
        this.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.assertTextNotPresent("You do not have permission to create attachments for this issue.");
        this.assertTextNotPresent("You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.assertSubmitButtonNotPresent("Attach");
    }

    private void disallowAnonymousAttachmentCreation() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_19_");
        this.submit("Delete");
        this.gotoDashboard();
    }

    private void disallowAnyoneAttachmentCreation() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_19_");
        this.submit("Delete");
        this.clickLink("del_perm_19_jira-users");
        this.submit("Delete");
        this.gotoDashboard();
    }

    public void testFileSizesForSingleAttachmentWithJs() throws SAXException {
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this._testFileSizesForSingleAttachment();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void testFileSizesForSingleAttachmentWithoutJs() throws SAXException {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this._testFileSizesForSingleAttachment();
    }

    public void testIssueCreationFileWithBadCharacters() throws SAXException {
        this.enableAttachmentsField();
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("summary", "bad characters");
        String badChars = "a?file.txt";
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("attachment_field.1", badChars, 1024L);
        this.submit("Create");
        this.assertTextPresent("No files were attached. Please add your attachments again (lost during reload).");
        this.assertTextPresent("The filename of the file contains an invalid character: ?");
    }

    public void testIssueAttachFileWithBadCharacters() throws SAXException {
        this.enableAttachmentsField();
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("summary", "bad characters");
        this.submit("Create");
        this.assertTextPresent("Key:");
        this.clickLink("attach_file");
        String fileName = "a?file.txt";
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("filename.1", fileName, 1024L);
        this.submit("Attach");
        this.assertTextPresent("The filename of the file contains an invalid character: ?");
        this.assertTextPresent("No files were attached. Please add your attachments again (lost during reload).");
    }

    public void testFileWithSpaces() throws SAXException {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this._testFileWithSpaces();
    }

    public void _testFileWithSpaces() throws SAXException {
        this.enableAttachmentsField();
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("summary", "spaces");
        String fileNamSpace = "a file.txt";
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("attachment_field.1", fileNamSpace, 1024L);
        this.submit("Create");
        this.assertTextPresent("Key:");
        this.assertLinkWithTextUrlEndsWith("a file.txt", "a+file.txt");
        this.clickLinkWithText("a file.txt");
        String response = this.getDialog().getResponse().getHeaderField(CONTENT_DISPOSITION);
        TestAttachFile.assertFalse((response.indexOf("a%20file.txt") == -1 ? 1 : 0) != 0);
    }

    public void _testFileSizesForSingleAttachment() throws SAXException {
        this.enableAttachmentsField();
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("summary", "A summary");
        String fileNameInvalid1 = "12mbFile1.txt";
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("attachment_field.1", fileNameInvalid1, 0xC00000L);
        this.submit("Create");
        this.assertTextPresent("Either the file that you specified (" + fileNameInvalid1 + ") does not exist, is zero bytes in size or the total upload size for all files is larger than");
        this.assertTextPresent("Please add your attachments again (lost during reload).");
        String fileNameOk1 = "okFile1.txt";
        bytePatternFileAttacher.attachFile("attachment_field.1", fileNameOk1, 1024L);
        this.submit("Create");
        this.assertTextPresent("Key:");
        this.assertLinkPresentWithText(fileNameOk1);
        this.assertTextNotPresent(fileNameInvalid1);
        this.clickLink("attach_file");
        String fileNameInvalid2 = "12mbFile2.txt";
        bytePatternFileAttacher.attachFile("filename.1", fileNameInvalid2, 0xC00000L);
        this.submit("Attach");
        this.assertTextPresent("Either the file that you specified (" + fileNameInvalid2 + ") does not exist, is zero bytes in size or the total upload size for all files is larger than");
        this.assertTextPresent("Please add your attachments again (lost during reload).");
        String fileNameOk2 = "okFile2.txt";
        bytePatternFileAttacher.attachFile("filename.1", fileNameOk2, 1024L);
        this.submit("Attach");
        this.assertTextPresent("Key:");
        this.assertLinkPresentWithText(fileNameOk1);
        this.assertLinkPresentWithText(fileNameOk2);
        this.assertTextNotPresent(fileNameInvalid1);
        this.assertTextNotPresent(fileNameInvalid2);
    }

    public void testFileSizesForMultipleAttachmentsWithJs() throws SAXException {
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this._testFileSizesForMultipleAttachments();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void testFileSizesForMultipleAttachmentsWithoutJs() throws SAXException {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this._testFileSizesForMultipleAttachments();
    }

    public void _testFileSizesForMultipleAttachments() throws SAXException {
        this.enableAttachmentsField();
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("summary", "A summary");
        String fileNameInvalid1a = "12mbFile1a.txt";
        String fileNameInvalid1b = "12mbFile1b.txt";
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("attachment_field.1", fileNameInvalid1a, 0xC00000L);
        bytePatternFileAttacher.attachFile("attachment_field.2", fileNameInvalid1b, 0xC00000L);
        this.submit("Create");
        this.assertTextNotPresent("Either the file that you specified (" + fileNameInvalid1a + ") does not exist, is zero bytes in size or the total upload size for all files is larger than");
        this.assertTextPresent("Either the file that you specified (" + fileNameInvalid1b + ") does not exist, is zero bytes in size or the total upload size for all files is larger than");
        this.assertTextPresent("Please add your attachments again (lost during reload).");
        String fileNameOk1a = "okFile1a.txt";
        String fileNameOk1b = "okFile1b.txt";
        bytePatternFileAttacher.attachFile("attachment_field.1", fileNameOk1a, 1024L);
        bytePatternFileAttacher.attachFile("attachment_field.2", fileNameOk1b, 1024L);
        this.submit("Create");
        this.assertTextPresent("Key:");
        this.assertLinkPresentWithText(fileNameOk1a);
        this.assertLinkPresentWithText(fileNameOk1b);
        this.assertTextNotPresent(fileNameInvalid1a);
        this.assertTextNotPresent(fileNameInvalid1b);
        this.clickLink("attach_file");
        String fileNameInvalid2a = "12mbFile2a.txt";
        String fileNameInvalid2b = "12mbFile2b.txt";
        bytePatternFileAttacher.attachFile("filename.1", fileNameInvalid2a, 0xC00000L);
        bytePatternFileAttacher.attachFile("filename.2", fileNameInvalid2b, 0xC00000L);
        this.submit("Attach");
        this.assertTextPresent("Either the file that you specified (" + fileNameInvalid2a + ") does not exist, is zero bytes in size or the total upload size for all files is larger than");
        this.assertTextPresent("Either the file that you specified (" + fileNameInvalid2b + ") does not exist, is zero bytes in size or the total upload size for all files is larger than");
        this.assertTextPresent("Please add your attachments again (lost during reload).");
        String fileNameOk2a = "okFile2a.txt";
        String fileNameOk2b = "okFile2b.txt";
        bytePatternFileAttacher.attachFile("filename.1", fileNameOk2a, 1024L);
        bytePatternFileAttacher.attachFile("filename.2", fileNameOk2b, 1024L);
        this.submit("Attach");
        this.assertTextPresent("Key:");
        this.assertLinkPresentWithText(fileNameOk1a);
        this.assertLinkPresentWithText(fileNameOk1b);
        this.assertLinkPresentWithText(fileNameOk2a);
        this.assertLinkPresentWithText(fileNameOk2b);
        this.assertTextNotPresent(fileNameInvalid1a);
        this.assertTextNotPresent(fileNameInvalid1b);
        this.assertTextNotPresent(fileNameInvalid2a);
        this.assertTextNotPresent(fileNameInvalid2b);
    }

    public void testAttachFileAndEditAttachmentSize() throws SAXException {
        this.enableAttachmentsField();
        int attachmentFileSize = 1024;
        int maxSizeInBytes = 1024;
        String maxSizePrettyFormat = "1.0 kB";
        this.enableAttachments(String.valueOf(maxSizeInBytes));
        this.assertTextSequence(new String[]{"Allow Attachments", "ON", "Attachment Path", "Attachment Size", maxSizePrettyFormat, "Enable Thumbnails"});
        String fileName = "createIssueAttachFailure.txt";
        this.attachFileFromCreateIssuePage(fileName, 1024);
        this.assertTextPresent("Either the file that you specified (" + fileName + ") does not exist, is zero bytes in size or the total upload size for all files is larger than " + maxSizePrettyFormat);
        this.assertTextPresent("Please add your attachments again (lost during reload).");
        fileName = "viewIssueAttachFailure.txt";
        this.attachFileFromViewIssuePage(fileName, 1024, new BytePatternFileAttacher());
        this.assertTextPresent("Either the file that you specified (" + fileName + ") does not exist, is zero bytes in size or the total upload size for all files is larger than " + maxSizePrettyFormat);
        this.assertTextPresent("Please add your attachments again (lost during reload).");
        String fileName1 = "createIssueAttachMultipleFailure.txt";
        String fileName2 = "createIssueAttachMultipleFailure.txt";
        this.attachMultipleFileFromCreateIssuePage(fileName1, fileName2, 1024);
        this.assertTextPresent("Either the file that you specified (" + fileName1 + ") does not exist, is zero bytes in size or the total upload size for all files is larger than " + maxSizePrettyFormat);
        this.assertTextPresent("Either the file that you specified (" + fileName2 + ") does not exist, is zero bytes in size or the total upload size for all files is larger than " + maxSizePrettyFormat);
        this.assertTextPresent("Please add your attachments again (lost during reload).");
        fileName1 = "viewIssueAttachMultipleFailure.txt";
        fileName2 = "viewIssueAttachMultipleFailure.txt";
        this.attachMultipleFileFromViewIssuePage(fileName1, fileName2, 1024);
        this.assertTextPresent("Either the file that you specified (" + fileName1 + ") does not exist, is zero bytes in size or the total upload size for all files is larger than " + maxSizePrettyFormat);
        this.assertTextPresent("Either the file that you specified (" + fileName2 + ") does not exist, is zero bytes in size or the total upload size for all files is larger than " + maxSizePrettyFormat);
        this.assertTextPresent("Please add your attachments again (lost during reload).");
        maxSizeInBytes = 2048;
        maxSizePrettyFormat = "2 kB";
        this.enableAttachments(String.valueOf(maxSizeInBytes));
        this.assertTextSequence(new String[]{"Allow Attachments", "ON", "Attachment Path", "Attachment Size", maxSizePrettyFormat, "Enable Thumbnails"});
        fileName = "createIssueAttachSuccess.txt";
        this.attachFileFromCreateIssuePage(fileName, 1024);
        this.assertTextNotPresent("Either the file that you specified (" + fileName + ") does not exist");
        this.assertLinkPresentWithText(fileName);
        fileName = "viewIssueAttachSuccess.txt";
        this.attachFileFromViewIssuePage(fileName, 1024, new BytePatternFileAttacher());
        this.assertTextNotPresent("Either the file that you specified (" + fileName + ") does not exist");
        this.assertLinkPresentWithText(fileName);
        fileName1 = "createIssueAttachMultipleSuccess.txt";
        fileName2 = "createIssueAttachMultipleSuccess.txt";
        this.attachMultipleFileFromCreateIssuePage(fileName1, fileName2, 341);
        this.assertTextNotPresent("Either the file that you specified (" + fileName1 + ") does not exist");
        this.assertTextNotPresent("Either the file that you specified (" + fileName2 + ") does not exist");
        this.assertLinkPresentWithText(fileName1);
        this.assertLinkPresentWithText(fileName2);
        fileName1 = "viewIssueAttachMultipleSuccess.txt";
        fileName2 = "viewIssueAttachMultipleSuccess.txt";
        this.attachMultipleFileFromViewIssuePage(fileName1, fileName2, 341);
        this.assertTextNotPresent("Either the file that you specified (" + fileName1 + ") does not exist");
        this.assertTextNotPresent("Either the file that you specified (" + fileName2 + ") does not exist");
        this.assertLinkPresentWithText(fileName1);
        this.assertLinkPresentWithText(fileName2);
    }

    public void testMimeCasing() throws SAXException {
        this.enableAttachments();
        this.enableAttachmentsField();
        String issueKey = "MKY-2";
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + "image.GIF");
        this.attachFile("MKY-2", file, "");
        this.gotoIssue("MKY-2");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//*[@id=\"file_attachments\"]");
        Assert.assertEquals((String)"None", (String)new NodeLocator(pathLocator.getNode()).getText());
        XPathLocator tableLocator = new XPathLocator(this.tester, "//table[@id=\"attachment_thumbnails\"]");
        Assert.assertEquals((int)1, (int)tableLocator.getNodes().length);
        XPathLocator trLocator = new XPathLocator(tableLocator.getNode(), "tr");
        Assert.assertTrue((boolean)new NodeLocator(trLocator.getNode()).getText().contains("image.GIF"));
    }

    public void testHtmlAttachmentDownloadDefaultMimeSniffingPolicy() throws SAXException {
        this.enableAttachmentsField();
        this.assertExploitFilesHaveDisposition("inline");
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        this.assertAttachmentContentDisposition("screenshot.html", "text/html", "attachment; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "text/html", "attachment; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.htm", "image/png", "attachment; filename*=UTF-8''screenshot-png.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.html", "image/png", "attachment; filename*=UTF-8''screenshot-png.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-html.png", "text/html", "attachment; filename*=UTF-8''screenshot-html.png;", fileAttacher);
        this.assertAttachmentContentDisposition("really-png.png", "image/png", "inline; filename*=UTF-8''really-png.png;", fileAttacher);
    }

    public void testHtmlAttachmentDownloadParanoidMimeSniffingPolicy() throws SAXException {
        this.setMimeSniffingPolicy(MIME_SNIFFING_PARANOID);
        this.enableAttachmentsField();
        this.assertExploitFilesHaveDisposition("attachment");
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        this.assertAttachmentContentDisposition("screenshot.html", "text/html", "attachment; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "text/html", "attachment; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.htm", "image/png", "attachment; filename*=UTF-8''screenshot-png.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.html", "image/png", "attachment; filename*=UTF-8''screenshot-png.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-html.png", "text/html", "attachment; filename*=UTF-8''screenshot-html.png;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.png", "image/png", "attachment; filename*=UTF-8''screenshot.png;", fileAttacher);
    }

    public void testHtmlAttachmentDownloadWorkaroundMimeSniffingPolicy() throws SAXException {
        this.setMimeSniffingPolicy(MIME_SNIFFING_WORKAROUND);
        this.enableAttachmentsField();
        this.assertExploitFilesHaveDisposition("inline");
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        this.assertAttachmentContentDisposition("screenshot.html", "text/html", "attachment; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "text/html", "attachment; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.htm", "image/png", "attachment; filename*=UTF-8''screenshot-png.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.html", "image/png", "attachment; filename*=UTF-8''screenshot-png.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-html.png", "text/html", "attachment; filename*=UTF-8''screenshot-html.png;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.png", "image/png", "inline; filename*=UTF-8''screenshot.png;", fileAttacher);
    }

    public void testHtmlAttachmentDownloadPwnedMimeSniffingPolicy() throws SAXException {
        this.setMimeSniffingPolicy(MIME_SNIFFING_OWNED);
        this.enableAttachmentsField();
        this.assertExploitFilesHaveDisposition("inline");
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        this.assertAttachmentContentDisposition("screenshot.html", "text/html", "inline; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "text/html", "inline; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.htm", "image/png", "inline; filename*=UTF-8''screenshot-png.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.html", "image/png", "inline; filename*=UTF-8''screenshot-png.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-html.png", "text/html", "inline; filename*=UTF-8''screenshot-html.png;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.png", "image/png", "inline; filename*=UTF-8''screenshot.png;", fileAttacher);
    }

    public void testAttachmentDownloadDefaultMimeSniffingPolicyInternetExplorer() throws SAXException {
        this.getDialog().getWebClient().getClientProperties().setUserAgent(SAMPLE_IE_USER_AGENT);
        this.enableAttachmentsField();
        this.assertExploitFilesHaveDisposition("attachment");
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        this.assertAttachmentContentDisposition("screenshot.html", "text/html", "attachment; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "text/html", "attachment; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.htm", "image/png", "attachment; filename*=UTF-8''screenshot-png.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-png.html", "image/png", "attachment; filename*=UTF-8''screenshot-png.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot-html.png", "text/html", "attachment; filename*=UTF-8''screenshot-html.png;", fileAttacher);
        this.assertAttachmentContentDisposition("non-smelly.png", "image/png", "inline; filename*=UTF-8''non-smelly.png;", fileAttacher);
    }

    public void testAttachmentDownloadParanoidMimeSniffingPolicyInternetExplorer() throws SAXException {
        this.getDialog().getWebClient().getClientProperties().setUserAgent(SAMPLE_IE_USER_AGENT);
        this.setMimeSniffingPolicy(MIME_SNIFFING_PARANOID);
        this.enableAttachmentsField();
        this.assertExploitFilesHaveDisposition("attachment");
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        this.assertAttachmentContentDisposition("screenshot.html", "text/html", "attachment; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "text/html", "attachment; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "image/png", "attachment; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.html", "image/png", "attachment; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.png", "text/html", "attachment; filename*=UTF-8''screenshot.png;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.png", "image/png", "attachment; filename*=UTF-8''screenshot.png;", fileAttacher);
    }

    public void testAttachmentDownloadPwnedMimeSniffingPolicyInternetExplorer() throws SAXException {
        this.getDialog().getWebClient().getClientProperties().setUserAgent(SAMPLE_IE_USER_AGENT);
        this.setMimeSniffingPolicy(MIME_SNIFFING_OWNED);
        this.enableAttachmentsField();
        this.assertExploitFilesHaveDisposition("inline");
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        this.assertAttachmentContentDisposition("screenshot.html", "text/html", "inline; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "text/html", "inline; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("png.htm", "image/png", "inline; filename*=UTF-8''png.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("png.html", "image/png", "inline; filename*=UTF-8''png.html;", fileAttacher);
        this.assertAttachmentContentDisposition("html.png", "text/html", "inline; filename*=UTF-8''html.png;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.png", "image/png", "inline; filename*=UTF-8''screenshot.png;", fileAttacher);
    }

    public void testAttachmentDownloadWorkaroundMimeSniffingPolicyInternetExplorer() throws SAXException {
        this.getDialog().getWebClient().getClientProperties().setUserAgent(SAMPLE_IE_USER_AGENT);
        this.setMimeSniffingPolicy(MIME_SNIFFING_WORKAROUND);
        this.enableAttachmentsField();
        this.assertExploitFilesHaveDisposition("attachment");
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        this.assertAttachmentContentDisposition("screenshot.html", "text/html", "attachment; filename*=UTF-8''screenshot.html;", fileAttacher);
        this.assertAttachmentContentDisposition("screenshot.htm", "text/html", "attachment; filename*=UTF-8''screenshot.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("png.htm", "image/png", "attachment; filename*=UTF-8''png.htm;", fileAttacher);
        this.assertAttachmentContentDisposition("png.html", "image/png", "attachment; filename*=UTF-8''png.html;", fileAttacher);
        this.assertAttachmentContentDisposition("html.png", "text/html", "attachment; filename*=UTF-8''html.png;", fileAttacher);
        this.assertAttachmentContentDisposition("png.png", "image/png", "inline; filename*=UTF-8''png.png;", fileAttacher);
    }

    public void testAttachFileFromSubTaskQuickCreateForm() throws Exception {
        this.restoreData("TestAttachmentsInSubTaskQuickCreateForm.xml");
        this.enableAttachments();
        String fileName = "attach1.txt";
        this.attachFileFromSubTaskQuickCreateForm("MKY-2", "attach1.txt", 1024L);
        this.gotoIssue("MKY-3");
        this.assertLinkPresentWithText("attach1.txt");
    }

    private void assertExploitFilesHaveDisposition(String disposition) {
        File exploitDir = new File(this.getEnvironmentData().getXMLDataLocation(), "xss_exploit_files/");
        File[] exploitFiles = exploitDir.listFiles(NO_DOT_FILES);
        for (int i = 0; i < exploitFiles.length; ++i) {
            File exploitFile = exploitFiles[i];
            FilesystemFileAttacher exploitFileAttacher = new FilesystemFileAttacher(exploitFile);
            String expectedDisposition = disposition + "; filename*=UTF-8''" + exploitFile.getName() + ";";
            this.assertAttachmentContentDisposition(null, "application/octet-stream", expectedDisposition, exploitFileAttacher);
        }
    }

    private void enableAttachmentsField() {
        this.gotoPage("secure/admin/ViewIssueFields.jspa");
        try {
            if (this.getDialog().getResponse().getElementWithID("show_2") != null) {
                this.gotoPage("secure/admin/IssueFieldHide.jspa?hide=2");
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void testAttachmentSlashLimiting() throws IOException, SAXException {
        this.enableAttachmentsField();
        BytePatternFileAttacher fileAttacher = new BytePatternFileAttacher();
        String fileName = "screenshot.html";
        String contentType = "text/html";
        String fileNameUsed = this.attachFileFromViewIssuePage("screenshot.html", 1024, "text/html", fileAttacher);
        this.assertLinkPresentWithText(fileNameUsed);
        this.clickLinkWithText(fileNameUsed);
        String badUrl = this.getDialog().getResponse().getURL().toString() + "/morestuff";
        GetMethodWebRequest request = new GetMethodWebRequest(badUrl);
        try {
            this.getDialog().getWebClient().sendRequest((WebRequest)request);
            TestAttachFile.fail((String)"Request to invalid attachment path should have returned 404");
        }
        catch (HttpNotFoundException expected) {
            TestAttachFile.assertEquals((int)404, (int)expected.getResponseCode());
        }
    }

    private void assertAttachmentContentDisposition(String fileName, String contentType, String expectedDisposition, FileAttacher fileAttacher) {
        String fileNameUsed = this.attachFileFromViewIssuePage(fileName, 1024, contentType, fileAttacher);
        this.assertLinkPresentWithText(fileNameUsed);
        this.clickLinkWithText(fileNameUsed);
        String disposition = this.getDialog().getResponse().getHeaderField(CONTENT_DISPOSITION);
        TestAttachFile.assertTrue((String)("Content-Disposition  expected [" + expectedDisposition + "] but found [" + disposition + "]"), (disposition.indexOf(expectedDisposition) >= 0 ? 1 : 0) != 0);
    }

    private void setMimeSniffingPolicy(String policy) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.checkCheckbox("ieMimeSniffer", policy);
        this.submit("Update");
    }

    private void attachFileFromViewIssuePage(String fileName, int attachmentFileSize, FileAttacher fileAttacher) throws SAXException {
        this.attachFileFromViewIssuePage(fileName, attachmentFileSize, "text/plain", fileAttacher);
    }

    private String attachFileFromViewIssuePage(String fileName, int attachmentFileSize, String contentType, FileAttacher fileAttacher) {
        this.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        String fileNameUsed = fileAttacher.attachFile("filename.1", fileName, attachmentFileSize, contentType);
        this.submit("Attach");
        return fileNameUsed;
    }

    private void attachMultipleFileFromViewIssuePage(String fileName1, String fileName2, int attachmentFileSize) throws SAXException {
        this.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("filename.1", fileName1, attachmentFileSize);
        bytePatternFileAttacher.attachFile("filename.2", fileName2, attachmentFileSize);
        this.submit("Attach");
    }

    private void attachFileFromSubTaskQuickCreateForm(String issueKey, String fileName, long attachmentFileSize) throws SAXException {
        this.gotoIssue(issueKey);
        this.setWorkingForm("stqcform");
        this.setFormElement("summary", "New test sub-task");
        this.selectOption("issuetype", "Sub-task");
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("stqcform", "attachment_field.1", fileName, attachmentFileSize, "text/plain");
        this.clickButton("stqc_submit");
        this.assertTextNotPresent("Either the file that you specified (" + fileName + ") does not exist");
    }

    private void attachFileFromCreateIssuePage(String fileName, int attachmentFileSize) throws SAXException {
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("summary", "A summary");
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("attachment_field.1", fileName, attachmentFileSize);
        this.submit("Create");
    }

    private void attachMultipleFileFromCreateIssuePage(String fileName1, String fileName2, int attachmentFileSize) throws SAXException {
        this.clickLink("create_link");
        this.submit("Next>>");
        this.setFormElement("summary", "A summary");
        BytePatternFileAttacher bytePatternFileAttacher = new BytePatternFileAttacher();
        bytePatternFileAttacher.attachFile("attachment_field.1", fileName1, attachmentFileSize);
        bytePatternFileAttacher.attachFile("attachment_field.2", fileName2, attachmentFileSize);
        this.submit("Create");
    }

    static interface FileAttacher {
        public String attachFile(String var1, String var2, String var3, long var4, String var6);

        public String attachFile(String var1, String var2, long var3, String var5);
    }

    private class BytePatternFileAttacher
    implements FileAttacher {
        private Set filesAttachedAlready = new HashSet();

        private BytePatternFileAttacher() {
        }

        void attachFile(String fieldName, String fileName, long size) throws SAXException {
            this.attachFile("jiraform", fieldName, fileName, size, "text/plain");
        }

        public String attachFile(String fieldName, String fileName, long size, String contentType) {
            return this.attachFile("jiraform", fieldName, fileName, size, contentType);
        }

        public String attachFile(String formName, String fieldName, String fileName, long size, String contentType) {
            if (this.filesAttachedAlready.contains(fileName)) {
                WebTestCaseWrapper.log("WARNING! You have already attached a file with " + fieldName);
            }
            UploadFileSpec bigFile = this.getFile(fileName, size, contentType);
            try {
                TestAttachFile.this.getDialog().getResponse().getFormWithName(formName).setParameter(fieldName, new UploadFileSpec[]{bigFile});
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            if (!this.filesAttachedAlready.contains(fileName)) {
                this.filesAttachedAlready.add(fileName);
            }
            return fileName;
        }

        private UploadFileSpec getFile(String fileName, final long size, String contentType) {
            InputStream inputStream = new InputStream(){
                private long readSoFar = 0L;

                public int read() throws IOException {
                    if (this.readSoFar > size) {
                        return -1;
                    }
                    ++this.readSoFar;
                    return 120;
                }
            };
            return new UploadFileSpec(fileName, inputStream, contentType);
        }
    }

    private class FilesystemFileAttacher
    implements FileAttacher {
        private File file;

        private FilesystemFileAttacher(File file) {
            this.file = file;
        }

        public String attachFile(String formName, String fieldName, String fileName, long size, String contentType) {
            try {
                UploadFileSpec ufs = new UploadFileSpec(this.file.getName(), (InputStream)new FileInputStream(this.file), contentType);
                UploadFileSpec[] files = new UploadFileSpec[]{ufs};
                TestAttachFile.this.getDialog().getResponse().getFormWithName(formName).setParameter(fieldName, files);
                return this.file.getName();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        public String attachFile(String fieldName, String fileName, long size, String contentType) {
            return this.attachFile("jiraform", fieldName, fileName, size, contentType);
        }
    }
}

