/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.UploadFileSpec;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class TestAttachBinaryFile
extends JIRAWebTest {
    public TestAttachBinaryFile(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
    }

    public void testAttachFileWithGzip() throws SAXException {
        this.performUpload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUpload() throws SAXException {
        if (!this.isOrion() && !this.isWebSphere()) {
            this.restoreBlankInstance();
            try {
                this.enableAttachments();
                this.turnGzipOn();
                String issueKey = this.addIssue("homosapien", "HSP", "Bug", "summary");
                this.gotoIssue(issueKey);
                this.clickLink("attach_file");
                this.attachFile("filename.1", "binary.doc", 1000L);
                this.submit("Attach");
                this.clickLinkWithText("binary.doc");
            }
            finally {
                this.restoreBlankInstance();
            }
        }
    }

    void turnGzipOn() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.checkCheckbox("useGzip", "true");
        this.submit("Update");
    }

    private void attachFile(String fieldName, String fileName, long size) throws SAXException {
        UploadFileSpec bigFile = this.getFile(fileName, size);
        this.getDialog().getResponse().getFormWithName("jiraform").setParameter(fieldName, new UploadFileSpec[]{bigFile});
    }

    private UploadFileSpec getFile(String fileName, final long size) {
        InputStream inputStream = new InputStream(){
            private long readSoFar = 0L;

            public int read() throws IOException {
                if (this.readSoFar > size) {
                    return -1;
                }
                ++this.readSoFar;
                return 120;
            }
        };
        return new UploadFileSpec(fileName, inputStream, "text/plain");
    }
}

