/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.trustedapps;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class TestTrustedApplications
extends JIRAWebTest {
    private static final String REQUEST_NEW_TRUSTED_APP_DETAILS = "Request New Trusted Application Details";

    public TestTrustedApplications(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestTrustedAppsBlank.xml");
    }

    public void testAdminLinkWorks() {
        this.gotoAdmin();
        this.clickLink("trusted_apps");
        this.assertTextPresent("View Trusted Applications");
        this.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.assertTextPresent("No trusted applications have been configured.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRequestSelf() {
        String trustedAppName = "theTrustedApplicationName";
        this.gotoAdmin();
        this.clickLink("trusted_apps");
        this.setFormElement("trustedAppBaseUrl", this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.submit("Send Request");
        this.setWorkingForm("jiraform");
        this.assertTextPresent("Add New Trusted Application");
        this.setFormElement("name", "theTrustedApplicationName");
        this.assertTextPresent("Application Name:");
        this.assertTextPresent("Application ID:");
        this.assertTextPresent("Timeout:");
        this.assertTextPresent("IP Address Matches:");
        this.assertTextPresent("URL Paths to Allow:");
        this.assertButtonNotPresent("Update");
        this.submit("Add");
        this.assertTextPresent("View Trusted Applications");
        this.assertTextPresent("theTrustedApplicationName");
        this.assertLinkPresent("edit-10010");
        this.assertLinkPresent("delete-10010");
        boolean wasEnabled = HttpUnitOptions.isScriptingEnabled();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        try {
            this.clickLink("edit-10010");
            this.setWorkingForm("jiraform");
            this.assertTextPresent("Edit Trusted Application Details");
            this.assertButtonPresent("Update");
            this.assertButtonNotPresent("Add");
            this.clickCancelButton();
            this.assertTextPresent("View Trusted Applications");
            this.clickLink("delete-10010");
            this.setWorkingForm("jiraform");
            this.assertTextPresent("Delete Trusted Application:");
            this.assertTextPresent("theTrustedApplicationName");
            this.assertButtonPresent("Delete");
            this.clickCancelButton();
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)wasEnabled);
        }
        this.assertTextPresent("View Trusted Applications");
        this.clickLink("delete-10010");
        this.setWorkingForm("jiraform");
        this.submit("Delete");
        this.assertTextPresent("View Trusted Applications");
        this.assertTextNotPresent("theTrustedApplicationName");
        this.assertLinkNotPresent("edit-10010");
        this.assertLinkNotPresent("delete-10010");
        this.assertTextPresent("No trusted applications have been configured.");
    }

    public void testRequestSelfTwice() {
        this.gotoAdmin();
        this.clickLink("trusted_apps");
        this.setFormElement("trustedAppBaseUrl", this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.submit("Send Request");
        this.setWorkingForm("jiraform");
        this.assertTextPresent("Add New Trusted Application");
        this.setFormElement("name", "theTrustedApplicationName");
        this.submit("Add");
        this.setFormElement("trustedAppBaseUrl", this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.submit("Send Request");
        this.setWorkingForm("jiraform");
        this.assertTextPresent("Add New Trusted Application");
        this.setFormElement("name", "anuvverTrustedApplicationName");
        this.submit("Add");
        this.assertTextPresent("The Trusted Application with the specified applicationId");
        this.assertTextPresent("already exists");
    }

    public void testDirectBrowseWithNoPermission() {
        this.login("regularadmin", "admin");
        this.gotoAdmin();
        this.assertLinkNotPresent("trusted_apps");
        this.gotoPage("/secure/admin/trustedapps/ViewTrustedApplications.jspa");
        this.assertTextNotPresent("View Trusted Applications");
        this.gotoPage("/secure/admin/trustedapps/EditTrustedApplication!default.jspa");
        this.assertTextNotPresent("Edit Trusted Application");
        this.gotoPage("/secure/admin/trustedapps/DeleteTrustedApplication!default.jspa");
        this.assertTextNotPresent("Delete Trusted Application");
    }

    public void testRequestAppBadUrl() {
        this.login("admin", "admin");
        this.gotoAdmin();
        this.clickLink("trusted_apps");
        this.setFormElement("trustedAppBaseUrl", "junkUrl-9287349287349");
        this.submit("Send Request");
        this.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.assertTextPresent("java.net.MalformedURLException:");
        String unknownUrl = "http://www.something.invalid/";
        this.setFormElement("trustedAppBaseUrl", "http://www.something.invalid/");
        this.submit("Send Request");
        this.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.assertTextPresent("The host http://www.something.invalid/ could not be found");
        String noTrustUrl = "http://www.example.org";
        this.setFormElement("trustedAppBaseUrl", "http://www.example.org");
        this.submit("Send Request");
        this.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.assertTextPresent("The application at URL http://www.example.org does not support the Trusted Application protocol.");
        String noTrustUrlWhitespace = "   http://www.example.org   ";
        this.setFormElement("trustedAppBaseUrl", "   http://www.example.org   ");
        this.submit("Send Request");
        this.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.assertTextPresent("The application at URL " + "   http://www.example.org   ".trim() + " does not support the Trusted Application protocol.");
        String wrongTrustUrl = this.getUnlistenedURL();
        this.setFormElement("trustedAppBaseUrl", wrongTrustUrl);
        this.submit("Send Request");
        this.assertTextPresent(REQUEST_NEW_TRUSTED_APP_DETAILS);
        this.assertTextPresent("The host " + wrongTrustUrl + " could not be found.");
    }

    public void testAddEditValidation() {
        String trustedAppName = "theTrustedApplicationName";
        this.gotoAdmin();
        this.clickLink("trusted_apps");
        this.setFormElement("trustedAppBaseUrl", this.getEnvironmentData().getBaseUrl().toExternalForm());
        this.submit("Send Request");
        this.setWorkingForm("jiraform");
        this.setFormElement("name", "");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertTextPresent("The Trusted Application Name cannot be blank.");
        this.setWorkingForm("jiraform");
        this.setFormElement("name", "theTrustedApplicationName");
        this.setFormElement("timeout", "");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertTextPresent("You must specify a positive Timeout value.");
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "asdasd");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertTextPresent("You must specify a positive Timeout value.");
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "-8888");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertTextPresent("You must specify a positive Timeout value.");
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "0");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertTextPresent("You must specify a positive Timeout value.");
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "9999999999999999");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertTextPresent("You must specify a positive Timeout value.");
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "1000");
        this.setFormElement("ipMatch", "");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertTextPresent("You must specify IP addresses to match against.");
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "1000");
        this.setFormElement("urlMatch", "");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertTextPresent("You must specify URLs to match against.");
        String malformedIp = "blah";
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "1000");
        this.setFormElement("ipMatch", "blah");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("blah");
        malformedIp = "123.123.123.123.1.1";
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "1000");
        this.setFormElement("ipMatch", "123.123.123.123.1.1");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("123.123.123.123.1.1");
        malformedIp = "299.299.299.299";
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "1000");
        this.setFormElement("ipMatch", "299.299.299.299");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("299.299.299.299");
        malformedIp = "192,168,0,1";
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "1000");
        this.setFormElement("ipMatch", "192,168,0,1");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("192,168,0,1");
        malformedIp = "192.168.?.1";
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "1000");
        this.setFormElement("ipMatch", "192.168.?.1");
        this.submit("Add");
        this.assertTextPresent("Add New Trusted Application");
        this.assertBadIPMessage("192.168.?.1");
        malformedIp = "123.123.123.123\n192.168.0.1";
        this.setWorkingForm("jiraform");
        this.setFormElement("timeout", "1000");
        this.setFormElement("ipMatch", "123.123.123.123\n192.168.0.1");
        this.setFormElement("urlMatch", "/some/url");
        this.submit("Add");
        this.assertTextPresent("View Trusted Applications");
        this.assertTextPresent("theTrustedApplicationName");
        this.assertLinkPresent("delete-10010");
    }

    private void assertBadIPMessage(String malformedIp) {
        this.assertTextPresent("The IP address pattern: " + malformedIp + " is invalid.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUnlistenedURL() {
        String host = "http://localhost:";
        int port = 8000;
        while (true) {
            URL url;
            try {
                url = new URL(host + ++port);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.connect();
            }
            catch (ConnectException e) {
                String string = url.toExternalForm();
                return string;
            }
            catch (IOException ignoreAndContinue) {}
            continue;
            finally {
                if (connection == null) continue;
                connection.disconnect();
                continue;
            }
            break;
        }
    }
}

