/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestMultiIssueTypes
extends JIRAWebTest {
    private static final String AUTO_CREATED_SCHEME_PREFIX = "New issue type scheme for project ";

    public TestMultiIssueTypes(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testMultiIssueTypes() throws Exception {
        this._testCreateNewIssueTypeScheme();
        this._testSameAsProject();
        this._testChooseScheme();
        this._testIssueNavigator();
    }

    private void _testIssueNavigator() {
        TestMultiIssueTypes.logSection("Testing that choosing a different scheme is reflected in the issue navigator (must run after other tests)");
        this.clickLink("find_link");
        this.assertOptionNotPresent("type", "Improvement");
        this.assertOptionNotPresent("type", "New Feature");
        this.goToProject("homosapien");
        this.clickLink("selectIssueTypeScheme");
        this.checkCheckbox("createType", "chooseScheme");
        this.selectOption("schemeId", "New issue type scheme for project homosapien");
        this.submit(" OK ");
        this.clickLink("find_link");
        this.selectOption("type", "Improvement");
        this.assertOptionNotPresent("type", "New Feature");
    }

    private void _testChooseScheme() {
        TestMultiIssueTypes.logSection("Testing choosing scheme from a list & that all available projects share the same config");
        this.goToProject("monkey");
        this.clickLink("selectIssueTypeScheme");
        this.checkCheckbox("createType", "createScheme");
        this.selectMultiOption("selectedOptions", "Task");
        this.submit();
        this.assertTextPresent("New issue type scheme for project monkey");
        this.goToProject("homosapien");
        this.clickLink("selectIssueTypeScheme");
        this.selectOption("schemeId", "New issue type scheme for project monkey");
        this.submit();
        this.assertTextPresent("New issue type scheme for project monkey");
        this.clickLink("create_link");
        this.selectOption("pid", "homosapien");
        this.assertOptionNotPresent("issuetype", "Bug");
        this.selectOption("issuetype", "Task");
        this.submit();
        this.assertTextPresent("Enter the details of the issue");
    }

    private void _testSameAsProject() {
        TestMultiIssueTypes.logSection("Choose issue type scheme same as another project");
        this.checkCheckbox("createType", "chooseProject");
        this.selectOption("sameAsProjectId", "monkey");
        this.submit();
        this.assertTextPresent("Default Issue Type Scheme");
        this.clickLink("create_link");
        this.selectOption("pid", "homosapien");
        this.selectOption("issuetype", "Task");
        this.submit();
        this.assertTextPresent("Enter the details of the issue");
    }

    private void _testCreateNewIssueTypeScheme() {
        TestMultiIssueTypes.logSection("Create a new issue type scheme");
        this.goToProject("homosapien");
        this.clickLink("selectIssueTypeScheme");
        this.checkCheckbox("createType", "createScheme");
        this.selectMultiOption("selectedOptions", "Bug");
        this.selectMultiOption("selectedOptions", "Improvement");
        this.submit();
        this.assertTextPresent("New issue type scheme for project homosapien");
        this.clickLink("create_link");
        this.selectOption("pid", "homosapien");
        this.selectOption("issuetype", "Task");
        this.submit();
        this.assertTextPresent("The issue type selected is invalid");
        this.selectOption("issuetype", "Bug");
        this.submit();
        this.assertTextPresent("Enter the details of the issue");
        this.goToProject("homosapien");
        this.clickLink("selectIssueTypeScheme");
    }

    public void testMultiplIssueTypeSchemesWithoutBulkChangePermission() {
        this.restoreData("TestIssueTypesSchemes.xml");
        this.removeGlobalPermission(33, "jira-users");
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.setFormElement("name", "");
        this.clickLinkWithText("Issue Types Scheme");
        this.setFormElement("name", "");
        this.clickLink("associate_10011");
        this.selectOption("projects", "homosapien");
        this.submit("Associate");
        this.assertTextPresent("homosapien");
        this.assertTextPresent("Bug");
        this.assertTextPresent("1");
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.assertTextPresent("homosapien");
        this.assertTextPresent("New Feature");
        this.submit("nextBtn");
        this.displayAllIssues();
        this.clickLinkWithText("HSP-1");
        this.assertTextPresent("New Feature");
    }
}

