/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.index;

import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class TestIndexAdmin
extends JIRAWebTest {
    private static final Logger log = Logger.getLogger(TestIndexAdmin.class);
    private static final int RETRY_COUNT = 100;
    private static final int SLEEP_TIME = 1000;
    private static final String REFRESH_BUTTON = "Refresh";
    private static final String ACKNOWLEDGE_BUTTON = "Acknowledge";
    private static final String ACTIVATE_BUTTON = "Activate";
    private static final String REINDEX_BUTTON = "Re-Index";
    private static final String NEW_INDEX_PATH_FIELD = "indexPath";
    private static final String DONE_BUTTON = "Done";

    public TestIndexAdmin(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestIndexAdmin.xml");
    }

    public void testReindexAsSystemAdmin() {
        this.gotoIndexing();
        this.assertTextPresent("Please make sure the index path specified is not being used by another JIRA instance");
        this.assertFormElementPresent(NEW_INDEX_PATH_FIELD);
        this.executeReindex(null);
    }

    public void testChangeIndexPathAsSystemAdmin() {
        String newIndexPath = this.getEnvironmentData().getWorkingDirectory().getAbsolutePath() + FS + "newindexes";
        try {
            FileUtils.deleteDirectory((File)new File(newIndexPath));
        }
        catch (IOException e) {
            log.info((Object)("Ops couldn't cleanup the directory '" + newIndexPath + "'.  Shouldn't be a problem since reindex will re-create this anyway: " + e));
        }
        this.gotoIndexing();
        this.assertTextPresent("Please make sure the index path specified is not being used by another JIRA instance");
        this.assertFormElementPresent(NEW_INDEX_PATH_FIELD);
        String oldPath = this.getDialog().getFormParameterValue(NEW_INDEX_PATH_FIELD);
        this.executeReindex(newIndexPath);
        this.gotoIndexing();
        this.executeReindex(null);
    }

    public void testReindexAsNormalAdmin() {
        this.login("miniadmin", "miniadmin");
        this.gotoIndexing();
        this.assertTextPresent("Only a user with the System Administrator Global Permission can modify the search index path.");
        this.assertFormElementNotPresent(NEW_INDEX_PATH_FIELD);
        this.executeReindex(null);
    }

    public void testBadReindex() throws IOException {
        this.gotoIndexing();
        this.assertTextPresent("Please make sure the index path specified is not being used by another JIRA instance");
        this.assertFormElementPresent(NEW_INDEX_PATH_FIELD);
        File oldIndex = new File(this.getDialog().getFormParameterValue(NEW_INDEX_PATH_FIELD));
        File f = File.createTempFile("idx", "test", this.getEnvironmentData().getWorkingDirectory());
        f.deleteOnExit();
        this.checkCheckbox("indexPathOption", "CUSTOM");
        this.setFormElement(NEW_INDEX_PATH_FIELD, f.getAbsolutePath());
        this.submit(REINDEX_BUTTON);
        this.assertTextPresent("The path entered does not exist, or is not a directory.");
        this.gotoIndexing();
        this.assertSubmitButtonNotPresent(ACTIVATE_BUTTON);
        this.assertTextNotPresent("OFF");
        File newIndex = new File(this.getDialog().getFormParameterValue(NEW_INDEX_PATH_FIELD));
        TestIndexAdmin.assertFalse((boolean)newIndex.equals(f));
        TestIndexAdmin.assertTrue((boolean)newIndex.equals(oldIndex));
    }

    public void testTaskAcknowledgement() {
        this.gotoIndexing();
        this.assertTextPresent("Please make sure the index path specified is not being used by another JIRA instance");
        this.assertFormElementPresent(NEW_INDEX_PATH_FIELD);
        this.submit(REINDEX_BUTTON);
        String taskPage = this.waitForIndexCompletetion();
        this.login("miniadmin", "miniadmin");
        this.gotoPage(taskPage);
        this.assertSubmitButtonPresent(DONE_BUTTON);
        this.assertSubmitButtonNotPresent(ACKNOWLEDGE_BUTTON);
        this.assertTextPresent("who started this task should acknowledge it.");
        this.validateProgressBarUI(DONE_BUTTON);
        this.assertLinkPresentWithText("admin", 0);
        this.assertLinkPresentWithText("admin", 1);
        this.submit(DONE_BUTTON);
        TestIndexAdmin.assertTrue((this.getRedirect().indexOf("IndexAdmin.jspa?reindexTime=") != -1 ? 1 : 0) != 0);
        this.login("admin", "admin");
        this.gotoPage(taskPage);
        this.acknowledgeSuccessfulTask();
        this.gotoPage(taskPage);
        this.checkNoTaskPage();
        this.login("miniadmin", "miniadmin");
        this.gotoPage(taskPage);
        this.checkNoTaskPage();
    }

    private void checkNoTaskPage() {
        this.assertTextPresent("A task could not be found for the given task id");
        this.assertTextPresent("Task Not Found");
        this.submit(DONE_BUTTON);
        TestIndexAdmin.assertTrue((this.getRedirect().indexOf("IndexAdmin.jspa") != -1 ? 1 : 0) != 0);
        this.assertTextNotPresent("successful");
    }

    private void gotoIndexing() {
        this.gotoAdmin();
        this.clickLink("indexing");
    }

    private void executeReindex(String newIndexPath) {
        if (newIndexPath != null) {
            this.selectMultiOptionByValue("indexPathOption", "CUSTOM");
            this.setFormElement(NEW_INDEX_PATH_FIELD, newIndexPath);
        }
        this.submit(REINDEX_BUTTON);
        this.waitForIndexCompletetion();
        this.acknowledgeSuccessfulTask();
        if (newIndexPath != null) {
            this.assertFormElementEquals(NEW_INDEX_PATH_FIELD, newIndexPath);
        }
        this.clickLinkWithText("Optimise Indexes");
        this.assertTextPresent("To optimise the indexes please click 'Optimise'");
    }

    private String waitForIndexCompletetion() {
        return this.waitForIndexCompletetion(1000L, 100);
    }

    private String waitForIndexCompletetion(long sleepTime, int retryCount) {
        String redirect = this.getRedirect();
        TestIndexAdmin.assertTrue((redirect.indexOf("IndexProgress.jspa?taskId=") != -1 ? 1 : 0) != 0);
        for (int i = 0; i < retryCount; ++i) {
            if (this.getDialog().hasSubmitButton(REFRESH_BUTTON)) {
                this.validateProgressBarUI(REFRESH_BUTTON);
                this.submit(REFRESH_BUTTON);
            } else {
                if (this.getDialog().hasSubmitButton(ACKNOWLEDGE_BUTTON)) {
                    this.validateProgressBarUI(ACKNOWLEDGE_BUTTON);
                    this.assertTextNotPresent("who started this task should acknowledge it.");
                    return redirect;
                }
                TestIndexAdmin.fail((String)"Unexpected button on progress screen.");
            }
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        TestIndexAdmin.fail((String)("Index operation did not complete after " + (double)(sleepTime * (long)retryCount) / 1000.0 + " sec."));
        return redirect;
    }

    private void acknowledgeSuccessfulTask() {
        this.submit(ACKNOWLEDGE_BUTTON);
        TestIndexAdmin.assertTrue((this.getRedirect().indexOf("IndexAdmin.jspa?reindexTime=") != -1 ? 1 : 0) != 0);
        this.assertTextPresent("successful");
    }
}

