/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestTimeTracking
extends FuncTestCase {
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.administration.enablePlugin("Issue Operations Plugin", "System Issue Operations");
        this.administration.enablePluginModule("Issue Operations Plugin", "System Issue Operations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.administration.activateTimeTracking();
    }

    public void testIssueOperationsPluginDisabled() {
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextNotPresent("The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.deactivateTimeTracking();
        this.tester.assertTextNotPresent("The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.");
        this.administration.activateTimeTracking();
        this.administration.disablePlugin("Issue Operations Plugin", "System Issue Operations");
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextPresent("The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.deactivateTimeTracking();
        this.tester.assertTextPresent("The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.");
    }

    public void testLogWorkModuleDisabled() {
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.deactivateTimeTracking();
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.");
        this.administration.activateTimeTracking();
        this.administration.disablePluginModule("Issue Operations Plugin", "System Issue Operations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextPresent("The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.deactivateTimeTracking();
        this.tester.assertTextPresent("The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.");
    }

    public void testIssueOperationsPluginDisabledAndLogWorkModuleDisabled() {
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextNotPresent("The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.deactivateTimeTracking();
        this.tester.assertTextNotPresent("The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.");
        this.administration.activateTimeTracking();
        this.administration.disablePluginModule("Issue Operations Plugin", "System Issue Operations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.administration.disablePlugin("Issue Operations Plugin", "System Issue Operations");
        this.navigation.gotoAdminSection("timetracking");
        this.tester.assertTextPresent("The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.");
        this.administration.deactivateTimeTracking();
        this.tester.assertTextPresent("The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.");
        this.tester.assertTextNotPresent("The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.");
    }

    private static class ErrorMessages {
        private static final String ISSUE_OPS_DISABLED_ACTIVE = "The Issue Operations plugin is currently disabled, and thus users will not be able to log work done against any issues.";
        private static final String ISSUE_OPS_DISABLED_INACTIVE = "The Issue Operations plugin is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the plugin before activating Time Tracking.";
        private static final String LOG_WORK_DISABLED_ACTIVE = "The Log Work module is currently disabled, and thus users will not be able to log work done against any issues.";
        private static final String LOG_WORK_DISABLED_INACTIVE = "The Log Work module is currently disabled, and so even if you activate Time Tracking, users will still not be able to log work done against any issues. You should enable the module before activating Time Tracking.";

        private ErrorMessages() {
        }
    }
}

