/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.LicenseKeys;
import com.meterware.httpunit.WebTable;
import org.apache.commons.lang.StringUtils;

public class TestSystemInfoPage
extends FuncTestCase {
    private static final String SYSTEM_INFO_SECTION = "system_info";

    public void testInstallationType() {
        String installationType = this.getEnvironmentData().getReleaseInfo();
        TestSystemInfoPage.assertFalse((String)"You must have the 'jira.release.info' property set in your localtest.properties", (boolean)StringUtils.isBlank((String)installationType));
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(SYSTEM_INFO_SECTION);
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Installation Type", installationType});
    }

    public void testSupportRequestContainsMemoryAndInputArgsInfo() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(SYSTEM_INFO_SECTION);
        if (this.isBeforeJdk15() || !this.isSunJVM()) {
            this.tester.assertTextNotPresent("PermGen Memory Graph");
            this.tester.assertTextPresent("Unable to determine, this requires running JDK 1.5 and higher.");
        } else {
            this.tester.assertTextPresent("Used PermGen Memory");
            this.tester.assertTextPresent("Free PermGen Memory");
            this.tester.assertTextPresent("JVM Input Arguments");
            this.tester.assertTextPresent("PermGen Memory Graph");
            this.tester.assertTextNotPresent("Unable to determine, this requires running JDK 1.5 and higher.");
        }
    }

    public void testSystemInfoContainsTimezoneInfo() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(SYSTEM_INFO_SECTION);
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("system_info_table");
        String systemTime = table.getCellAsText(2, 1).trim();
        TestSystemInfoPage.assertTrue((String)("System time does not contain GMT offset '" + systemTime + "'"), (boolean)systemTime.matches(".*[-+]\\d{4}"));
        String timezoneLabel = table.getCellAsText(12, 0);
        TestSystemInfoPage.assertEquals((String)"User Timezone", (String)timezoneLabel.trim());
        String timezoneValue = table.getCellAsText(12, 1);
        TestSystemInfoPage.assertTrue((String)("Timezone value not present in text '" + timezoneValue + "'"), (timezoneValue.trim().length() > 0 ? 1 : 0) != 0);
    }

    public void testSystemInfoContainsJiraHome() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(SYSTEM_INFO_SECTION);
        this.tester.assertTextInTable("file_paths", "Location of JIRA Home");
    }

    public void testLicenseInfoMaintenanceStatus() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(SYSTEM_INFO_SECTION);
        this.tester.assertTableRowsEqual("license_info", 4, (String[][])new String[][]{{"Maintenance Status", "Supported"}});
        this.administration.switchToLicense(LicenseKeys.V2_EVAL_EXPIRED.getLicenseString(), "Evaluation");
        this.navigation.gotoAdminSection(SYSTEM_INFO_SECTION);
        this.tester.assertTableRowsEqual("license_info", 4, (String[][])new String[][]{{"Maintenance Status", "Expired"}});
        this.administration.switchToPersonalLicense();
        this.navigation.gotoAdminSection(SYSTEM_INFO_SECTION);
        this.tester.assertTableRowsEqual("license_info", 5, (String[][])new String[][]{{"Maintenance Status", "Unsupported"}});
    }

    private boolean isBeforeJdk15() {
        return new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isJavaBeforeJdk15();
    }

    private boolean isSunJVM() {
        return new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isSunJVM();
    }
}

