/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestSystemAdminAndAdminPermissions
extends JIRAWebTest {
    public TestSystemAdminAndAdminPermissions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestSystemAdminAndAdminPermissions.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAdminFromJiraUsers() {
        try {
            this.removeUserFromGroup("nonsystemadmin", "jira-users");
            this.login("nonsystemadmin", "nonsystemadmin");
            this.assertLinkPresentWithText("Log Out");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testRemoveSysAdminFromJiraUsers() {
        this.removeUserFromGroup("admin", "jira-users");
        this.logout();
        this.login("admin");
        this.assertLinkPresentWithText("Log Out");
    }

    public void testRemoveSysAdminFromAdminsAndJiraUsers() {
        this.createGroup("systemadmins");
        this.grantGlobalPermission(44, "systemadmins");
        this.addUserToGroup("admin", "systemadmins");
        this.removeUserFromGroup("admin", "jira-users");
        this.removeUserFromGroup("admin", "jira-administrators");
        this.logout();
        this.login("admin");
        this.assertLinkPresentWithText("Log Out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationSchemeMailServerWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("notification_schemes");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("mail server");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationSchemeMailServerWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("notification_schemes");
            this.assertLinkPresentWithText("mail server");
            this.assertLinkNotPresentWithText("contact a System Administrator");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditNotificationSchemeMailServerWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("notification_schemes");
            this.clickLinkWithText("Default Notification Scheme");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("mail server");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditNotificationSchemeMailServerWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("notification_schemes");
            this.clickLinkWithText("Default Notification Scheme");
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("mail server");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendBulkMailMailServerWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("send_email");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("configure");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendBulkMailMailServerWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("send_email");
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("configure");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSupportRequestMailServerWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("support_request");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("configure");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSupportRequestMailServerWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("support_request");
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("configure");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailQueueMailServerWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("mail_queue");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("mail server");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailQueueMailServerWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("mail_queue");
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("mail server");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteProjectBackupWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("view_projects");
            this.clickLinkWithText("Delete");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("back it up first");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteProjectBackupWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("view_projects");
            this.clickLinkWithText("Delete");
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("back it up first");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivateWorkflowBackupWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.createNewWorkflowSchemeAndGotoAssociateProject();
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("backup");
            this.selectOption("schemeId", "Test");
            this.submit("Associate");
            this.assertTextPresent("2 of 3");
            this.assertLinkNotPresentWithText("backup");
            this.assertLinkPresentWithText("contact a System Administrator");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivateWorkflowBackupWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.createNewWorkflowSchemeAndGotoAssociateProject();
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("backup");
            this.selectOption("schemeId", "Test");
            this.submit("Associate");
            this.assertTextPresent("2 of 3");
            this.assertLinkPresentWithText("backup");
            this.assertLinkNotPresentWithText("contact a System Administrator");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWorkflowBackupWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.copyWorkFlow("jira", "Copy of jira", "new workflow");
            this.clickLink("del_Copy of jira");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("do a full backup");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWorkflowBackupWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.copyWorkFlow("jira", "Copy of jira", "new workflow");
            this.clickLink("del_Copy of jira");
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("do a full backup");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemeToolsBackupWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("scheme_tools");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("backup");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemeToolsBackupWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("scheme_tools");
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("backup");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemePurgePreviewBackupWarningAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("permission_schemes");
            this.clickLinkWithText("Copy");
            this.clickLink("scheme_tools");
            this.clickLink("delete_tool");
            this.checkCheckbox("selectedSchemeIds", "10000");
            this.submit("Preview");
            this.assertLinkPresentWithText("contact a System Administrator");
            this.assertLinkNotPresentWithText("backup");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemePurgePreviewBackupWarningAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("permission_schemes");
            this.clickLinkWithText("Copy");
            this.clickLink("scheme_tools");
            this.clickLink("delete_tool");
            this.checkCheckbox("selectedSchemeIds", "10000");
            this.submit("Preview");
            this.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertLinkPresentWithText("backup");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewGroupEditLinkNotPresentAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("group_browser");
            this.clickLinkWithText("jira-sys-admins");
            this.assertLinkNotPresent("edit_members_of_jira-sys-admins");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewGroupEditLinkPresentAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("group_browser");
            this.clickLinkWithText("jira-sys-admins");
            this.assertLinkPresent("edit_members_of_jira-sys-admins");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserBrowserEditAndDeleteLinkNotPresentAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("user_browser");
            this.assertLinkNotPresent("edituser_link_root");
            this.assertLinkNotPresent("deleteuser_link_root");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserBrowserEditAndDeleteLinkPresentAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("user_browser");
            this.assertLinkPresent("edituser_link_root");
            this.assertLinkPresent("deleteuser_link_root");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditLinkNotPresentAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("attachments");
            this.assertLinkNotPresentWithText("Edit Configuration");
            this.assertLinkPresentWithText("contact a system administrator");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoPage("/secure/admin/jira/EditAttachmentSettings.jspa?thumbnailsEnabled=true");
            this.assertTextPresent("Attachments must be enabled to enable thumbnails.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditLinkPresentAsSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.gotoAdmin();
            this.clickLink("attachments");
            this.assertLinkPresentWithText("Edit Configuration");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanElevatehisPrivlegesBySettingSysAdminPassword() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=root");
            this.assertTextNotPresent("Set Password");
            this.tester.gotoPage("secure/admin/user/SetPassword!default.jspa?name=root");
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.clickButton("Update");
            this.assertTextNotPresent("has successfully been set ");
            this.assertTextPresent("Must be a System Administrator to reset a System Administrator's password");
            this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=admin");
            this.assertTextPresent("Set Password");
            this.tester.gotoPage("secure/admin/user/SetPassword!default.jspa?name=admin");
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.clickButton("Update");
            this.assertTextNotPresent("has successfully been set ");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    private void createNewWorkflowSchemeAndGotoAssociateProject() {
        this.gotoAdmin();
        this.copyWorkFlow("jira", "Copy of jira", "new workflow");
        this.clickLink("workflow_schemes");
        this.clickLink("add_workflowscheme");
        this.setFormElement("name", "Test");
        this.submit("Add");
        this.clickLinkWithText("Assign a workflow");
        this.selectOption("workflow", "Copy of jira");
        this.submit(" Add ");
        this.clickLink("view_projects");
        this.clickLinkWithText("homosapien");
        this.clickLink("select_workflow_scheme");
    }
}

