/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestManageTrackbacks
extends JIRAWebTest {
    private static final String ISSUE_WITH_TRACKBACKS = "HSP-1";
    private static final String ISSUE_ID_WITH_TRACKBACKS = "10000";

    public TestManageTrackbacks(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestTrackback.xml");
    }

    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testManageTrackbacks() {
        this._testManageTrackbackPermission();
        this._testTrackbackDelete();
        this._testComponentOrdering();
        this._testVersionOrdering();
    }

    private void _testManageTrackbackPermission() {
        TestManageTrackbacks.log("Test manage trackback link visibility");
        this.addUser("user", "pass", "pass", "user@invalid.com");
        this.logout();
        this.login("user", "pass");
        this.gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.assertTextNotPresent("Manage Trackbacks");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.assertTextPresentBeforeText("External References:", "Manage Trackbacks");
    }

    public void _testComponentOrdering() {
        TestManageTrackbacks.log("Testing ordering for components field");
        this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageTrackbacks.jspa?id=10000");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 3"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageTrackbacks.jspa?id=10000");
        this.assertTextSequence(new String[]{"Component/s", "New Component 2", "New Component 3"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageTrackbacks.jspa?id=10000");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2"});
        this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.gotoPage("/secure/ManageTrackbacks.jspa?id=10000");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2", "New Component 3"});
    }

    public void _testVersionOrdering() {
        String[] versionFields = new String[]{"versions", "fixVersions"};
        String[] versionFieldNames = new String[]{"Affects Version/s", "Fix Version/s"};
        for (int i = 0; i < versionFields.length; ++i) {
            String versionField = versionFields[i];
            String versionFieldName = versionFieldNames[i];
            TestManageTrackbacks.log("Testing ordering for versions field '" + versionField + "'");
            this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageTrackbacks.jspa?id=10000");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageTrackbacks.jspa?id=10000");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 4", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageTrackbacks.jspa?id=10000");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
            this.tester.setWorkingForm("jiraform");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.gotoPage("/secure/ManageTrackbacks.jspa?id=10000");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4", "New Version 5"});
            this.gotoPage("/secure/EditIssue!default.jspa?id=10000");
            this.tester.setWorkingForm("jiraform");
            this.uncheckCheckbox(versionField);
            this.tester.submit("Update");
        }
    }

    private void _testTrackbackDelete() {
        TestManageTrackbacks.log("Test delete trackbacks");
        this.gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.clickLinkWithText("Manage Trackbacks");
        this.assertTextPresent("This page allows you to manage the trackback links for a particular issue.");
        this.clickLink("del_10000");
        this.submit("Delete");
        this.clickLink("del_10001");
        this.submit("Delete");
        this.assertTextPresent("There are no trackbacks for this issue.");
        this.clickLinkWithText("View HSP-1");
        this.assertTextNotPresent("External References:");
        this.assertTextNotPresent("Manage Trackbacks");
    }
}

