/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementNameAndTextQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class TestImportExport
extends JIRAWebTest {
    public TestImportExport(String name) {
        super(name);
    }

    public void xtestImportExport() throws Exception {
        TestImportExport.log("testing TestImportExport");
        this.runTestImportExport("TestImportExport");
        TestImportExport.log("testing TestImportExport2");
        this.runTestImportExport("TestImportExport2");
    }

    public void testXmlImportFromFuture() {
        this.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.setWorkingForm("jiraform");
        this.setFormElement("filename", this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + "TestXmlImportFromFuture.xml");
        this.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.submit();
        this.assertTextNotPresent("Your project has been successfully imported");
        this.assertTextPresent("The xml data you are trying to import seems to be from a newer version of JIRA. This will not work.");
    }

    public void testXmlImportWithAV1LicenseInIt() throws Exception {
        this.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.setWorkingForm("jiraform");
        String xmlFile = this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + "oldlicense.xml";
        this.setFormElement("filename", xmlFile);
        this.submit();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The license in the imported data is not compatible with this installation of JIRA. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestImportExport(String fileBaseName) throws Exception {
        String importFilename = fileBaseName + ".xml";
        String exportFilename = fileBaseName + "_out.xml";
        this.restoreData(importFilename);
        this.exportData(importFilename);
        this.restoreData(importFilename);
        this.exportData(exportFilename);
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        DifferenceListener acceptable = new DifferenceListener(){

            public int differenceFound(Difference difference) {
                boolean listenerConfigSequenceValueItem;
                Node control = difference.getControlNodeDetail().getNode();
                if (TestImportExport.this.attrMatch(control, "id", "ListenerConfig")) {
                    return 2;
                }
                boolean bl = listenerConfigSequenceValueItem = TestImportExport.this.attrMatch(control, "seqId", "SequenceValueItem") && TestImportExport.this.attrHasSibling(control, "seqName", "ListenerConfig");
                if (listenerConfigSequenceValueItem) {
                    return 2;
                }
                boolean osPropertyString = TestImportExport.this.attrMatch(control, "value", "OSPropertyString");
                if (osPropertyString && (TestImportExport.this.attrHasSibling(control, "id", "10012") || TestImportExport.this.attrHasSibling(control, "id", "10013"))) {
                    return 2;
                }
                return 0;
            }

            public void skippedComparison(Node control, Node test) {
            }
        };
        FileReader imported = new FileReader(new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath(), importFilename));
        FileReader exported = new FileReader(new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath(), exportFilename));
        try {
            DetailedDiff diff = new DetailedDiff(new Diff((Reader)imported, (Reader)exported));
            diff.overrideDifferenceListener(acceptable);
            diff.overrideElementQualifier((ElementQualifier)new ElementNameAndTextQualifier());
            TestImportExport.assertTrue((String)diff.toString(), (boolean)diff.similar());
        }
        finally {
            this.closeReader(imported);
            this.closeReader(exported);
        }
    }

    private void closeReader(Reader r) {
        try {
            r.close();
        }
        catch (IOException ioe) {
            TestImportExport.log(ioe.getLocalizedMessage());
        }
    }

    private boolean attrHasSibling(Node node, String attrName, String attrValue) {
        if (node.getNodeType() != 2) {
            return false;
        }
        Attr attr = ((Attr)node).getOwnerElement().getAttributeNode(attrName);
        return attr != null && attr.getNodeValue().equals(attrValue);
    }

    private boolean attrMatch(Node n, String name, String ownerElementName) {
        return n.getNodeName().equals(name) && n.getNodeType() == 2 && ((Attr)n).getOwnerElement().getNodeName().equals(ownerElementName);
    }
}

