/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestAdministrators
extends JIRAWebTest {
    public TestAdministrators(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithBothSystemAdminsAndAdmins() throws SAXException {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoPage("/secure/Administrators.jspa");
            WebTable table = this.getDialog().getResponse().getTableWithID("administrators");
            this.assertTableCellHasText("administrators", 0, 0, "Administrators");
            TestAdministrators.assertNotNull((Object)table.getTableCell(1, 0).getLinkWith("Administrator"));
            TestAdministrators.assertNull((Object)table.getTableCell(1, 0).getLinkWith("Root"));
            this.assertTableCellHasText("administrators", 2, 0, "System Administrators");
            TestAdministrators.assertNotNull((Object)table.getTableCell(3, 0).getLinkWith("Root"));
            TestAdministrators.assertNull((Object)table.getTableCell(3, 0).getLinkWith("Administrator"));
            TestAdministrators.assertEquals((int)4, (int)table.getRowCount());
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    public void testWithOnlySysAdmins() throws SAXException {
        this.restoreBlankInstance();
        this.gotoPage("/secure/Administrators.jspa");
        WebTable table = this.getDialog().getResponse().getTableWithID("administrators");
        this.assertTableCellHasText("administrators", 0, 0, "System Administrators");
        TestAdministrators.assertNotNull((Object)table.getTableCell(1, 0).getLinkWith("Administrator"));
        TestAdministrators.assertEquals((int)2, (int)table.getRowCount());
    }

    public void testMailAddressesNormal() {
        this.restoreBlankInstance();
        this.gotoDashboard();
        this.clickLinkWithText("Contact Administrators");
        this.assertLinkPresent("admin");
        this.assertTextPresent("admin@example.com");
    }

    public void testMailAddressesHidden() {
        this.restoreBlankInstance();
        this.editEmailVisibility("hide");
        this.clickLinkWithText("Contact Administrators");
        this.assertLinkNotPresent("admin");
        this.assertTextNotPresent("admin@example.com");
    }

    public void testMailAddressesMasked() {
        this.restoreBlankInstance();
        this.editEmailVisibility("mask");
        this.clickLinkWithText("Contact Administrators");
        this.assertLinkPresent("admin");
        this.assertTextPresent("admin at example dot com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailAddressesLoggedInUsersOnly() {
        try {
            this.restoreBlankInstance();
            this.editEmailVisibility("user");
            this.clickLinkWithText("Contact Administrators");
            this.assertLinkPresent("admin");
            this.assertTextPresent("admin@example.com");
            this.logout();
            this.clickLinkWithText("Contact Administrators");
            this.assertLinkNotPresent("admin");
            this.assertTextNotPresent("admin@example.com");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    private void editEmailVisibility(String visibility) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("title", "jWebTest JIRA installation");
        this.checkCheckbox("emailVisibility", visibility);
        this.submit("Update");
    }
}

