/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.webtests.util.AbstractEnvironmentData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class LocalTestEnvironmentData
extends AbstractEnvironmentData {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "8080";
    private static final String DEFAULT_CONTEXT = "";
    private static final String DEFAULT_EDITION = "standard";
    private static final String DEFAULT_XML_DATA_LOCATION = "./xml";
    private static final String DEFAULT_PROPERTIES_FILENAME = "localtest.properties";
    private static final String TEST_SERVER_PROPERTIES = "test.server.properties";
    private final String context;
    private final URL url;
    private File xmlDataLocation;
    private final String edition;

    public LocalTestEnvironmentData() {
        this(LocalTestEnvironmentData.loadProperties(TEST_SERVER_PROPERTIES, DEFAULT_PROPERTIES_FILENAME), null);
    }

    public LocalTestEnvironmentData(String xmlDataLocation) {
        this(LocalTestEnvironmentData.loadProperties(TEST_SERVER_PROPERTIES, DEFAULT_PROPERTIES_FILENAME), xmlDataLocation);
    }

    public LocalTestEnvironmentData(Properties properties, String xmlDataLocation) {
        super(properties);
        String protocol = properties.getProperty("jira.protocol", DEFAULT_PROTOCOL);
        String host = properties.getProperty("jira.host", DEFAULT_HOST);
        String port = properties.getProperty("jira.port", DEFAULT_PORT);
        String propertyString = properties.getProperty("jira.xml.data.location", DEFAULT_XML_DATA_LOCATION).trim();
        File unresolvedFileLocation = new File(xmlDataLocation != null ? xmlDataLocation : propertyString);
        try {
            this.xmlDataLocation = unresolvedFileLocation.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException trying to resolve file " + unresolvedFileLocation);
        }
        if (!this.xmlDataLocation.exists()) {
            this.xmlDataLocation = new File(this.xmlDataLocation.getParent() + "/subprojects/func_tests/xml");
            if (!this.xmlDataLocation.exists()) {
                throw new RuntimeException("Cannot find xml data location " + this.xmlDataLocation.getAbsolutePath());
            }
        }
        String baseUrl = protocol + "://" + host + ":" + port + properties.getProperty("jira.context", DEFAULT_CONTEXT);
        this.context = properties.getProperty("jira.context", DEFAULT_CONTEXT);
        try {
            this.url = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL " + baseUrl);
        }
        this.edition = properties.getProperty("jira.edition", DEFAULT_EDITION);
    }

    public static Properties loadProperties(String key, String def) {
        Properties properties = new Properties();
        String propertiesFileName = DEFAULT_CONTEXT;
        try {
            propertiesFileName = System.getProperty(key, def);
            InputStream propStream = ClassLoaderUtils.getResourceAsStream((String)propertiesFileName, LocalTestEnvironmentData.class);
            if (propStream == null) {
                propStream = new FileInputStream(propertiesFileName);
            }
            properties.load(propStream);
            return properties;
        }
        catch (IOException e) {
            FuncTestOut.out.println("Cannot load file " + propertiesFileName + " from CLASSPATH.");
            e.printStackTrace(FuncTestOut.out);
            throw new IllegalArgumentException("Could not load properties file " + propertiesFileName + " from classpath");
        }
    }

    public String getContext() {
        return this.context;
    }

    public URL getBaseUrl() {
        return this.url;
    }

    public File getXMLDataLocation() {
        return this.xmlDataLocation;
    }

    public File getWorkingDirectory() {
        File file = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "jira_autotest");
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not create JIRA home dir " + file);
        }
    }

    public File getJIRAHomeLocation() {
        return this.getWorkingDirectory();
    }

    public String getEdition() {
        return this.edition;
    }
}

