/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.table;

import com.atlassian.jira.webtests.table.AbstractSimpleCell;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebTable;

public class ImageCell
extends AbstractSimpleCell {
    private String url;

    public ImageCell(String url) {
        this.url = url;
    }

    public String toString() {
        return this.getUrl();
    }

    public String getUrl() {
        return this.url;
    }

    public String getCellAsText(WebTable table, int row, int col) {
        TableCell tableCell = table.getTableCell(row, col);
        WebImage[] images = tableCell.getImages();
        if (images != null && images.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < images.length; ++i) {
                WebImage webImage = images[i];
                String source = webImage.getSource();
                sb.append("[img: '").append(source).append("']");
            }
            return sb.toString();
        }
        return "No Images was found in " + table.getID() + "[" + row + ", " + col + "]";
    }

    public boolean equals(WebTable table, int row, int col) {
        return this.tableCellHasImageThatContains(table, row, col, this.getUrl());
    }

    private boolean tableCellHasImageThatContains(WebTable table, int row, int col, String stringInImageSource) {
        if (stringInImageSource == null) {
            return this.tableCellHasNoImages(table, row, col);
        }
        this.log("Checking cell on row [" + row + "] col [" + col + "] for image [" + stringInImageSource + "]");
        TableCell tableCell = table.getTableCell(row, col);
        WebImage[] images = tableCell.getImages();
        if (images != null && images.length > 0) {
            String source = null;
            for (int i = 0; i < images.length; ++i) {
                WebImage webImage = images[i];
                source = webImage.getSource();
                if (source == null || source.indexOf(stringInImageSource) < 0) continue;
                return true;
            }
            if (images.length == 1) {
                this.log("Expected image with URL '" + stringInImageSource + "' did not match the single image in " + "the cell '" + source + "'");
            } else {
                this.log("Expected image with Url '" + stringInImageSource + "' was not found in table cell [" + row + ", " + col + "] with '" + images.length + "' image(s)");
            }
        } else {
            this.log("Expected image with Url '" + stringInImageSource + "' but there was NO images in table cell [" + row + ", " + col + "]");
        }
        return false;
    }

    private boolean tableCellHasNoImages(WebTable table, int row, int col) {
        boolean result;
        this.log("Checking cell on row [" + row + "] col [" + col + "] for no images");
        TableCell tableCell = table.getTableCell(row, col);
        WebImage[] images = tableCell.getImages();
        boolean bl = result = images == null || images.length == 0;
        if (!result) {
            this.log("Images were not expected but were found in '" + table.getTableCell(row, col).asText() + "'");
        }
        return result;
    }
}

