/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.jelly;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestJellyWorkflowTransition
extends FuncTestCase {
    private static final Map<String, Object> ISSUE_DETAILS_FIELD_VALUE_MAP = new LinkedHashMap<String, Object>();
    private static final Map<String, Object> FIELD_VALUE_MAP = new LinkedHashMap<String, Object>();
    private static final Map<String, FieldDetail> FIELD_UPDATE_MAP = new LinkedHashMap<String, FieldDetail>();

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestJellyWorkflowTransition.xml");
    }

    public void testTransitionIssueWithoutSettingResolution() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        String invalidScript = "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-1\" user=\"admin\" workflowAction=\"Resolve Issue\"/>\n</JiraJelly>";
        this.administration.runJellyScript("<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-1\" user=\"admin\" workflowAction=\"Resolve Issue\"/>\n</JiraJelly>");
        this.tester.assertTextPresent("Jelly script completed successfully.");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Status", "Resolved", "Resolution:", "Fixed", "Available Workflow Actions", "Reopen Issue");
        this.tester.assertLinkNotPresentWithText("Resolve Issue");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(CollectionBuilder.newBuilder(new ExpectedChangeHistoryItem("Status", "Open", "Resolved"), new ExpectedChangeHistoryItem("Resolution", null, "Fixed")).asList()));
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLink("action_id_711");
        this.tester.selectOption("resolution", "Won't Fix");
        this.tester.submit("ResolveSomeMore");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Resolution:", "Won't Fix");
        if (isOracle) {
            Thread.sleep(2000L);
        }
        String script = "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-2\" user=\"admin\" workflowAction=\"ResolveSomeMore\"/>\n</JiraJelly>";
        this.administration.runJellyScript("<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-2\" user=\"admin\" workflowAction=\"ResolveSomeMore\"/>\n</JiraJelly>");
        this.tester.assertTextPresent("Jelly script completed successfully.");
        this.navigation.issue().viewIssue("HSP-2");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Resolution:", "Won't Fix");
        this.tester.assertLinkNotPresentWithText("Resolve Issue");
        this.tester.assertLinkPresentWithText("ResolveSomeMore");
        this.assertions.assertLastChangeHistoryRecords("HSP-2", new ExpectedChangeHistoryRecord(CollectionBuilder.newBuilder(new ExpectedChangeHistoryItem("Status", "Resolved", "Resolved")).asList()));
    }

    public void testTransitionIssueWithoutResolutionFieldPresent() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        this.navigation.gotoAdminSection("field_screens");
        this.tester.clickLink("configure_fieldscreen_Resolve Issue Screen");
        this.tester.checkCheckbox("removeField_0", "on");
        this.tester.submit("deleteFieldsFromTab");
        this.text.assertTextNotPresent(new TableLocator(this.tester, "field_table"), "Resolution");
        if (isOracle) {
            Thread.sleep(2000L);
        }
        String invalidScript = "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-1\" user=\"admin\" workflowAction=\"Resolve Issue\"/>\n</JiraJelly>";
        this.administration.runJellyScript("<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-1\" user=\"admin\" workflowAction=\"Resolve Issue\"/>\n</JiraJelly>");
        this.tester.assertTextPresent("Jelly script completed successfully.");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Resolution:");
        this.tester.assertLinkNotPresentWithText("Resolve Issue");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(CollectionBuilder.newBuilder(new ExpectedChangeHistoryItem("Status", "Open", "Resolved")).asList()));
        if (isOracle) {
            Thread.sleep(2000L);
        }
        String validScript = "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-2\" user=\"admin\" workflowAction=\"ResolveSomeMore\"/>\n</JiraJelly>";
        this.administration.runJellyScript("<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-2\" user=\"admin\" workflowAction=\"ResolveSomeMore\"/>\n</JiraJelly>");
        this.tester.assertTextPresent("Jelly script completed successfully.");
        this.navigation.issue().viewIssue("HSP-2");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Resolution:", "Fixed");
        this.tester.assertLinkNotPresentWithText("Resolve Issue");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(CollectionBuilder.newBuilder(new ExpectedChangeHistoryItem("Status", "Open", "Resolved")).asList()));
    }

    public void testTransitionIssueChangingAllFieldValues() {
        this.assertFieldValues("HSP-2", ISSUE_DETAILS_FIELD_VALUE_MAP, FIELD_VALUE_MAP);
        String validScriptPrefix = "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-2\" user=\"admin\" workflowAction=\"ResolveSomeMore\" resolution=\"Won't Fix\"";
        String validScriptPostfix = "\n</jira:TransitionWorkflow></JiraJelly >";
        LinkedHashMap<String, Object> issueDetails = new LinkedHashMap<String, Object>(ISSUE_DETAILS_FIELD_VALUE_MAP);
        LinkedHashMap<String, Object> fieldDetails = new LinkedHashMap<String, Object>(FIELD_VALUE_MAP);
        for (Map.Entry<String, FieldDetail> fieldUpdateEntry : FIELD_UPDATE_MAP.entrySet()) {
            String fieldId = fieldUpdateEntry.getKey();
            FieldDetail fieldDetail = fieldUpdateEntry.getValue();
            this.log("Updating field '" + fieldId + "' with '" + fieldDetail);
            String script = fieldDetail.optionalId == null ? (fieldId.startsWith("customfield_") ? "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-2\" user=\"admin\" workflowAction=\"ResolveSomeMore\" resolution=\"Won't Fix\"" + ">\n" + "<jira:AddCustomFieldValue id=\"" + fieldId + "\" value=\"" + fieldDetail.fieldUpdateValue[0] + "\"/>" + "\n</jira:TransitionWorkflow></JiraJelly >" : "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-2\" user=\"admin\" workflowAction=\"ResolveSomeMore\" resolution=\"Won't Fix\"" + " " + fieldId + "=\"" + fieldDetail.fieldUpdateValue[0] + "\">" + "\n</jira:TransitionWorkflow></JiraJelly >") : "<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\">\n    <jira:TransitionWorkflow key=\"HSP-2\" user=\"admin\" workflowAction=\"ResolveSomeMore\" resolution=\"Won't Fix\"" + ">\n" + "<jira:AddCustomFieldValue id=\"" + fieldId + "\" value=\"" + fieldDetail.fieldUpdateValue[0] + "\"/>\n" + "<jira:AddCustomFieldValue id=\"" + fieldId + "\" value=\"" + fieldDetail.fieldUpdateValue[1] + "\" key=\"1\"/>" + "\n</jira:TransitionWorkflow></JiraJelly >";
            this.administration.runJellyScript(script);
            this.tester.assertTextPresent("Jelly script completed successfully.");
            this.navigation.issue().viewIssue("HSP-2");
            if (fieldDetail.isIssueDetail) {
                issueDetails.put(fieldDetail.getFieldName(), Arrays.asList(fieldDetail.getFieldUpdateName()));
            } else {
                fieldDetails.put(fieldDetail.getFieldName(), Arrays.asList(fieldDetail.getFieldUpdateName()));
            }
            this.assertFieldValues("HSP-2", issueDetails, fieldDetails);
        }
    }

    public void testTransitionIssueRemovingAllFieldValues() {
    }

    private void assertFieldValues(String issueKey, Map<String, Object> issueDetails, Map<String, Object> fieldDetails) {
        this.navigation.issue().viewIssue(issueKey);
        List<String> issueDetailAssertions = this.getTextAssertions(issueDetails);
        this.text.assertTextSequence(new WebPageLocator(this.tester), issueDetailAssertions.toArray(new String[issueDetailAssertions.size()]));
        List<String> textAssertions = this.getTextAssertions(fieldDetails);
        this.text.assertTextSequence(new WebPageLocator(this.tester), textAssertions.toArray(new String[textAssertions.size()]));
    }

    private List<String> getTextAssertions(Map<String, Object> fieldValueMap) {
        ArrayList<String> textAssertions = new ArrayList<String>();
        for (Map.Entry<String, Object> fieldEntry : fieldValueMap.entrySet()) {
            textAssertions.add(fieldEntry.getKey());
            if (fieldEntry.getValue() == null) continue;
            if (fieldEntry.getValue() instanceof Collection) {
                textAssertions.addAll((Collection)fieldEntry.getValue());
                continue;
            }
            textAssertions.add((String)fieldEntry.getValue());
        }
        return textAssertions;
    }

    static {
        ISSUE_DETAILS_FIELD_VALUE_MAP.put("Key", "HSP-2");
        ISSUE_DETAILS_FIELD_VALUE_MAP.put("Type", "Bug");
        ISSUE_DETAILS_FIELD_VALUE_MAP.put("Status", "Resolved");
        ISSUE_DETAILS_FIELD_VALUE_MAP.put("Resolution", "Fixed");
        ISSUE_DETAILS_FIELD_VALUE_MAP.put("Priority", "Minor");
        ISSUE_DETAILS_FIELD_VALUE_MAP.put("Assignee", "Administrator");
        ISSUE_DETAILS_FIELD_VALUE_MAP.put("Assignee", "Administrator");
        ISSUE_DETAILS_FIELD_VALUE_MAP.put("Reporter", "Administrator");
        FIELD_VALUE_MAP.put("Values in all fields", null);
        FIELD_VALUE_MAP.put("Component/s:", "New Component 1");
        FIELD_VALUE_MAP.put("Affects Version/s:", CollectionBuilder.newBuilder("New Version 1", "New Version 4").asList());
        FIELD_VALUE_MAP.put("Fix Version/s:", CollectionBuilder.newBuilder("New Version 1", "New Version 4").asList());
        FIELD_VALUE_MAP.put("Environment:", "My environment is MacOs");
        FIELD_VALUE_MAP.put("Date picker cf:", "07/Apr/09");
        FIELD_VALUE_MAP.put("Date time:", "29/Apr/09 03:01 PM");
        FIELD_VALUE_MAP.put("Free Text CF:", "This is some free text");
        FIELD_VALUE_MAP.put("Group Picker:", "jira-administrators");
        FIELD_VALUE_MAP.put("Multi Checkbox:", "red");
        FIELD_VALUE_MAP.put("Multi Group Picker CF:", CollectionBuilder.newBuilder("jira-administrators", "and", "jira-developers").asList());
        FIELD_VALUE_MAP.put("Multi User CF:", CollectionBuilder.newBuilder("Administrator", "and", "Fred Normal").asList());
        FIELD_VALUE_MAP.put("Multi select:", "monkey");
        FIELD_VALUE_MAP.put("Number CF:", "123,123");
        FIELD_VALUE_MAP.put("Project picker CF:", "homosapien");
        FIELD_VALUE_MAP.put("Radio Buttons CF:", "TV");
        FIELD_VALUE_MAP.put("Select CF:", "Nokia");
        FIELD_VALUE_MAP.put("Single Version CF:", "New Version 1");
        FIELD_VALUE_MAP.put("URL CF:", "http://www.msn.com/");
        FIELD_VALUE_MAP.put("Text CF:", "The sky is blue");
        FIELD_VALUE_MAP.put("Version CF:", "New Version 1");
        FIELD_VALUE_MAP.put("cascadingSelect:", CollectionBuilder.newBuilder("Fruit", "banana").asList());
        FIELD_VALUE_MAP.put("user picker CF:", "Administrator");
        FIELD_VALUE_MAP.put("Description", "This is a really boring issue with an even lamer description.");
        FIELD_VALUE_MAP.put("Yay! all fields have a value!", null);
        FIELD_UPDATE_MAP.put("resolution", new FieldDetail("Resolution", "2", "Won't Fix", true));
        FIELD_UPDATE_MAP.put("fixVersions", new FieldDetail("Fix Version/s:", "10002", "New Version 5", false));
        FIELD_UPDATE_MAP.put("customfield_10000", new FieldDetail("cascadingSelect:", new String[]{"10012", "10016"}, new String[]{"Vegetable", "carrot"}, false, "customfield_10000:1"));
        FIELD_UPDATE_MAP.put("customfield_10001", new FieldDetail("Date time:", "14/Apr/09 01:01 PM", "14/Apr/09 01:01 PM", false));
        FIELD_UPDATE_MAP.put("customfield_10002", new FieldDetail("Group Picker:", "jira-users", "jira-users", false));
        FIELD_UPDATE_MAP.put("customfield_10003", new FieldDetail("Multi Checkbox:", "blue", "blue", false));
        FIELD_UPDATE_MAP.put("customfield_10004", new FieldDetail("Multi select:", "cat", "cat", false));
        FIELD_UPDATE_MAP.put("customfield_10005", new FieldDetail("Number CF:", "344", "344", false));
        FIELD_UPDATE_MAP.put("customfield_10006", new FieldDetail("Radio Buttons CF:", "Radio", "Radio", false));
        FIELD_UPDATE_MAP.put("customfield_10007", new FieldDetail("Select CF:", "Apple", "Apple", false));
        FIELD_UPDATE_MAP.put("customfield_10008", new FieldDetail("Text CF:", "The sea is blue too", "The sea is blue too", false));
        FIELD_UPDATE_MAP.put("customfield_10009", new FieldDetail("user picker CF:", "fred", "Fred Normal", false));
        FIELD_UPDATE_MAP.put("customfield_10010", new FieldDetail("Date picker cf:", "1/Apr/09", "1/Apr/09", false));
        FIELD_UPDATE_MAP.put("customfield_10011", new FieldDetail("Free Text CF:", "Lorem ipsum", "Lorem ipsum", false));
        FIELD_UPDATE_MAP.put("customfield_10013", new FieldDetail("Multi Group Picker CF:", "jira-users", "jira-users", false));
        FIELD_UPDATE_MAP.put("customfield_10014", new FieldDetail("Multi User CF:", "fred", "Fred Normal", false));
        FIELD_UPDATE_MAP.put("customfield_10015", new FieldDetail("Project picker CF:", "10001", "monkey", false));
        FIELD_UPDATE_MAP.put("customfield_10017", new FieldDetail("Single Version CF:", "10001", "New Version 4", false));
        FIELD_UPDATE_MAP.put("customfield_10018", new FieldDetail("URL CF:", "http://www.google.com", "http://www.google.com", false));
        FIELD_UPDATE_MAP.put("customfield_10019", new FieldDetail("Version CF:", "10002", "New Version 5", false));
        FIELD_UPDATE_MAP.put("versions", new FieldDetail("Affects Version/s:", "10002", "New Version 5", false));
        FIELD_UPDATE_MAP.put("components", new FieldDetail("Component/s:", "10002", "New Component 3", false));
        FIELD_UPDATE_MAP.put("description", new FieldDetail("Description", "A better description.", "A better description.", false));
        FIELD_UPDATE_MAP.put("environment", new FieldDetail("Environment:", "Actually the environment is windows", "Actually the environment is windows", false));
        FIELD_UPDATE_MAP.put("priority", new FieldDetail("Priority", "2", "Critical", true));
    }

    private static class FieldDetail {
        private String fieldName;
        private String[] fieldUpdateValue;
        private String[] fieldUpdateName;
        private boolean isIssueDetail;
        private String optionalId;

        private FieldDetail(String fieldName, String fieldUpdateValue, String fieldUpdateName, boolean issueDetail) {
            this.fieldName = fieldName;
            this.fieldUpdateValue = new String[]{fieldUpdateValue};
            this.fieldUpdateName = new String[]{fieldUpdateName};
            this.isIssueDetail = issueDetail;
        }

        private FieldDetail(String fieldName, String[] fieldUpdateValue, String[] fieldUpdateName, boolean issueDetail, String optionalId) {
            this.fieldName = fieldName;
            this.fieldUpdateValue = fieldUpdateValue;
            this.fieldUpdateName = fieldUpdateName;
            this.isIssueDetail = issueDetail;
            this.optionalId = optionalId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String[] getFieldUpdateValue() {
            return this.fieldUpdateValue;
        }

        public boolean isIssueDetail() {
            return this.isIssueDetail;
        }

        public String[] getFieldUpdateName() {
            return this.fieldUpdateName;
        }

        public String getOptionalId() {
            return this.optionalId;
        }

        public String toString() {
            return "{fieldUpdateValue=" + (this.fieldUpdateValue == null ? null : Arrays.asList(this.fieldUpdateValue)) + ", fieldUpdateName=" + (this.fieldUpdateName == null ? null : Arrays.asList(this.fieldUpdateName)) + '}';
        }
    }
}

