/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.jelly;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;

public class TestJellyAddComment
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestJellyAddComment.xml");
    }

    public void testAddCommentNoDate() {
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "This is a first comment.");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created:", "2:21 PM", "Updated:", "2:21 PM");
        String script = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\" xmlns:core=\"jelly:core\">\n  <jira:AddComment issue-key=\"HSP-1\" commenter=\"admin\" comment=\"This is a first comment.\"/>\n</JiraJelly>";
        this.administration.runJellyScript(script);
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "This is a first comment.");
    }

    public void testAddCommentWithCreatedDate() {
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "This is a second comment.");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created:", "2:21 PM", "Updated:", "2:21 PM");
        String script = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\" xmlns:core=\"jelly:core\">\n  <jira:AddComment issue-key=\"HSP-1\" commenter=\"admin\" comment=\"This is a second comment.\" created=\"2008-10-02 11:54:12.0\"/>\n</JiraJelly>";
        this.administration.runJellyScript("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\" xmlns:core=\"jelly:core\">\n  <jira:AddComment issue-key=\"HSP-1\" commenter=\"admin\" comment=\"This is a second comment.\" created=\"2008-10-02 11:54:12.0\"/>\n</JiraJelly>");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "This is a second comment.");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created:", "2:21 PM", "Updated:", "02/Oct/08 11:54 AM");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Administrator", "added a comment", "02/Oct/08 11:54 AM");
    }

    public void testAddCommentWithUpdatedDate() {
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "This is a second comment.");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created:", "2:21 PM", "Updated:", "2:21 PM");
        String script = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\" xmlns:core=\"jelly:core\">\n  <jira:AddComment issue-key=\"HSP-1\" commenter=\"admin\" comment=\"This is a second comment.\" created=\"2008-10-02 11:54:12.0\" updated=\"2008-12-02 11:54:12.0\"/>\n</JiraJelly>";
        this.administration.runJellyScript("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\" xmlns:core=\"jelly:core\">\n  <jira:AddComment issue-key=\"HSP-1\" commenter=\"admin\" comment=\"This is a second comment.\" created=\"2008-10-02 11:54:12.0\" updated=\"2008-12-02 11:54:12.0\"/>\n</JiraJelly>");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "This is a second comment.");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created:", "2:21 PM", "Updated:", "02/Dec/08 11:54 AM");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Administrator", "added a comment", "02/Oct/08 11:54 AM", "edited");
    }

    public void testAddCommentWithDateDontTweakIssueUpdateDate() {
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "This is a third comment.");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created:", "2:21 PM", "Updated:", "2:21 PM");
        String script = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\" xmlns:core=\"jelly:core\">\n  <jira:AddComment issue-key=\"HSP-1\" commenter=\"admin\" comment=\"This is a third comment.\" created=\"2008-10-02 11:54:12.0\" tweakIssueUpdateDate=\"false\"/>\n</JiraJelly>";
        this.administration.runJellyScript("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<JiraJelly xmlns:jira=\"jelly:com.atlassian.jira.jelly.enterprise.JiraTagLib\" xmlns:core=\"jelly:core\">\n  <jira:AddComment issue-key=\"HSP-1\" commenter=\"admin\" comment=\"This is a third comment.\" created=\"2008-10-02 11:54:12.0\" tweakIssueUpdateDate=\"false\"/>\n</JiraJelly>");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "This is a third comment.");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created:", "2:21 PM", "Updated:", "2:21 PM");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Administrator", "added a comment", "02/Oct/08 11:54 AM");
    }
}

