/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.cargo;

import com.atlassian.cargotestrunner.testrunner.TestRunner;
import com.atlassian.cargotestrunner.testrunner.TestRunnerConfig;
import com.atlassian.cargotestrunner.webtest.TestSetupCallbackFactory;
import com.atlassian.core.util.FileUtils;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.webtests.AcceptanceTestHarness;
import com.atlassian.jira.webtests.cargo.JIRACallbackFactory;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoTestHarness {
    public static final String URL_PREFIX = "/atlassian-jira";
    public static final String DEFAULT_CONTAINERS_LOCATION = "src/etc/java/containers.properties";
    public static final String DEFAULT_WAR_LOCATION = "../../target/atlassian-jira";
    public static final String CONTAINER_LOCATION_PROPERTY = "jira.functest.containerproperties";
    public static final String WAR_LOCATION_PROPERTY = "jira.functest.warlocation";
    public static final String CONTAINERS_PROPERTY = "cargo.containers";
    public static final String DELETE_TEMP_DIR_PROPERTY = "cargo.container.deleteTempDirectory";

    public static Test suite() throws IOException {
        FuncTestOut.out.println("_________________________");
        FuncTestOut.out.println("JIRA CargoTestHarness has started...");
        FuncTestOut.out.println("_________________________");
        CargoTestHarness.printSystemPropertiesInEffect();
        File containerProperties = CargoTestHarness.initContainerProperties();
        File war = CargoTestHarness.initWarFile();
        return CargoTestHarness.suite(war, containerProperties);
    }

    private static void printSystemPropertiesInEffect() {
        Properties properties = System.getProperties();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object object : properties.keySet()) {
            keys.add((String)object);
        }
        Collections.sort(keys);
        FuncTestOut.out.println("The following (" + keys.size() + ") Java System properties are in effect");
        for (String string : keys) {
            String value = properties.getProperty(string);
            FuncTestOut.out.println("\t" + string + " : " + value);
        }
        FuncTestOut.out.println("_________________________");
    }

    protected static File initWarFile() throws IOException {
        String warLocation = System.getProperty(WAR_LOCATION_PROPERTY, DEFAULT_WAR_LOCATION);
        FuncTestOut.out.println("Using war from '" + warLocation + "'");
        File war = new File(warLocation);
        if (!war.exists()) {
            throw new RuntimeException("Could not find JIRA war at " + war.getCanonicalPath() + ".  Please ensure that the working directory is the functional test dir");
        }
        return war;
    }

    protected static File initContainerProperties() throws IOException {
        String containerPropertiesLocation = System.getProperty(CONTAINER_LOCATION_PROPERTY, DEFAULT_CONTAINERS_LOCATION);
        FuncTestOut.out.println("Using container properties from '" + containerPropertiesLocation + "'");
        File containerProperties = new File(containerPropertiesLocation);
        if (!containerProperties.exists()) {
            throw new RuntimeException("Could not find containers.properties at " + containerProperties.getCanonicalPath() + ".  Please ensure that the working directory is the functional test dir");
        }
        CargoTestHarness.testTempDirectoryIsEmpty(containerProperties);
        return containerProperties;
    }

    protected static void testTempDirectoryIsEmpty(File containerProperties) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(containerProperties));
        Collection containerIds = CargoTestHarness.getContainerNames(properties);
        for (String containerId : containerIds) {
            File containerTempDirectory = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + containerId);
            if (!containerTempDirectory.exists()) continue;
            if ("true".equalsIgnoreCase(properties.getProperty(DELETE_TEMP_DIR_PROPERTY))) {
                FuncTestOut.out.println("Deleting temp directory " + containerTempDirectory);
                boolean deleted = FileUtils.deleteDir((File)containerTempDirectory);
                FuncTestOut.out.println("Temp Directory deleted: " + deleted);
                continue;
            }
            throw new IllegalStateException("File " + containerTempDirectory.getCanonicalPath() + " exists and property " + DELETE_TEMP_DIR_PROPERTY + " is not set.  Cargo will not be able to run.");
        }
    }

    private static Collection getContainerNames(Properties serverProperties) {
        Collection containerNames;
        String containersList = serverProperties.getProperty(CONTAINERS_PROPERTY);
        if (containersList == null) {
            FuncTestOut.out.println("Empty list of containerNames.  Please set property 'cargo.containers'");
            containerNames = Collections.EMPTY_LIST;
        } else {
            containerNames = CargoTestHarness.parseContainersList(containersList);
        }
        if (containerNames.isEmpty()) {
            FuncTestOut.out.println("Empty list of containerNames.  Please set property 'cargo.containers'");
        }
        return containerNames;
    }

    private static Collection parseContainersList(String containersList) {
        StringTokenizer st = new StringTokenizer(containersList, " ,", false);
        ArrayList<String> containers = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            containers.add(token);
        }
        return containers;
    }

    private static void setTestTotal(Collection<Class<? extends TestCase>> tests) {
        TestSuite testSuite = new TestSuite();
        for (Class<? extends TestCase> testClass : tests) {
            testSuite.addTestSuite(testClass);
        }
        TestInformationKit.startTestSuite(testSuite.countTestCases());
    }

    public static Test suite(File warLocation, File containerProperties) throws IOException {
        Set<Class<? extends TestCase>> tests = AcceptanceTestHarness.SUITE.getTests(new LocalTestEnvironmentData());
        CargoTestHarness.setTestTotal(tests);
        Properties properties = CargoTestHarness.getProperties(containerProperties);
        boolean distributeTests = Boolean.valueOf(properties.getProperty("cargo.containers.distribute"));
        return TestRunner.suite(tests, (Properties)properties, (TestSetupCallbackFactory)new JIRACallbackFactory(URL_PREFIX), (File)warLocation, (TestRunnerConfig)new TestRunnerConfig(true, false, distributeTests));
    }

    public static Properties getProperties(File containerProperties) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(containerProperties));
        return properties;
    }
}

