/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.functest.framework.util.dom.SneakyDomExtractor;
import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.atlassian.jira.webtests.WebTestCaseWrapper;
import com.meterware.httpunit.Button;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import net.sourceforge.jwebunit.util.ExceptionUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AbstractAtlassianWebTestCase
extends WebTestCaseWrapper {
    static final HTMLElementPredicate TABLE_CLASS_IS = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return ((String)criteria).equalsIgnoreCase(((WebTable)htmlElement).getClassName());
        }
    };
    private final Map<String, String> responseTextMap = new WeakHashMap<String, String>();

    AbstractAtlassianWebTestCase(String name) {
        super(name);
    }

    protected void clickButtonWithValue(String value) {
        this.assertButtonPresentWithValue(value);
        Button buttonToClick = null;
        Button[] buttons = this.getDialog().getForm().getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            Button button = buttons[i];
            if (!value.equals(button.getValue())) continue;
            buttonToClick = button;
            break;
        }
        try {
            AbstractAtlassianWebTestCase.assertNotNull(buttonToClick);
            if (buttonToClick.getID() != null) {
                this.clickButton(buttonToClick.getID());
            } else {
                if (buttonToClick.getName() != null) {
                    this.setFormElement(buttonToClick.getName(), buttonToClick.getValue());
                }
                this.submit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString((Throwable)e));
        }
    }

    protected void clickAnyButtonWithValue(String value) {
        this.assertAnyButtonPresentWithValue(value);
        Button buttonToClick = null;
        Button[] buttons = this.getDialog().getForm().getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            Button button = buttons[i];
            if (!value.equals(button.getValue())) continue;
            buttonToClick = button;
            break;
        }
        try {
            AbstractAtlassianWebTestCase.assertNotNull(buttonToClick);
            if (buttonToClick.getID() != null) {
                this.clickButton(buttonToClick.getID());
            } else {
                if (buttonToClick.getName() != null) {
                    this.setFormElement(buttonToClick.getName(), buttonToClick.getValue());
                }
                this.submit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString((Throwable)e));
        }
    }

    private void assertButtonPresentWithValue(String value) {
        Button buttonToAssert = null;
        Button[] buttons = this.getDialog().getForm().getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            Button button = buttons[i];
            if (!value.equals(button.getValue())) continue;
            if (buttonToAssert != null) {
                AbstractAtlassianWebTestCase.fail((String)("Found multiple buttons with value: " + value + "\n" + this.foundButtons()));
            }
            buttonToAssert = button;
        }
        if (buttonToAssert == null) {
            AbstractAtlassianWebTestCase.fail((String)("Did not find button with value: " + value + "\n" + this.foundButtons()));
        }
    }

    private void assertAnyButtonPresentWithValue(String value) {
        Button[] buttons = this.getDialog().getForm().getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            Button button = buttons[i];
            if (!value.equals(button.getValue())) continue;
            return;
        }
        AbstractAtlassianWebTestCase.fail((String)("Did not find button with value: " + value));
    }

    private String foundButtons() {
        StringBuffer result = new StringBuffer();
        Button[] buttons = this.getDialog().getForm().getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            Button button = buttons[i];
            result.append("Button[");
            if (button.getID() != null) {
                result.append("id:").append(button.getID()).append(" ");
            }
            result.append(button.getName());
            result.append("=");
            result.append(button.getValue());
            result.append("]");
            if (i == buttons.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    protected boolean hasLinkWithText(String linkText) {
        try {
            return this.getDialog().getResponse().getLinkWith(linkText) != null;
        }
        catch (SAXException e) {
            AbstractAtlassianWebTestCase.raiseRuntimeException(e);
            return false;
        }
    }

    protected boolean hasLinkWithName(String linkName) {
        try {
            return this.getDialog().getResponse().getLinkWithName(linkName) != null;
        }
        catch (SAXException e) {
            AbstractAtlassianWebTestCase.raiseRuntimeException(e);
            return false;
        }
    }

    protected void assertLinkWithTextExists(String linkText) {
        AbstractAtlassianWebTestCase.assertTrue((boolean)this.hasLinkWithText(linkText));
    }

    protected void assertLinkWithTextNotPresent(String linkText) {
        AbstractAtlassianWebTestCase.assertFalse((boolean)this.hasLinkWithText(linkText));
    }

    protected void assertLinkWithNameExists(String linkName) {
        AbstractAtlassianWebTestCase.assertTrue((boolean)this.hasLinkWithName(linkName));
    }

    protected void assertLinkWithNameNotPresent(String linkName) {
        AbstractAtlassianWebTestCase.assertFalse((boolean)this.hasLinkWithName(linkName));
    }

    public void assertTextPresentBeforeText(String before, String after) {
        String text;
        AbstractAtlassianWebTestCase.log("Asserting text \"" + before + "\" is present before text \"" + after + "\"");
        this.assertTextPresent(before);
        try {
            text = this.getDialog().getResponse().getText();
        }
        catch (IOException e) {
            e.printStackTrace();
            AbstractAtlassianWebTestCase.fail((String)e.getMessage());
            return;
        }
        int firstTextLocation = text.indexOf(before);
        int secondTextLocation = text.substring(firstTextLocation + before.length()).indexOf(after);
        AbstractAtlassianWebTestCase.assertTrue((String)(after + " should come after " + before), (secondTextLocation >= 0 ? 1 : 0) != 0);
        AbstractAtlassianWebTestCase.assertTrue((firstTextLocation < (secondTextLocation += firstTextLocation + before.length()) ? 1 : 0) != 0);
    }

    protected void assertTextPresentOnlyOnce(String text1) {
        this.assertTextPresent(text1, 1);
    }

    public void assertTextPresent(String text1, int numOccurrences) {
        String body;
        if (numOccurrences < 0) {
            throw new IllegalArgumentException("numOccurrences must not be negative!");
        }
        AbstractAtlassianWebTestCase.log("Asserting text \"" + text1 + "\" is present exactly " + numOccurrences + " times");
        try {
            body = this.getDialog().getResponse().getText().trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            AbstractAtlassianWebTestCase.fail((String)e.getMessage());
            return;
        }
        int bodyLength = body.length();
        int index = -1;
        int i = 0;
        while (index + 1 < bodyLength && (index = body.indexOf(text1, index + 1)) != -1) {
            AbstractAtlassianWebTestCase.log("Number of times found: " + ++i);
        }
        AbstractAtlassianWebTestCase.assertTrue((String)("Found text: " + i + " times; expected: " + numOccurrences), (i == numOccurrences ? 1 : 0) != 0);
    }

    protected void assertTextPresentAfterText(String after, String before) {
        this.assertTextPresentBeforeText(before, after);
    }

    protected void assertLessThan(int a, int b) {
        AbstractAtlassianWebTestCase.assertTrue((a < b ? 1 : 0) != 0);
    }

    public void assertTextSequence(String[] text) {
        this.assertTextSequence("", text);
    }

    public void assertTextSequence(String failMesgPrefix, String[] text) {
        String response = this.getDialog().getResponseText();
        int indexOfMissing = AbstractAtlassianWebTestCase.findTextSequence(response, text);
        if (indexOfMissing != -1) {
            AbstractAtlassianWebTestCase.fail((String)(failMesgPrefix + " failed to find text '" + text[indexOfMissing] + "' in sequence position " + indexOfMissing));
        }
    }

    public static int findTextSequence(String stringToSearch, String[] sequenceToFind) {
        int startIndex = 0;
        for (int i = 0; i < sequenceToFind.length; ++i) {
            int index = stringToSearch.indexOf(sequenceToFind[i], startIndex);
            if (index == -1) {
                return i;
            }
            startIndex = index + sequenceToFind[i].length();
        }
        return -1;
    }

    public static String[] flattenArray(String[][] text) {
        int newsize = 0;
        for (int i = 0; i < text.length; ++i) {
            newsize += text[i].length;
        }
        String[] flat = new String[newsize];
        int flatPos = 0;
        for (int i = 0; i < text.length; ++i) {
            System.arraycopy(text[i], 0, flat, flatPos, text[i].length);
            flatPos += text[i].length;
        }
        return flat;
    }

    protected String getResponseText() {
        try {
            return this.getDialog().getResponse().getText();
        }
        catch (IOException e) {
            e.printStackTrace();
            AbstractAtlassianWebTestCase.fail((String)e.getMessage());
            return null;
        }
    }

    protected String getCollapsedResponseText() {
        WebResponse response = this.getDialog().getResponse();
        String responseKey = String.valueOf(System.identityHashCode(response));
        String text = this.responseTextMap.get(responseKey);
        if (text == null) {
            Document doc = SneakyDomExtractor.getDOM(this.getTester());
            Element bodyE = DomKit.getBodyElement(doc);
            text = bodyE != null ? DomKit.getCollapsedText(bodyE) : "";
            this.responseTextMap.put(responseKey, text);
        }
        return text;
    }

    protected void assertCollapsedTextSequence(String[] textSequence) {
        String responseText = this.getCollapsedResponseText();
        TextKit.assertContainsTextSequence(responseText, textSequence);
    }

    public WebTable getFirstWebTableWithClass(String className) {
        try {
            return this.getDialog().getResponse().getFirstMatchingTable(TABLE_CLASS_IS, (Object)className);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public WebTable getWebTableWithID(String id) {
        try {
            return this.getDialog().getResponse().getTableWithID(id);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public WebTable[] getWebTablesWithClass(String className) {
        try {
            return this.getDialog().getResponse().getMatchingTables(TABLE_CLASS_IS, (Object)className);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

