/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransformingIterator<I, E>
implements Iterator<E> {
    private final Iterator<? extends I> iterator;
    private final Function<I, E> decorator;

    TransformingIterator(@NotNull Iterator<? extends I> iterator, @NotNull Function<I, E> decorator) {
        this.iterator = Assertions.notNull("iterator", iterator);
        this.decorator = Assertions.notNull("decorator", decorator);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.decorator.get(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

