/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.text;

import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class TestTextAssertions
extends TestCase {
    static final String QBF = "the quick brown fox jumped over the lazy dog";

    public void testAssertTextPresentNumOccurences() throws Exception {
        final TextAssertionsImpl textAssertions = new TextAssertionsImpl();
        textAssertions.assertTextPresentNumOccurences(QBF, "brown", 1);
        textAssertions.assertTextPresentNumOccurences(QBF, "the", 2);
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextPresentNumOccurences(TestTextAssertions.QBF, "the", 3);
            }
        });
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextPresentNumOccurences(TestTextAssertions.QBF, "the", 1);
            }
        });
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextPresentNumOccurences(TestTextAssertions.QBF, "brown", 2);
            }
        });
    }

    public void testBasicStringOperations() throws Exception {
        final TextAssertionsImpl textAssertions = new TextAssertionsImpl();
        this.ensureNoAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextPresent(TestTextAssertions.QBF, "lazy");
            }
        });
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextPresent(TestTextAssertions.QBF, "lazi");
            }
        });
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextPresent(TestTextAssertions.QBF, "doggy");
            }
        });
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextNotPresent(TestTextAssertions.QBF, "dog");
            }
        });
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextSequence(TestTextAssertions.QBF, "quick", "brown", "FAX");
            }
        });
        this.ensureNoAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertTextSequence(TestTextAssertions.QBF, "quick", "brown", "fox jumped o", "ver the");
            }
        });
    }

    public void testBasicRegexOperations() throws Exception {
        final TextAssertionsImpl textAssertions = new TextAssertionsImpl();
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertRegexMatch(TestTextAssertions.QBF, "ly");
            }
        });
        this.ensureNoAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertRegexMatch(TestTextAssertions.QBF, "l.*y");
            }
        });
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertRegexMatch(TestTextAssertions.QBF, "lazi");
            }
        });
        this.ensureAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertRegexNoMatch(TestTextAssertions.QBF, "lazy");
            }
        });
        this.ensureNoAssertionFailed(new Runnable(){

            public void run() {
                textAssertions.assertRegexNoMatch(TestTextAssertions.QBF, "tim");
            }
        });
    }

    private void ensureAssertionFailed(Runnable assertionRunnable) {
        try {
            assertionRunnable.run();
        }
        catch (AssertionFailedError e) {
            return;
        }
        TestTextAssertions.fail((String)"Did not throw AssertionFailedError as expected");
    }

    private void ensureNoAssertionFailed(Runnable assertionRunnable) {
        try {
            assertionRunnable.run();
        }
        catch (AssertionFailedError e) {
            TestTextAssertions.fail((String)"Unexpected AssertionFailedError");
        }
    }
}

