/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.mocks;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.AbstractHandler;

public class MockWebServer {
    private static final Logger log = Logger.getLogger(MockWebServer.class);
    private final int port;
    private final Map contentMap = new HashMap();
    private Server server;
    private static final int HTTP_PORT = 50789;

    public static MockWebServer getInstance() {
        MockWebServer mockWebServer = LazyHolder.WEB_SERVER;
        return MockWebServer.startWebServer(mockWebServer);
    }

    private static MockWebServer startWebServer(MockWebServer mockWebServer) {
        if (!mockWebServer.isStarted()) {
            try {
                mockWebServer.start();
            }
            catch (BindException be) {
                int newPort = mockWebServer.getPort() + 10;
                log.warn((Object)("Trying to start mockWebServer failed on port '" + mockWebServer.getPort() + "'.  Retrying on '" + newPort + "'."));
                return MockWebServer.startWebServer(new MockWebServer(newPort));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return mockWebServer;
    }

    MockWebServer(int port) {
        this.port = port;
        this.server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        this.server.setConnectors(new Connector[]{connector});
        MockHandler handler = new MockHandler();
        this.server.setHandler((Handler)handler);
        this.server.setStopAtShutdown(true);
    }

    public int getPort() {
        return this.port;
    }

    public String getHostAndPort() {
        return "http://localhost:" + this.port;
    }

    public void addPage(String pageUrl, String pageContent) {
        this.contentMap.put(pageUrl, pageContent);
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        while (!this.server.isStopped()) {
            Thread.sleep(100L);
        }
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public boolean isStarting() {
        return this.server.isStarting();
    }

    public boolean isStopping() {
        return this.server.isStopping();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }

    protected void finalize() throws Throwable {
        MockWebServer.getInstance().stop();
    }

    public class MockHandler
    extends AbstractHandler {
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            base_request.setHandled(true);
            response.setContentType("text/html");
            response.setStatus(200);
            String content = (String)MockWebServer.this.contentMap.get(target);
            PrintWriter pw = response.getWriter();
            pw.println(content);
        }
    }

    private static class LazyHolder {
        private static final MockWebServer WEB_SERVER = new MockWebServer(50789);

        private LazyHolder() {
        }
    }
}

