/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.locator;

import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.functest.framework.locator.LocatorIterator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TestLocatorIterator
extends TestCase {
    static String[] TEST_STRS = new String[]{"Alpha", "Beta", "Delta", "Gamma"};
    static Node[] TEST_NODES = TestLocatorIterator.createNodes(TEST_STRS);
    static Locator LOCATOR_EMPTY = TestLocatorIterator.createLocator(new Node[0]);
    static Locator LOCATOR = TestLocatorIterator.createLocator(TEST_NODES);

    public void testHasNext() {
        LocatorIterator iterator = new LocatorIterator(LOCATOR_EMPTY);
        TestLocatorIterator.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            TestLocatorIterator.fail((String)"Should have thrown NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        iterator = new LocatorIterator(LOCATOR);
        TestLocatorIterator.assertTrue((boolean)iterator.hasNext());
        for (int i = 0; i < TEST_NODES.length; ++i) {
            TestLocatorIterator.assertTrue((boolean)iterator.hasNext());
            iterator.next();
        }
        TestLocatorIterator.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            TestLocatorIterator.fail((String)"Should have thrown NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public final void testNext() {
        LocatorIterator iterator = new LocatorIterator(LOCATOR);
        TestLocatorIterator.assertTrue((boolean)iterator.hasNext());
        int count = 0;
        while (iterator.hasNext()) {
            LocatorEntry info = (LocatorEntry)iterator.next();
            TestLocatorIterator.assertNotNull((Object)info);
            TestLocatorIterator.assertNotNull((Object)info.getNode());
            TestLocatorIterator.assertNotNull((Object)info.getText());
            TestLocatorIterator.assertEquals((int)count, (int)info.getIndex());
            ++count;
            int i = info.getIndex();
            TestLocatorIterator.assertSame((Object)TEST_NODES[i], (Object)info.getNode());
            TestLocatorIterator.assertEquals((String)TEST_STRS[i], (String)info.getText());
        }
        TestLocatorIterator.assertFalse((boolean)iterator.hasNext());
    }

    public final void testRemove() {
        LocatorIterator iterator = new LocatorIterator(LOCATOR);
        try {
            iterator.remove();
            TestLocatorIterator.fail((String)"expecting UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        while (iterator.hasNext()) {
            iterator.next();
            try {
                iterator.remove();
                TestLocatorIterator.fail((String)"expecting UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    private static Locator createLocator(final Node[] nodes) {
        return new Locator(){

            public Node[] getNodes() {
                return nodes;
            }

            public Node getNode() {
                return null;
            }

            public String getText() {
                return null;
            }

            public String getText(Node node) {
                return node.getNodeValue();
            }

            public Iterator iterator() {
                return null;
            }

            public String getHTML() {
                return null;
            }

            public String getRawText() {
                return null;
            }

            public String getRawText(Node node) {
                return null;
            }

            public String getHTML(Node node) {
                return null;
            }

            public boolean hasNodes() {
                return this.getNodes().length == 0;
            }
        };
    }

    private static Text[] createNodes(String[] textArr) {
        Text[] text = new Text[textArr.length];
        for (int i = 0; i < textArr.length; ++i) {
            TextHandler handler = new TextHandler(textArr[i]);
            text[i] = (Text)Proxy.newProxyInstance(Text.class.getClassLoader(), new Class[]{Text.class}, (InvocationHandler)handler);
        }
        return text;
    }

    static class TextHandler
    implements InvocationHandler {
        private String text;

        public TextHandler(String text) {
            this.text = text;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getNodeValue".equals(method.getName())) {
                return this.text;
            }
            return null;
        }
    }
}

