/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.dom;

import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.functest.unittests.mocks.XmlParserHelper;
import java.lang.reflect.Proxy;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestDomKit
extends TestCase {
    private static final String WITHOUT_SPACES = "text without spaces";
    private static final String WITH_PREFIX_SPACES = "   \ttext with prefix spaces";
    private static final String WITH_SUFFIX_SPACES = "text with suffix spaces \n\t";
    private static final String WITH_SPACES = "\t \ntext with suffix spaces \n \t";
    private static final String WITH_SPACES_IN_THE_MIDDLE = "\t \ntext with     spaces in the middle \n \t";
    private static final String WITH_SPACES_AROUND_A_TAG = "\t \n<b>   text with spaces in  </b>  the middle \n \t";
    private static final String COLLAPSED_WITH_SPACES_AROUND_A_TAG = "text with spaces in the middle";
    private static final String RAW_WITH_SPACES_AROUND_A_TAG = "\t \n   text with spaces in    the middle \n \t";
    private static final String SOME_HTML = "<html><body class=\"bodyclass\"><div id=\"1\">div1</div><div id=\"2\">div2<!-- and a comment --></div><span class=\"c1\">some text with \n \t whitespace</span></body></html>";
    private static final String SOME_HTML_UPPERCASE = "<HTML><BODY class=\"bodyclass\"><DIV id=\"1\">div1</DIV><DIV id=\"2\">div2<!-- and a comment --></DIV><SPAN class=\"c1\">some text with \n \t whitespace</SPAN></BODY></HTML>";
    private static final String SOME_HTML_MIXEDCASE = "<HTML><body class=\"bodyclass\"><DIV id=\"1\">div1</DIV><div id=\"2\">div2<!-- and a comment --></div><SPAN class=\"c1\">some text with \n \t whitespace</SPAN></body></HTML>";

    public void testGetCollapsedText() throws Exception {
        String htmlText = "<HTML><BODY>\t \n<b>   text with spaces in  </b>  the middle \n \t</BODY></HTML>";
        Document document = this.parseXml(htmlText);
        String actualText = DomKit.getCollapsedText(document);
        TestDomKit.assertEquals((String)COLLAPSED_WITH_SPACES_AROUND_A_TAG, (String)actualText);
        htmlText = "<HTML><BODY>text without spaces</BODY></HTML>";
        document = this.parseXml(htmlText);
        actualText = DomKit.getCollapsedText(document);
        TestDomKit.assertEquals((String)WITHOUT_SPACES, (String)actualText);
        htmlText = "<HTML><BODY>text without spaces<b>   \ttext with prefix spaces</b></BODY></HTML>";
        document = this.parseXml(htmlText);
        actualText = DomKit.getCollapsedText(document);
        TestDomKit.assertEquals((String)this.buildExpectedCollapsedString(new String[]{WITHOUT_SPACES, WITH_PREFIX_SPACES}), (String)actualText);
        htmlText = "<HTML><BODY>text without spaces<b>   \ttext with prefix spaces</b>\t \ntext with     spaces in the middle \n \t</BODY></HTML>";
        document = this.parseXml(htmlText);
        actualText = DomKit.getCollapsedText(document);
        TestDomKit.assertEquals((String)this.buildExpectedCollapsedString(new String[]{WITHOUT_SPACES, WITH_PREFIX_SPACES, WITH_SPACES_IN_THE_MIDDLE}), (String)actualText);
        htmlText = "<HTML><BODY>text without spaces<b>   \ttext with prefix spaces</b>\t \ntext with     spaces in the middle \n \t</BODY></HTML>";
        document = this.parseXml(htmlText);
        actualText = DomKit.getCollapsedText(document);
        TestDomKit.assertEquals((String)this.buildExpectedCollapsedString(new String[]{WITHOUT_SPACES, WITH_PREFIX_SPACES, WITH_SPACES_IN_THE_MIDDLE}), (String)actualText);
        htmlText = "<HTML><BODY>text without spaces<b>   \ttext with prefix spaces</b>\t \ntext with     spaces in the middle \n \t<span>text with suffix spaces \n\t</span></BODY></HTML>";
        document = this.parseXml(htmlText);
        actualText = DomKit.getCollapsedText(document);
        TestDomKit.assertEquals((String)this.buildExpectedCollapsedString(new String[]{WITHOUT_SPACES, WITH_PREFIX_SPACES, WITH_SPACES_IN_THE_MIDDLE, WITH_SUFFIX_SPACES}), (String)actualText);
        htmlText = "<HTML><BODY>text without spaces<b>   \ttext with prefix spaces</b>\t \ntext with     spaces in the middle \n \t<span>text with suffix spaces \n\t</span><div>\t \ntext with suffix spaces \n \t</div></BODY></HTML>";
        document = this.parseXml(htmlText);
        actualText = DomKit.getCollapsedText(document);
        TestDomKit.assertEquals((String)this.buildExpectedCollapsedString(new String[]{WITHOUT_SPACES, WITH_PREFIX_SPACES, WITH_SPACES_IN_THE_MIDDLE, WITH_SUFFIX_SPACES, WITH_SPACES}), (String)actualText);
    }

    public void testRawText() throws Exception {
        String htmlText = "<HTML><BODY>\t \n<b>   text with spaces in  </b>  the middle \n \t</BODY></HTML>";
        Document document = this.parseXml(htmlText);
        String actualText = DomKit.getRawText(document);
        TestDomKit.assertEquals((String)RAW_WITH_SPACES_AROUND_A_TAG, (String)actualText);
        htmlText = "<HTML><BODY><div>\t \n<b>   text with spaces in  </b>  the middle \n \t</div><span></span></BODY></HTML>";
        document = this.parseXml(htmlText);
        actualText = DomKit.getRawText(document);
        TestDomKit.assertEquals((String)RAW_WITH_SPACES_AROUND_A_TAG, (String)actualText);
    }

    public void testGetBody() throws Exception {
        String htmlText = "<HTML><BODY instance=\"1\"></BODY></HTML>";
        Document document = this.parseXml(htmlText);
        Element bodyE = DomKit.getBodyElement(document);
        TestDomKit.assertNotNull((Object)bodyE);
        TestDomKit.assertEquals((String)"1", (String)bodyE.getAttribute("instance"));
        document = this.parseXml("<HTML></HTML>");
        bodyE = DomKit.getBodyElement(document);
        TestDomKit.assertNull((Object)bodyE);
        htmlText = "<HTML><BODY instance=\"1\"></BODY><BODY instance=\"2\"></BODY></HTML>";
        document = this.parseXml(htmlText);
        bodyE = DomKit.getBodyElement(document);
        TestDomKit.assertNotNull((Object)bodyE);
        TestDomKit.assertEquals((String)"1", (String)bodyE.getAttribute("instance"));
        htmlText = "<HTML><BODGY instance=\"1\"></BODGY><BODY instance=\"2\"></BODY></HTML>";
        document = this.parseXml(htmlText);
        bodyE = DomKit.getBodyElement(document);
        TestDomKit.assertNotNull((Object)bodyE);
        TestDomKit.assertEquals((String)"2", (String)bodyE.getAttribute("instance"));
    }

    public void testDOMOutput() throws Exception {
        String origHtml = SOME_HTML;
        Document document = this.parseXml(origHtml);
        String htmlText = DomKit.getHTML(document.getDocumentElement());
        TestDomKit.assertNotNull((Object)htmlText);
        TestDomKit.assertEquals((String)origHtml, (String)htmlText);
        htmlText = DomKit.getHTML(document.getDocumentElement().getFirstChild());
        TestDomKit.assertNotNull((Object)htmlText);
        TestDomKit.assertEquals((String)"<body class=\"bodyclass\"><div id=\"1\">div1</div><div id=\"2\">div2<!-- and a comment --></div><span class=\"c1\">some text with \n \t whitespace</span></body>", (String)htmlText);
        htmlText = DomKit.getHTML(document.getDocumentElement().getFirstChild().getFirstChild());
        TestDomKit.assertNotNull((Object)htmlText);
        TestDomKit.assertEquals((String)"<div id=\"1\">div1</div>", (String)htmlText);
        htmlText = DomKit.getInnerHTML(document.getDocumentElement().getFirstChild());
        TestDomKit.assertNotNull((Object)htmlText);
        TestDomKit.assertEquals((String)"<div id=\"1\">div1</div><div id=\"2\">div2<!-- and a comment --></div><span class=\"c1\">some text with \n \t whitespace</span>", (String)htmlText);
    }

    public void testCopyDOM() throws Exception {
        Node srcNode = this.parseXml(SOME_HTML);
        Node targetNode = DomKit.copyDOM(srcNode, false);
        TestDomKit.assertEquals((short)targetNode.getNodeType(), (short)srcNode.getNodeType());
        TestDomKit.assertEquals((short)9, (short)targetNode.getNodeType());
        Element srcElement = srcNode.getDocumentElement();
        Element targetElement = ((Document)targetNode).getDocumentElement();
        TestDomKit.assertEquals((String)targetElement.getTagName(), (String)srcElement.getTagName());
        TestDomKit.assertEquals((String)"html", (String)targetElement.getTagName());
        TestDomKit.assertEquals((String)"body", (String)targetElement.getFirstChild().getNodeName());
        targetElement = (Element)targetElement.getFirstChild();
        TestDomKit.assertEquals((int)2, (int)targetElement.getElementsByTagName("div").getLength());
        TestDomKit.assertEquals((int)0, (int)targetElement.getElementsByTagName("DIV").getLength());
        srcNode = this.parseXml(SOME_HTML_UPPERCASE);
        targetNode = DomKit.copyDOM(srcNode, false);
        TestDomKit.assertEquals((short)targetNode.getNodeType(), (short)srcNode.getNodeType());
        TestDomKit.assertEquals((short)9, (short)targetNode.getNodeType());
        srcElement = srcNode.getDocumentElement();
        targetElement = ((Document)targetNode).getDocumentElement();
        TestDomKit.assertEquals((String)targetElement.getTagName(), (String)srcElement.getTagName());
        TestDomKit.assertEquals((String)"HTML", (String)targetElement.getTagName());
        TestDomKit.assertEquals((String)"BODY", (String)targetElement.getFirstChild().getNodeName());
        targetElement = (Element)targetElement.getFirstChild();
        TestDomKit.assertEquals((int)0, (int)targetElement.getElementsByTagName("div").getLength());
        TestDomKit.assertEquals((int)2, (int)targetElement.getElementsByTagName("DIV").getLength());
        srcNode = this.parseXml(SOME_HTML_MIXEDCASE);
        targetNode = DomKit.copyDOM(srcNode, false);
        TestDomKit.assertEquals((short)targetNode.getNodeType(), (short)srcNode.getNodeType());
        TestDomKit.assertEquals((short)9, (short)targetNode.getNodeType());
        srcElement = srcNode.getDocumentElement();
        targetElement = ((Document)targetNode).getDocumentElement();
        TestDomKit.assertEquals((String)targetElement.getTagName(), (String)srcElement.getTagName());
        TestDomKit.assertEquals((String)"HTML", (String)targetElement.getTagName());
        TestDomKit.assertEquals((String)"body", (String)targetElement.getFirstChild().getNodeName());
        targetElement = (Element)targetElement.getFirstChild();
        TestDomKit.assertEquals((int)1, (int)targetElement.getElementsByTagName("div").getLength());
        TestDomKit.assertEquals((int)1, (int)targetElement.getElementsByTagName("DIV").getLength());
        srcNode = this.parseXml(SOME_HTML_MIXEDCASE);
        targetNode = DomKit.copyDOM(srcNode, true);
        TestDomKit.assertEquals((short)targetNode.getNodeType(), (short)srcNode.getNodeType());
        TestDomKit.assertEquals((short)9, (short)targetNode.getNodeType());
        srcElement = srcNode.getDocumentElement();
        targetElement = ((Document)targetNode).getDocumentElement();
        TestDomKit.assertEquals((String)targetElement.getTagName(), (String)srcElement.getTagName().toLowerCase());
        TestDomKit.assertEquals((String)"html", (String)targetElement.getTagName());
        TestDomKit.assertEquals((String)"body", (String)targetElement.getFirstChild().getNodeName());
        targetElement = (Element)targetElement.getFirstChild();
        TestDomKit.assertEquals((int)2, (int)targetElement.getElementsByTagName("div").getLength());
        TestDomKit.assertEquals((int)0, (int)targetElement.getElementsByTagName("DIV").getLength());
        srcNode = this.parseXml(SOME_HTML);
        srcNode = srcNode.getElementsByTagName("div").item(1);
        targetNode = DomKit.copyDOM(srcNode, true);
        TestDomKit.assertEquals((short)targetNode.getNodeType(), (short)srcNode.getNodeType());
        TestDomKit.assertEquals((short)1, (short)targetNode.getNodeType());
        targetElement = (Element)targetNode;
        TestDomKit.assertEquals((String)"div", (String)targetElement.getTagName());
        Node textNode = targetElement.getFirstChild();
        TestDomKit.assertEquals((short)3, (short)textNode.getNodeType());
        TestDomKit.assertEquals((String)"div2", (String)textNode.getNodeValue());
        TestDomKit.assertEquals((String)"2", (String)targetElement.getAttribute("id"));
    }

    public void testBetterNodeWrapping() throws Exception {
        TestDomKit.assertNull((Object)DomKit.betterNode(null));
        Document origNode = this.parseXml(SOME_HTML_MIXEDCASE);
        TestDomKit.assertFalse((boolean)Proxy.isProxyClass(origNode.getClass()));
        Node betterNode = DomKit.betterNode(origNode);
        TestDomKit.assertNotNull((Object)betterNode);
        Class<?> betterNodeClass = betterNode.getClass();
        TestDomKit.assertNotSame((Object)betterNode, (Object)origNode);
        TestDomKit.assertTrue((boolean)Node.class.isAssignableFrom(betterNodeClass));
        TestDomKit.assertTrue((boolean)Proxy.isProxyClass(betterNodeClass));
        Node doubleWrappedNode = DomKit.betterNode(betterNode);
        TestDomKit.assertSame((Object)betterNode, (Object)doubleWrappedNode);
        Node childNode = betterNode.getFirstChild();
        TestDomKit.assertNotNull((Object)childNode);
        Class<?> childNodeClass = childNode.getClass();
        TestDomKit.assertTrue((boolean)Node.class.isAssignableFrom(childNodeClass));
        TestDomKit.assertTrue((boolean)Proxy.isProxyClass(childNodeClass));
        Node doubleWrappedChildNode = DomKit.betterNode(childNode);
        TestDomKit.assertSame((Object)childNode, (Object)doubleWrappedChildNode);
        String toString = betterNode.toString();
        TestDomKit.assertNotNull((Object)toString);
        TestDomKit.assertTrue((boolean)toString.startsWith("#document-->"));
        toString = childNode.toString();
        TestDomKit.assertNotNull((Object)toString);
        TestDomKit.assertTrue((boolean)toString.startsWith("HTML-->"));
    }

    private String buildExpectedCollapsedString(String[] segments) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            sb.append(segment.trim());
            if (segments.length <= 1 || i >= segments.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    Document parseXml(String xmlText) throws Exception {
        return XmlParserHelper.parseXml(xmlText);
    }
}

