/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.url;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLUtil {
    private static final Logger log = Logger.getLogger(URLUtil.class);

    public static boolean compareURLStrings(String controlLink, String testLink) {
        if (testLink.indexOf(controlLink) != -1) {
            return true;
        }
        if (controlLink.indexOf("?") != -1) {
            Map<String, String> testParams;
            String[] controlStrings = controlLink.split("\\?");
            String[] testStrings = testLink.split("\\?");
            if (testStrings[0].indexOf(controlStrings[0]) == -1) {
                log.info((Object)("Tested URL '" + testStrings[0] + "' did not containt control URL '" + controlStrings[0] + "'"));
                return false;
            }
            Map<String, String> controlParams = URLUtil.getParameters(controlStrings[1]);
            if (!((Object)controlParams).equals(testParams = URLUtil.getParameters(testStrings[1]))) {
                log.info((Object)("Parameters of the tested URL '" + testLink + "' don't equal the control URL '" + controlLink + "'"));
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getQueryParamValueFromUrl(String url, String paramName) {
        String[] urlParts = url.split("\\?");
        if (urlParts.length == 1) {
            return null;
        }
        return URLUtil.getParameters(urlParts[1]).get(paramName);
    }

    public static String getQueryParamValueFromUrl(URL url, String paramName) {
        return URLUtil.getQueryParamValueFromUrl(url.toString(), paramName);
    }

    private static Map<String, String> getParameters(String controlQueryString) {
        StringTokenizer tokenizer = new StringTokenizer(controlQueryString, "&=");
        HashMap<String, String> controlParams = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String paramKey = tokenizer.nextToken();
            String paramValue = tokenizer.nextToken();
            controlParams.put(paramKey, paramValue);
        }
        return controlParams;
    }
}

