/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.dom;

import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DomNodeOutputter {
    private final StringBuffer sb;
    private final boolean useLowerCase;

    public DomNodeOutputter(Node targetNode, StringBuffer sb, boolean useLowerCase) {
        this.sb = sb;
        this.useLowerCase = useLowerCase;
        this.walkNode(targetNode);
    }

    private void walkNode(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 9) {
            this.walkElement(((Document)node).getDocumentElement());
        }
        if (nodeType == 1) {
            this.walkElement(node);
        } else {
            this.outputSimpleNode(node);
        }
    }

    private void walkElement(Node node) {
        Element e = (Element)node;
        this.outputElementOpen(e);
        if (e.hasChildNodes()) {
            NodeList nodeList = e.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node child = nodeList.item(i);
                if (child.getNodeType() == 1) {
                    this.walkElement(child);
                    continue;
                }
                this.outputSimpleNode(child);
            }
        }
        this.outputElementClose(e);
    }

    private void outputSimpleNode(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 2) {
            this.outputAttr(node);
        } else if (nodeType == 3) {
            this.sb.append(node.getNodeValue());
        } else if (nodeType == 8) {
            this.sb.append("<!--");
            this.sb.append(node.getNodeValue());
            this.sb.append("-->");
        } else if (nodeType == 4) {
            CDATASection cdataSection = (CDATASection)node;
            this.sb.append("<![[");
            this.sb.append(cdataSection.getData());
            this.sb.append("]]>");
        }
    }

    private void outputElementOpen(Node node) {
        Element e = (Element)node;
        this.sb.append('<');
        this.sb.append(this.getName(e.getTagName()));
        Attr[] attrs = this.getAttributes(e);
        for (int i = 0; i < attrs.length; ++i) {
            Attr attr = attrs[i];
            this.sb.append(' ');
            this.outputAttr(attr);
        }
        this.sb.append('>');
    }

    private void outputElementClose(Node node) {
        Element e = (Element)node;
        this.sb.append('<');
        this.sb.append('/');
        this.sb.append(this.getName(e.getTagName()));
        this.sb.append('>');
    }

    private void outputAttr(Node node) {
        Attr attr = (Attr)node;
        this.sb.append(attr.getName());
        this.sb.append('=');
        this.sb.append('\"');
        this.sb.append(attr.getValue());
        this.sb.append('\"');
    }

    private Attr[] getAttributes(Element e) {
        ArrayList<Node> l = new ArrayList<Node>();
        NamedNodeMap attrList = e.getAttributes();
        int length = attrList.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = attrList.item(i);
            if (child.getNodeType() != 2) continue;
            l.add(child);
        }
        return l.toArray(new Attr[l.size()]);
    }

    private String getName(String name) {
        return this.useLowerCase ? name.toLowerCase() : name;
    }
}

