/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.setup;

import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.util.text.MsgOfD;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebClientListener;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class JiraSetupInstanceHelper {
    private static final String ADMIN = "admin";
    private final WebTester tester;
    private final JIRAEnvironmentData jiraEnvironmentData;

    public JiraSetupInstanceHelper(WebTester tester, JIRAEnvironmentData jiraEnvironmentData) {
        this.tester = tester;
        this.jiraEnvironmentData = jiraEnvironmentData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void ensureJIRAIsReadyToGo(FuncTestWebClientListener webClientListener) {
        FuncTestOut.log("Checking that JIRA is setup and ready to be tested...");
        if (!this.isJiraSetup(webClientListener)) {
            this.detectJohnson();
            Class<JiraSetupInstanceHelper> clazz = JiraSetupInstanceHelper.class;
            // MONITORENTER : com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper.class
            if (this.isV1LicState()) {
                this.updateV1LicenseState(LicenseKeys.V2_COMMERCIAL);
            } else {
                this.setupJIRA();
            }
            // MONITOREXIT : clazz
        }
        this.login(ADMIN, ADMIN);
        FuncTestOut.log("JIRA is setup and 'admin' is logged in. " + new MsgOfD());
    }

    private boolean isJiraSetup(FuncTestWebClientListener webClientListener) {
        this.tester.beginAt("/");
        this.tester.getDialog().getWebClient().addClientListener((WebClientListener)webClientListener);
        return this.hasBeenSetup();
    }

    private boolean hasBeenSetup() {
        boolean hasBeenSetUp = (this.jiraEnvironmentData.getContext() + "/secure/Dashboard.jspa").equals(this.tester.getDialog().getResponse().getURL().getPath());
        return hasBeenSetUp;
    }

    private void detectJohnson() {
        String response = this.tester.getDialog().getResponseText();
        if (response.contains("JIRA Access Constraints")) {
            Assert.fail((String)"It appears that JIRA is currenty being Johnsoned.  That cant be good!");
        }
    }

    private void setupJIRA() {
        FuncTestOut.log("JIRA is not setup.  Installing a new V2 license and completing setup steps");
        try {
            this.blatInValidLicense(LicenseKeys.V2_COMMERCIAL, "Enterprise");
            this.tester.assertTextPresent("2 of 3");
            this.setupJIRAstep2(ADMIN, ADMIN, "Administrator", "admin@stuff.com.com");
            this.tester.assertTextPresent("3 of 3");
            this.setupJIRAstep3();
            this.tester.assertTextPresent("Setup Complete");
        }
        catch (RuntimeException rte) {
            FuncTestOut.log("Unable to setup JIRA because of " + rte.getMessage());
            throw rte;
        }
    }

    private void setupJIRAstep2(String username, String password, String fullName, String email) {
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        if (!this.tester.getDialog().isTextInResponse("Use existing administrator account")) {
            this.tester.setFormElement("confirm", password);
            this.tester.setFormElement("fullname", fullName);
            this.tester.setFormElement("email", email);
        }
        this.tester.submit();
    }

    private void setupJIRAstep3() {
        this.tester.submit("noemail");
    }

    private void blatInValidLicense(LicenseKeys.License licenseKey, String buildType) {
        this.logLicense(licenseKey);
        this.tester.setFormElement("license", licenseKey.getLicenseString());
        this.tester.submit();
        this.tester.assertTextNotPresent("Invalid license type for this edition of JIRA. License should be of type " + buildType + ".");
    }

    private void login(String username, String password) {
        this.tester.beginAt("/login.jsp");
        this.tester.setFormElement("os_username", username);
        this.tester.setFormElement("os_password", password);
        this.tester.clickButton("login");
    }

    private boolean isV1LicState() {
        String responseText = this.tester.getDialog().getResponseText();
        return responseText.contains("The current version of your license is incompatible with this JIRA installation.");
    }

    private void updateV1LicenseState(LicenseKeys.License licenseKey) {
        FuncTestOut.log("JIRA has data but it contains a V1 license.  Overwriting this with a V2 license");
        this.tester.gotoPage("secure/ConfirmInstallationWithLicense!default.jspa");
        this.tester.assertTextPresent("Confirm License Update");
        this.tester.setWorkingForm("jiraform");
        this.logLicense(licenseKey);
        this.tester.setFormElement("userName", ADMIN);
        this.tester.setFormElement("password", ADMIN);
        this.tester.setFormElement("license", licenseKey.getLicenseString());
        this.tester.submit();
        boolean hasRecovered = this.hasBeenSetup();
        if (!hasRecovered) {
            String message = "It was detected that a V1 license was presented in the data and we tried to upgrade it to V2 but failed";
            FuncTestOut.log("It was detected that a V1 license was presented in the data and we tried to upgrade it to V2 but failed");
            Assert.fail((String)"It was detected that a V1 license was presented in the data and we tried to upgrade it to V2 but failed");
        }
    }

    private void logLicense(LicenseKeys.License licenseKey) {
        FuncTestOut.log("Using a '" + licenseKey.getDescription() + "' license which allows " + licenseKey.getMaxUsers() + " maximum users");
    }
}

