/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser.comment;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.comment.Comment;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class CommentParser {
    public static List getComments(WebTester tester) {
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        XPathLocator xPathLocator = new XPathLocator(tester, "//div[@class='actionContainer']");
        Node[] nodes = xPathLocator.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node actionContainerNode = nodes[i];
            String details = CommentParser.getTextFromSubNode(actionContainerNode, "div[@class='action-details']");
            String links = CommentParser.getTextFromSubNode(actionContainerNode, "div[@class='action-links subText smallgrey']");
            if (details.indexOf("added a comment") == -1 || links.indexOf("Permalink") == -1) continue;
            Comment comment = new Comment();
            comment.setDetails(details);
            comment.setComment(CommentParser.getTextFromSubNode(actionContainerNode, "div[@class='action-body']"));
            commentList.add(comment);
        }
        return commentList;
    }

    private static String getTextFromSubNode(Node node, String xpath) {
        String text = new XPathLocator(node, xpath).getText();
        if (text == null) {
            return null;
        }
        return text.trim();
    }
}

