/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryParser;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.IssueParser;
import com.atlassian.jira.functest.framework.parser.comment.CommentParser;
import com.atlassian.jira.functest.framework.parser.issue.ViewIssueDetails;
import com.atlassian.jira.functest.framework.parser.worklog.WorklogParser;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IssueParserImpl
extends AbstractFuncTestUtil
implements IssueParser {
    public IssueParserImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
    }

    public ViewIssueDetails parseViewIssuePage() {
        ViewIssueDetails viewIssueDetails = new ViewIssueDetails();
        this.parseIssueDetails(viewIssueDetails);
        viewIssueDetails.setAvailableWorkflowActions(this.parseAvailableWorkflowActions(this.tester));
        viewIssueDetails.setComponents(this.parseComponents());
        viewIssueDetails.setAffectsVersions(this.parseAffectsVersions());
        viewIssueDetails.setFixVersions(this.parseFixVersions());
        viewIssueDetails.setSecurityLevel(this.parseSecurityLevel());
        viewIssueDetails.setProjectName(this.parseProjectName());
        viewIssueDetails.setSummary(this.parseSummary());
        viewIssueDetails.setDueDate(this.parseDueDate());
        viewIssueDetails.setCreatedDate(this.parseCreatedDate());
        viewIssueDetails.setUpdatedDate(this.parseUpdatedDate());
        viewIssueDetails.setResolutionDate(this.parseResolutionDate());
        viewIssueDetails.setOriginalEstimate(this.parseOriginalEstimate());
        viewIssueDetails.setRemainingEstimate(this.parseRemaininglEstimate());
        viewIssueDetails.setTimeSpent(this.parseTimeSpent());
        viewIssueDetails.setAttachments(this.parseFileAttachments());
        viewIssueDetails.setEnvironment(this.parseEnvironment());
        viewIssueDetails.setCustomFields(this.parseCustomFields());
        viewIssueDetails.setDescription(this.parseDescription());
        return viewIssueDetails;
    }

    private void parseIssueDetails(ViewIssueDetails viewIssueDetails) {
        WebTable issueDetailsTable = this.tester.getDialog().getWebTableBySummaryOrId("issuedetails");
        HashMap<String, String> issueDetails = new HashMap<String, String>();
        for (int i = 0; i < issueDetailsTable.getRowCount(); ++i) {
            String key = issueDetailsTable.getTableCell(i, 0).asText().trim();
            if (key.endsWith(":")) {
                key = key.substring(0, key.length() - 1);
            }
            String value = issueDetailsTable.getTableCell(i, 1).asText().trim();
            issueDetails.put(key, value);
        }
        viewIssueDetails.setKey((String)issueDetails.get("Key"));
        viewIssueDetails.setIssueType((String)issueDetails.get("Type"));
        viewIssueDetails.setStatus((String)issueDetails.get("Status"));
        viewIssueDetails.setPriority((String)issueDetails.get("Priority"));
        viewIssueDetails.setResolution((String)issueDetails.get("Resolution"));
        viewIssueDetails.setAssignee((String)issueDetails.get("Assignee"));
        viewIssueDetails.setReporter((String)issueDetails.get("Reporter"));
        viewIssueDetails.setVotes((String)issueDetails.get("Votes"));
        viewIssueDetails.setWatchers((String)issueDetails.get("Watchers"));
    }

    private String parseCreatedDate() {
        return this.getValueFromXPath("//table[@id='issue_header']/tr/td/table/tr/td/font/span[1]");
    }

    private String parseUpdatedDate() {
        return this.getValueFromXPath("//table[@id='issue_header']/tr/td/table/tr/td/font/span[2]");
    }

    private String parseEnvironment() {
        return this.getValueFromXPath("//td[@id='environment_field']");
    }

    private String parseDescription() {
        return this.getValueFromXPath("//div[@id='description_full']");
    }

    private Map parseCustomFields() {
        HashMap<String, String> customFields = new HashMap<String, String>();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//table[@id='tab1']/tr/td");
        for (int i = 0; i < xPathLocator.getNodes().length; ++i) {
            Node customFieldNameNode = xPathLocator.getNodes()[i];
            Node customFieldValueNode = xPathLocator.getNodes()[++i];
            String customFieldName = xPathLocator.getText(customFieldNameNode);
            customFieldName = customFieldName.substring(0, customFieldName.length() - 1);
            customFields.put(customFieldName, xPathLocator.getText(customFieldValueNode));
        }
        return customFields;
    }

    private List parseFileAttachments() {
        ArrayList<String> attachments = new ArrayList<String>();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//td[@id='file_attachments']/a");
        for (int i = 0; i < xPathLocator.getNodes().length; ++i) {
            Node node = xPathLocator.getNodes()[i];
            if (i % 2 != 1) continue;
            attachments.add(xPathLocator.getText(node));
        }
        return attachments;
    }

    private List parseAvailableWorkflowActions(WebTester tester) {
        WebTable available_workflow_actions = tester.getDialog().getWebTableBySummaryOrId("available_workflow_actions");
        ArrayList<String> actions = new ArrayList<String>();
        if (available_workflow_actions != null) {
            for (int i = 0; i < available_workflow_actions.getRowCount(); ++i) {
                actions.add(available_workflow_actions.getCellAsText(i, 0).trim());
            }
        }
        return actions;
    }

    private String parseOriginalEstimate() {
        return this.getValueFromXPath("//td[@id='tt_single_values_orig']");
    }

    private String parseTimeSpent() {
        return this.getValueFromXPath("//td[@id='tt_single_values_spent']");
    }

    private String parseRemaininglEstimate() {
        return this.getValueFromXPath("//td[@id='tt_single_values_remain']");
    }

    private String parseDueDate() {
        return this.getValueFromXPath("//table[@id='issue_header']/tr/td/table/tr/td/font/font");
    }

    private String parseResolutionDate() {
        return this.getValueFromXPath("//table[@id='issue_header']/tr/td/table/tr/td/font/span[3]");
    }

    private String parseProjectName() {
        return this.getValueFromXPath("//table[@id='issue_header']/tr/td/table/tr/td/b/a");
    }

    private String parseSummary() {
        return this.getValueFromXPath("//table[@id='issue_header']/tr/td/table/tr/td/h3");
    }

    private String getValueFromXPath(String xpath) {
        XPathLocator xPathLocator = new XPathLocator(this.tester, xpath);
        return xPathLocator.getRawText().trim();
    }

    private List parseComponents() {
        return this.parseCommaSepValueFromIssueHeader(1, 1);
    }

    private List parseAffectsVersions() {
        return this.parseCommaSepValueFromIssueHeader(2, 1);
    }

    private List parseFixVersions() {
        return this.parseCommaSepValueFromIssueHeader(3, 1);
    }

    private String parseSecurityLevel() {
        WebTable issue_header = this.tester.getDialog().getWebTableBySummaryOrId("issue_header");
        if (issue_header.getRowCount() == 5) {
            return issue_header.getCellAsText(4, 1).trim();
        }
        return null;
    }

    private List parseCommaSepValueFromIssueHeader(int row, int column) {
        WebTable issue_header = this.tester.getDialog().getWebTableBySummaryOrId("issue_header");
        String rawValue = issue_header.getTableCell(row, column).asText().trim();
        StringTokenizer st = new StringTokenizer(rawValue, ",");
        ArrayList<String> values = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            values.add(st.nextToken().trim());
        }
        return values;
    }

    public ChangeHistoryList parseChangeHistory() {
        try {
            return ChangeHistoryParser.getChangeHistory(this.tester);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public List parseComments() {
        return CommentParser.getComments(this.tester);
    }

    public List parseWorklogs() {
        return WorklogParser.getWorklogs(this.tester);
    }
}

