/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import net.sourceforge.jwebunit.WebTester;

public class NumberOfIssuesCondition
implements SearchResultsCondition {
    private final TextAssertions assertions;
    private final Integer numberOfIssues;

    public NumberOfIssuesCondition(TextAssertions assertions, Integer numberOfIssues) {
        this.assertions = assertions;
        this.numberOfIssues = numberOfIssues;
    }

    public void assertCondition(WebTester tester) {
        if (this.numberOfIssues <= 0) {
            WebPageLocator locator = new WebPageLocator(tester);
            this.assertions.assertTextPresent(locator, "No matching issues found.");
        } else {
            XPathLocator locator = new XPathLocator(tester, "//div[@class='results-count']/strong[3]");
            this.assertions.assertTextPresent(locator, this.numberOfIssues.toString());
        }
    }
}

