/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorSearch {
    private final Set<NavigatorCondition> conditions;

    public NavigatorSearch(Collection<? extends NavigatorCondition> conditions) {
        this.conditions = new LinkedHashSet<NavigatorCondition>(conditions);
    }

    public NavigatorSearch(NavigatorCondition ... conditions) {
        this(Arrays.asList(conditions));
    }

    public NavigatorSearch(NavigatorCondition condition) {
        this(Collections.singleton(condition));
    }

    public Collection<NavigatorCondition> getConditions() {
        return Collections.unmodifiableCollection(this.conditions);
    }

    public Collection<NavigatorCondition> createConditionsCopy() {
        ArrayList<NavigatorCondition> arrayList = new ArrayList<NavigatorCondition>();
        for (NavigatorCondition navigatorCondition : this.conditions) {
            arrayList.add(navigatorCondition.copyCondition());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Collection<NavigatorCondition> createConditionsForParse() {
        ArrayList<NavigatorCondition> arrayList = new ArrayList<NavigatorCondition>();
        for (NavigatorCondition navigatorCondition : this.conditions) {
            arrayList.add(navigatorCondition.copyConditionForParse());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String toString() {
        return "NavigatorSearch: [Conditions : " + this.conditions + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NavigatorSearch that = (NavigatorSearch)o;
        return ((Object)this.conditions).equals(that.conditions);
    }

    public int hashCode() {
        return ((Object)this.conditions).hashCode();
    }
}

