/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.AbstractNavigationUtil;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebResponse;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueNavigatorNavigationImpl
extends AbstractNavigationUtil
implements IssueNavigatorNavigation {
    private static final String ID_LINK_SWITCHNAVTYPE = "switchnavtype";
    private static final String ID_LINK_VIEWFILTER = "viewfilter";
    private static final String ID_LINK_NEW_FILTER = "new_filter";
    private static final String ID_FILTER_FORM_HEADER = "filterFormHeader";
    private static final String ID_JQL_FORM = "jqlform";
    private static final String NAME_FILTER_FORM = "filterform";
    private static final Pattern CREATE_URL_PATTERN;
    private static final Pattern SAVE_URL_PATTERN;
    private static final String ID_LINK_EDITFILTER = "editfilter";

    public IssueNavigatorNavigationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData);
    }

    @Override
    public IssueNavigatorNavigation.NavigatorMode getCurrentMode() {
        if (!this.isCurrentlyOnNavigator()) {
            return null;
        }
        String selectedTab = StringUtils.trimToNull((String)new XPathLocator(this.tester, "//ul[@id='filterFormHeader']/li[@class='active']").getText());
        if (selectedTab != null) {
            for (IssueNavigatorNavigation.NavigatorMode navigatorMode : IssueNavigatorNavigation.NavigatorMode.values()) {
                if (!navigatorMode.name().equalsIgnoreCase(selectedTab)) continue;
                return navigatorMode;
            }
        }
        HttpUnitDialog dialog = this.tester.getDialog();
        try {
            if (dialog.isLinkPresent(ID_LINK_SWITCHNAVTYPE)) {
                return IssueNavigatorNavigation.NavigatorMode.EDIT;
            }
            if (dialog.getResponse().getFormWithID(ID_JQL_FORM) != null) {
                return IssueNavigatorNavigation.NavigatorMode.EDIT;
            }
            if (dialog.getResponse().getFormWithName(NAME_FILTER_FORM) != null) {
                return IssueNavigatorNavigation.NavigatorMode.EDIT;
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public IssueNavigatorNavigation.NavigatorEditMode getCurrentEditMode() {
        WebResponse webResponse = this.tester.getDialog().getResponse();
        IssueNavigatorNavigation.NavigatorMode mode = this.getCurrentMode();
        if (mode == IssueNavigatorNavigation.NavigatorMode.EDIT || mode == IssueNavigatorNavigation.NavigatorMode.NEW) {
            try {
                if (webResponse.getFormWithID(ID_JQL_FORM) != null) {
                    return IssueNavigatorNavigation.NavigatorEditMode.ADVANCED;
                }
                if (webResponse.getFormWithName(NAME_FILTER_FORM) != null) {
                    return IssueNavigatorNavigation.NavigatorEditMode.SIMPLE;
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void gotoNavigator() {
        if (!this.isCurrentlyOnNavigator()) {
            this.log("going to Navigator page");
            this.tester.clickLink("find_link");
            this.tester.assertTextPresent("Issue Navigator");
        }
    }

    @Override
    public void displayAllIssues() {
        this.tester.setWorkingForm("quicksearch");
        this.tester.setFormElement("searchString", "");
        this.tester.submit();
        this.tester.assertTextPresent("Issue Navigator");
    }

    @Override
    public void loadFilter(long id, IssueNavigatorNavigation.NavigatorEditMode mode) {
        StringBuilder builder = new StringBuilder("secure/IssueNavigator.jspa?mode=");
        if (mode != null) {
            builder.append("show&navType=");
            if (mode == IssueNavigatorNavigation.NavigatorEditMode.SIMPLE) {
                builder.append("simple");
            } else {
                builder.append("advanced");
            }
        } else {
            builder.append("hide");
        }
        builder.append("&requestId=").append(id);
        this.tester.gotoPage(builder.toString());
        this.tester.assertTextNotPresent("The selected filter is not available to you, perhaps it has been deleted or had its permissions changed.");
    }

    @Override
    public void gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode editMode) {
        this.gotoNavigator();
        this.gotoNavigatorMode(IssueNavigatorNavigation.NavigatorMode.EDIT, ID_LINK_EDITFILTER);
        this.switchIntoEditMode(editMode);
    }

    @Override
    public void clickEditModeFlipLink() {
        this.tester.clickLink(ID_LINK_SWITCHNAVTYPE);
    }

    @Override
    public void gotoViewMode() {
        this.gotoNavigator();
        this.gotoNavigatorMode(IssueNavigatorNavigation.NavigatorMode.VIEW, ID_LINK_VIEWFILTER);
    }

    @Override
    public void createSearch(String jqlQuery) {
        this.gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm(ID_JQL_FORM);
        this.tester.setFormElement("jqlQuery", jqlQuery);
        this.tester.submit();
    }

    @Override
    public void createSearch(NavigatorSearch search) {
        this.log("Creating search: " + search);
        this.gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.editSearch(search);
    }

    @Override
    public void modifySearch(NavigatorSearch search) {
        this.log("Modifying search to: " + search);
        this.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.editSearch(search);
    }

    @Override
    public long createNewAndSaveAsFilter(SharedEntityInfo info, NavigatorSearch search) {
        this.createSearch(search);
        return this.saveCurrentAsNewFilter(info);
    }

    @Override
    public long saveCurrentAsNewFilter(SharedEntityInfo info) {
        return this.saveCurrentAsNewFilter(info.getName(), info.getDescription(), info.isFavourite(), info.getSharingPermissions());
    }

    @Override
    public long saveCurrentAsNewFilter(String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        HttpUnitDialog dialog = this.tester.getDialog();
        if (dialog.isLinkPresent("filtersavenew")) {
            this.tester.clickLink("filtersavenew");
        } else if (dialog.isLinkPresent("filtersaveas")) {
            this.tester.clickLink("filtersaveas");
        } else {
            Assert.fail((String)"Unable to find 'filtersavenew' or 'filtersaveas' link on page to save as new filter.");
        }
        if (favourite && (permissions == null || permissions.isEmpty())) {
            this.tester.setFormElement("filterName", name);
            if (!StringUtils.isBlank((String)description)) {
                this.tester.setFormElement("filterDescription", description);
            }
            this.tester.submit("Save");
        } else {
            this.saveUsingPut(name, description, favourite, permissions);
        }
        URL url = dialog.getResponse().getURL();
        if (StringUtils.isBlank((String)url.getQuery())) {
            Assert.fail((String)"Unable to save filter.");
        } else {
            Matcher matcher = CREATE_URL_PATTERN.matcher(url.getQuery());
            if (matcher.find()) {
                long id = Long.parseLong(matcher.group(1));
                this.log("Saved new filter (" + id + ")");
                return id;
            }
            Assert.fail((String)"Unable to save filter.");
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long saveCurrentFilter() {
        HttpUnitDialog dialog = this.tester.getDialog();
        if (dialog.isLinkPresent("filtersave")) {
            this.tester.clickLink("filtersave");
        } else {
            Assert.fail((String)"Unable to find 'filtersave' link on the page to save current filter.");
        }
        this.tester.submit("Save");
        URL url = dialog.getResponse().getURL();
        if (StringUtils.isBlank((String)url.getQuery())) {
            Assert.fail((String)"Unable to save filter.");
        } else {
            Matcher matcher = SAVE_URL_PATTERN.matcher(url.getQuery());
            if (matcher.find()) {
                long id = Long.parseLong(matcher.group(1));
                this.log("Saved filter (" + id + ")");
                return id;
            }
            Assert.fail((String)"Unable to save filter.");
        }
        return Long.MIN_VALUE;
    }

    @Override
    public void deleteFilter(long id) {
        this.tester.gotoPage("secure/DeleteFilter!delete.jspa?filterId=" + id);
    }

    @Override
    public void hideActionsColumn() {
        this.tester.gotoPage("secure/ViewUserIssueColumns!hideActionsColumn.jspa");
    }

    @Override
    public void showActionsColumn() {
        this.tester.gotoPage("secure/ViewUserIssueColumns!showActionsColumn.jspa");
    }

    private void saveUsingPut(String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        this.tester.gotoPage(this.createSaveUrl(name, description, favourite, permissions));
    }

    private String createSaveUrl(String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        StringBuffer buffer = new StringBuffer("secure/SaveAsFilter.jspa?submit=Save");
        if (!StringUtils.isBlank((String)name)) {
            buffer.append("&filterName=").append(this.encode(name));
        }
        if (!StringUtils.isBlank((String)description)) {
            buffer.append("&filterDescription=").append(this.encode(description));
        }
        if (permissions != null) {
            buffer.append("&shareValues=").append(this.encode(TestSharingPermissionUtils.createJsonString(permissions)));
        }
        buffer.append("&favourite=").append(String.valueOf(favourite));
        return buffer.toString();
    }

    private String encode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isCurrentlyOnNavigator() {
        return new IdLocator(this.tester, ID_FILTER_FORM_HEADER).hasNodes();
    }

    private void switchIntoEditMode(IssueNavigatorNavigation.NavigatorEditMode mode) {
        IssueNavigatorNavigation.NavigatorEditMode currentEditMode = this.getCurrentEditMode();
        if (currentEditMode != mode) {
            this.tester.clickLink(ID_LINK_SWITCHNAVTYPE);
            IssueNavigatorNavigation.NavigatorEditMode newEditMode = this.getCurrentEditMode();
            if (newEditMode != mode) {
                Assert.fail((String)("Unable to transition into " + (Object)((Object)mode) + " mode from " + (Object)((Object)currentEditMode) + " mode. Current edit mode " + (Object)((Object)newEditMode) + "."));
            }
        }
    }

    @Override
    public void gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode navigatorEditMode) {
        this.gotoNavigator();
        this.gotoNavigatorMode(IssueNavigatorNavigation.NavigatorMode.NEW, ID_LINK_NEW_FILTER);
        if (navigatorEditMode != null) {
            this.switchIntoEditMode(navigatorEditMode);
        }
    }

    private void editSearch(NavigatorSearch search) {
        this.tester.setWorkingForm(NAME_FILTER_FORM);
        for (NavigatorCondition condition : search.getConditions()) {
            condition.setForm(this.tester);
        }
        this.tester.clickButton("searchAndHide");
    }

    private void gotoNavigatorMode(IssueNavigatorNavigation.NavigatorMode mode, String linkId) {
        IssueNavigatorNavigation.NavigatorMode currentMode = this.getCurrentMode();
        if (currentMode != mode) {
            this.tester.clickLink(linkId);
            IssueNavigatorNavigation.NavigatorMode newMode = this.getCurrentMode();
            if (newMode != mode) {
                Assert.fail((String)("Unable to transition into " + (Object)((Object)mode) + " mode from " + (Object)((Object)currentMode) + " mode. Current mode " + (Object)((Object)newMode) + "."));
            }
        }
    }

    static {
        SAVE_URL_PATTERN = CREATE_URL_PATTERN = Pattern.compile("requestId=(\\d+)");
    }
}

