/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.AbstractNavigationUtil;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigation;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class IssueNavigationImpl
extends AbstractNavigationUtil
implements IssueNavigation {
    private static final String WORKFLOW_ACTION_RESOLVE_ISSUE = "action_id_5";

    public IssueNavigationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData);
    }

    public void viewIssue(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey);
    }

    public void deleteIssue(String issueKey) {
        this.viewIssue(issueKey);
        this.tester.clickLink("delete_issue");
        this.tester.submit("Delete");
    }

    public void gotoIssueChangeHistory(String issueKey) {
        if (issueKey == null) {
            throw new IllegalArgumentException("IssueKey should not be null.");
        }
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
    }

    public String createIssue(String projectName, String issueType, String summary) {
        this.createIssueStep1(projectName, issueType);
        return this.createIssueDetails(summary, null);
    }

    public String createSubTask(String parentIssueKey, String subTaskType, String subTaskSummary, String subTaskDescription) {
        this.createSubTaskStep1(parentIssueKey, subTaskType);
        return this.createIssueDetails(subTaskSummary, subTaskDescription);
    }

    private String createIssueDetails(String summary, String description) {
        this.tester.setFormElement("summary", summary);
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        this.tester.submit("Create");
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//table[@id='issuedetails']/tr/td");
        Node[] tds = xPathLocator.getNodes();
        if (tds.length > 1) {
            String issueKey = xPathLocator.getText(tds[1]);
            Assert.assertNotNull((Object)issueKey);
            return issueKey;
        }
        xPathLocator = new XPathLocator(this.tester, "//td[@class='jiraformbody'][contains(.,'You have successfully created the issue ') and contains(.,' however you do not have the permission to view the created issue.')]");
        tds = xPathLocator.getNodes();
        if (tds.length >= 1) {
            String fullMessage = xPathLocator.getText(tds[0]);
            Assert.assertNotNull((Object)fullMessage);
            return fullMessage.substring(fullMessage.indexOf(40) + 1, fullMessage.indexOf(41));
        }
        Assert.fail((String)"Could not find issue key for newly created issue");
        return null;
    }

    private void createIssueStep1(String projectName, String issueType) {
        this.tester.clickLink("create_link");
        if (this.tester.getDialog().isTextInResponse("Choose the project and issue type")) {
            if (projectName != null) {
                this.tester.selectOption("pid", projectName);
            }
            if (issueType != null) {
                this.tester.selectOption("issuetype", issueType);
            }
            this.tester.submit();
        }
        this.tester.assertTextPresent("Enter the details of the issue");
        if (issueType != null) {
            this.tester.assertTextPresent(issueType);
        }
    }

    private void createSubTaskStep1(String issueKey, String task_type) {
        this.getAdministration().activateSubTasks();
        this.viewIssue(issueKey);
        this.tester.clickLink("create_subtask");
        this.tester.assertTextPresent("Create Sub-Task Issue");
        if (this.tester.getDialog().isTextInResponse("Enter the details of the issue")) {
            this.log("Bypassing step 1 of sub task creation");
        } else {
            this.tester.selectOption("issuetype", task_type);
            this.tester.submit();
        }
        this.tester.assertTextPresent("Enter the details of the issue");
    }

    public void setComponents(String issueKey, String ... components) {
        this.viewIssue(issueKey);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        for (String component : components) {
            this.tester.selectOption("components", component);
        }
        this.tester.submit("Update");
    }

    public void setEnvironment(String issueKey, String environment) {
        this.setSingleIssueField(issueKey, "environment", environment);
    }

    public void setDescription(String issueKey, String description) {
        this.setSingleIssueField(issueKey, "description", description);
    }

    public void setFreeTextCustomField(String issueKey, String customFieldId, String text) {
        this.setSingleIssueField(issueKey, customFieldId, text);
    }

    private void setSingleIssueField(String issueKey, String formElementName, String value) {
        this.viewIssue(issueKey);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement(formElementName, value);
        this.tester.submit("Update");
    }

    public void assignIssue(String issueKey, String comment, String userFullName) {
        this.viewIssue(issueKey);
        this.tester.clickLink("assign_issue");
        this.tester.selectOption("assignee", userFullName);
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
        }
        this.tester.submit("Assign");
        this.tester.assertTextPresent(userFullName);
        if (comment != null) {
            this.tester.assertTextPresent(comment);
        }
    }

    public void unassignIssue(String issueKey, String comment) {
        this.assignIssue(issueKey, comment, "Unassigned");
    }

    public void resolveIssue(String issueKey, String resolution, String comment) {
        this.viewIssue(issueKey);
        this.tester.clickLink(WORKFLOW_ACTION_RESOLVE_ISSUE);
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("resolution", resolution);
        this.tester.setFormElement("comment", comment);
        this.tester.submit("Resolve");
    }

    public void addComment(String issueKey, String comment, String roleLevel) {
        this.viewIssue(issueKey);
        this.tester.clickLink("comment_issue");
        this.tester.setFormElement("comment", comment);
        if (roleLevel != null) {
            this.tester.selectOption("commentLevel", roleLevel);
        }
        this.tester.submit();
    }

    public void setFixVersions(String issueKey, String ... fixVersions) {
        this.viewIssue(issueKey);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        for (String fixVersion : fixVersions) {
            this.tester.selectOption("fixVersions", fixVersion);
        }
        this.tester.submit("Update");
    }

    protected Administration getAdministration() {
        return this.getFuncTestHelperFactory().getAdministration();
    }
}

