/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.locator;

import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;

public class LocatorIterator
implements Iterator {
    private int index = -1;
    private final Node[] nodes;
    private final Locator locator;

    public LocatorIterator(Locator locator) {
        if (locator == null) {
            throw new IllegalArgumentException("You must provide a non null Locator");
        }
        this.locator = locator;
        this.nodes = locator.getNodes();
    }

    public boolean hasNext() {
        int indexplus1 = this.index + 1;
        return indexplus1 >= 0 && indexplus1 < this.nodes.length;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        Node node = this.nodes[this.index];
        return new LocatorInfoImpl(node, this.locator, this.index);
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported!");
    }

    class LocatorInfoImpl
    implements LocatorEntry {
        private final int index;
        private final Node node;
        private final Locator locator;
        private String text;
        private String html;

        public LocatorInfoImpl(Node node, Locator locator, int index) {
            this.node = node;
            this.locator = locator;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public Node getNode() {
            return DomKit.betterNode(this.node);
        }

        public String getText() {
            if (this.text == null) {
                this.text = this.locator.getText(this.node);
            }
            return this.text;
        }

        public String getHTML() {
            if (this.html == null) {
                this.html = this.locator.getHTML(this.node);
            }
            return this.html;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("i:");
            sb.append(this.index);
            sb.append(" text:");
            String s = this.getText();
            sb.append(s.substring(0, Math.min(50, s.length())));
            return sb.toString();
        }
    }
}

