/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.dump;

import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.util.testcase.TestCaseKit;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestInformationKit {
    private static long suiteStartTime = System.currentTimeMillis();
    private static long suiteTotalTestCases = 0L;
    private static long suiteRanSoFar = 0L;
    private static long suiteTestErrorCount = 0L;
    private static List<String> failingTestCases = new ArrayList<String>();
    private static final String FTC_PREFIX = "===FTC";
    private static final int MAX = 15;

    public static void startTestSuite(int totalTestCases) {
        suiteTotalTestCases = totalTestCases;
        suiteStartTime = System.currentTimeMillis();
    }

    public static String getStartMsg(TestCase testCase) {
        return FTC_PREFIX + " Started : " + TestCaseKit.getFullName(testCase) + " #" + ++suiteRanSoFar + " of " + suiteTotalTestCases;
    }

    public static String getEndMsg(TestCase testCase, long runtimeMS) {
        return TestInformationKit.getEndMsg(testCase, runtimeMS, null, null);
    }

    public static String getEndMsg(TestCase testCase, long runtimeMS, FuncTestWebClientListener webClientListener) {
        return TestInformationKit.getEndMsg(testCase, runtimeMS, webClientListener, null);
    }

    public static String getEndMsg(TestCase testCase, long runtimeMS, Throwable problemT) {
        return TestInformationKit.getEndMsg(testCase, runtimeMS, null, problemT);
    }

    public static String getEndMsg(TestCase testCase, long runtimeMS, FuncTestWebClientListener webClientListener, Throwable problemT) {
        float runtimeMSF = (float)runtimeMS / 1000.0f;
        float suiteTimeMSF = (float)(System.currentTimeMillis() - suiteStartTime) / 1000.0f;
        DecimalFormat fmt = new DecimalFormat("#0.00");
        String timeMsg = runtimeMSF == 1.0f ? "1 second" : fmt.format(runtimeMSF) + " seconds";
        String suitTimeMsg = suiteTimeMSF == 1.0f ? "1 second" : fmt.format(suiteTimeMSF) + " seconds";
        Runtime rt = Runtime.getRuntime();
        if (problemT != null) {
            ++suiteTestErrorCount;
        }
        DecimalFormat dfPerCent = new DecimalFormat("#0.0#%");
        double perDone = suiteTotalTestCases == 0L ? 0.0 : (double)suiteRanSoFar / (double)suiteTotalTestCases;
        double perErrors = suiteTotalTestCases == 0L ? 0.0 : (double)suiteTestErrorCount / (double)suiteTotalTestCases;
        StringBuilder sb = new StringBuilder(FTC_PREFIX).append(" Finished").append(problemT == null ? "" : " FAIL").append(" : ").append(TestCaseKit.getFullName(testCase)).append(" #").append(suiteRanSoFar).append(" of ").append(suiteTotalTestCases).append(" (").append(dfPerCent.format(perDone)).append(")").append(" : Errors ").append(suiteTestErrorCount).append(" (").append(dfPerCent.format(perErrors)).append(")").append(" : Run time ").append(timeMsg).append(" : Suite time ").append(suitTimeMsg);
        if (webClientListener != null) {
            long httpRequestCount = webClientListener.getRequestCount();
            long httpTimeMS = webClientListener.getRequestTime();
            long http100thMS = webClientListener.getPercentileRequestTime(100);
            long http90thMS = webClientListener.getPercentileRequestTime(90);
            long http50thMS = webClientListener.getPercentileRequestTime(50);
            double msPerRequest = httpRequestCount == 0L ? 0.0 : (double)httpTimeMS / (double)httpRequestCount;
            sb.append("").append(" : HTTP Count ").append(httpRequestCount).append(" : HTTP Time ").append(httpTimeMS).append("ms").append(" : HTTP 100th ").append(http100thMS).append("ms").append(" : HTTP 90th ").append(http90thMS).append("ms").append(" : HTTP 50th ").append(http50thMS).append("ms").append(" : HTTP Ave ").append(fmt.format(msPerRequest / 1000.0)).append(" ms/request");
        }
        sb.append("").append(" : Max Mem ").append(rt.maxMemory()).append(" : Total Mem ").append(rt.totalMemory()).append("  : Free Mem ").append(rt.freeMemory());
        if (problemT != null) {
            sb.append("\n [").append(problemT).append("]");
            TestInformationKit.addFailingTest(sb, testCase);
        }
        if (failingTestCases.size() > 0) {
            sb.append("\n______________________________\n");
            sb.append("Test Failures So Far :\n");
            for (String failingTestCase : failingTestCases) {
                sb.append(FTC_PREFIX).append(" FAIL : ").append(failingTestCase).append("\n");
            }
        }
        sb.append("\n______________________________\n");
        return sb.toString();
    }

    private static void addFailingTest(StringBuilder sb, TestCase testCase) {
        String testName = testCase.getClass().getName() + "." + testCase.getName();
        int size = failingTestCases.size();
        if (size <= 15) {
            if (size == 15) {
                failingTestCases.add("More than 15 failures...");
            } else {
                failingTestCases.add(testName);
            }
        }
    }
}

