/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.dump;

import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.log.FuncTestLoggerImpl;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.CurrentHttpInformation;
import com.meterware.httpunit.WebResponse;
import com.opensymphony.util.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactDumper {
    private final String htmlResponse;
    private final Throwable failureCause;
    private final JIRAEnvironmentData environmentData;
    private final FuncTestLogger logger;
    private static AtomicInteger dumpCount = new AtomicInteger(0);
    private static final int DEFAULT_MAX_DUMPCOUNT = 5;

    public ArtifactDumper(TestCase testCase, String htmlResponse, Throwable failureCause, Date date, JIRAEnvironmentData environmentData) {
        this(testCase, htmlResponse, failureCause, date, environmentData, new FuncTestLoggerImpl());
    }

    public ArtifactDumper(TestCase testCase, String htmlResponse, Throwable failureCause, Date date, JIRAEnvironmentData environmentData, FuncTestLogger logger, WebTester tester) {
        this(testCase, htmlResponse, failureCause, date, environmentData, logger);
    }

    private ArtifactDumper(TestCase testCase, String htmlResponse, Throwable failureCause, Date date, JIRAEnvironmentData environmentData, FuncTestLogger logger) {
        this.htmlResponse = htmlResponse;
        this.failureCause = failureCause;
        this.environmentData = environmentData;
        this.logger = logger == null ? new FuncTestLoggerImpl() : logger;
        this.dumpToFileAndLaunchBrowserMaybe(testCase, date);
    }

    private static String buildURL(WebTester tester) {
        return tester != null && tester.getDialog() != null && tester.getDialog().getResponse() != null && tester.getDialog().getResponse().getURL() != null ? tester.getDialog().getResponse().getURL().toString() : null;
    }

    private static Map<String, String[]> buildResponseHeaders(WebTester tester) {
        HashMap<String, String[]> responseHeaders = new HashMap<String, String[]>();
        if (tester != null && tester.getDialog() != null && tester.getDialog().getResponse() != null && tester.getDialog().getResponse().getHeaderFieldNames() != null) {
            String[] names;
            WebResponse response = tester.getDialog().getResponse();
            for (String name : names = response.getHeaderFieldNames()) {
                responseHeaders.put(name, response.getHeaderFields(name));
            }
        }
        return responseHeaders;
    }

    private void dumpToFileAndLaunchBrowserMaybe(TestCase testCase, Date currentDate) {
        int maxCount;
        int bodyCloseIndex;
        String htmlResponse = this.htmlResponse;
        String printedStackTrace = "";
        if (this.failureCause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.failureCause.printStackTrace(pw);
            printedStackTrace = sw.toString();
        }
        String captureDirectory = EnvironmentUtils.getMavenAwareOutputDir();
        String captureFileName = this.getFailureFileName(currentDate, testCase);
        File captureDir = new File(captureDirectory);
        File captureFile = new File(captureDir, captureFileName);
        if (!captureDir.exists() && !captureDir.mkdirs()) {
            this.logger.log("Couldnt capture test artifact to : " + captureFile.getAbsolutePath());
            return;
        }
        if (this.failureCause != null && (bodyCloseIndex = htmlResponse.toLowerCase().indexOf("</body")) != -1) {
            StringBuffer sb = new StringBuffer();
            sb.append(htmlResponse.substring(0, bodyCloseIndex));
            sb.append(this.buildStackTraceDivSupport(printedStackTrace));
            sb.append(htmlResponse.substring(bodyCloseIndex));
            htmlResponse = sb.toString();
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(captureFile));
            pw.print(htmlResponse);
            pw.close();
        }
        catch (IOException e) {
            this.logger.log("Couldnt capture test artifact to : " + captureFile.getAbsolutePath());
        }
        int currentCount = dumpCount.incrementAndGet();
        try {
            maxCount = Integer.parseInt(this.environmentData.getProperty("browser.maxopen"));
        }
        catch (NumberFormatException e) {
            maxCount = 5;
        }
        if (maxCount < 0 || currentCount <= maxCount) {
            ArtifactDumper.openBrowser(this.environmentData.getProperty("browser.path"), captureFile, this.logger);
        }
    }

    public static void openBrowser(String command, File captureFile, FuncTestLogger logger) {
        String[] commandWithArgs;
        if (command == null || command.trim().length() == 0) {
            logger.log("A test artifact file has been created here : " + captureFile.getAbsolutePath());
            return;
        }
        if (command.indexOf(" ") != -1) {
            String[] bcmd = command.split(" ");
            commandWithArgs = new String[bcmd.length + 1];
            System.arraycopy(bcmd, 0, commandWithArgs, 0, bcmd.length);
        } else {
            commandWithArgs = new String[2];
            commandWithArgs[0] = command;
        }
        commandWithArgs[commandWithArgs.length - 1] = captureFile.getAbsolutePath();
        try {
            logger.log("Executing command for failing web response - command : " + command + " - captured test artifact :" + captureFile.getAbsolutePath());
            Runtime.getRuntime().exec(commandWithArgs);
        }
        catch (IOException e) {
            logger.log("Failed to execute command : " + command + " with captured test artifact :" + captureFile.getAbsolutePath());
            e.printStackTrace(FuncTestOut.out);
        }
    }

    private String buildStackTraceDivSupport(String printedStackTrace) {
        StringBuffer sb = new StringBuffer();
        sb.append("<script>\n");
        sb.append("function stackTraceShrink() { el = document.getElementById('stackTraceDiv'); if (el.className == 'stackTraceDiv') { el.className = 'stackTraceDivShrink';  } else { el.className = 'stackTraceDiv'; } }\n");
        sb.append("function stackTraceHide() { el = document.getElementById('stackTraceDiv'); el.style.display = 'none'; }\n");
        sb.append("</script>");
        sb.append("<style>");
        sb.append(".stackTraceDiv {");
        sb.append("width:90%;height:95%;position:absolute;right:5px;top:30px;overflow:scroll;border-style:solid;border-width:1px;border-color:black;background-color:#FFFFE5;");
        sb.append("} \n");
        sb.append(".stackTraceDivShrink {");
        sb.append("width:40%;height:80px;position:absolute;right:5px;top:30px;overflow:scroll;border-style:solid;border-width:1px;border-color:black;background-color:#FFFFE5;");
        sb.append("} \n");
        sb.append(".stackTraceButtonDiv {");
        sb.append("position:absolute; right : 5px; top : 5px;");
        sb.append("} \n");
        sb.append(".stackTraceButton {");
        sb.append("border : 1px orange solid; margin : 1px; padding : 1px; cursor : pointer; background-color : blue; color : white; ");
        sb.append("} \n");
        sb.append("</style>");
        sb.append("<div id=\"stackTraceDiv\" class=\"stackTraceDiv\"> \n");
        CurrentHttpInformation.Info httpInfo = CurrentHttpInformation.getInfo();
        if (httpInfo != null) {
            sb.append("<table><tr><td><a target=\"_newWindow\"href=\"").append(httpInfo.getUrl()).append("\">").append(httpInfo.getUrl()).append("</a></td></tr></table>\n");
        }
        sb.append("<div class=\"stackTraceButtonDiv\"> \n");
        sb.append("<table><tr> \n");
        sb.append("<td><div class=\"stackTraceButton\" onclick=\"stackTraceShrink(this)\">Shrink</div></td> \n");
        sb.append("<td><div class=\"stackTraceButton\" onclick=\"stackTraceHide(this)\">Hide</div></td> \n");
        sb.append("</tr></table> \n");
        sb.append("</div> \n");
        sb.append("<pre>");
        sb.append(this.higlightStackTrace(printedStackTrace));
        if (httpInfo != null) {
            sb.append("\n");
            sb.append("HTTP URL    : ").append(httpInfo.getUrl()).append("\n");
            sb.append("HTTP METHOD : ").append(httpInfo.getRequestMethod()).append("\n");
            sb.append("HTTP SC     : ").append(httpInfo.getStatusCode()).append("\n");
            sb.append("HTTP MSG    : ").append(httpInfo.getStatusMessage()).append("\n");
            sb.append(this.printHeaders("Request", httpInfo.getRequestHeaders()));
            sb.append(this.printHeaders("Response", httpInfo.getResponseHeaders()));
        }
        sb.append("</pre>");
        sb.append("</div>");
        return sb.toString();
    }

    private Object printHeaders(String headerTypes, Map<String, String[]> responseHeaders) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(headerTypes).append(" Headers\n");
        for (String headerName : responseHeaders.keySet()) {
            String[] values;
            for (String value : values = responseHeaders.get(headerName)) {
                sb.append("   ").append(headerName).append(":").append(value).append("\n");
            }
        }
        return sb;
    }

    private String getFailureFileName(Date currentDate, TestCase testCase) {
        String testName = testCase == null ? "UnknownTestName.cantFindInStackTrace" : testCase.getClass().getName() + "." + testCase.getName();
        return testName + "_" + new SimpleDateFormat("yyyy-MM-dd--hh-mm-ss-SSSS").format(currentDate) + ".html";
    }

    private String higlightStackTrace(String printedStackTrace) {
        StringBuffer sb = new StringBuffer();
        StringReader sr = new StringReader(printedStackTrace);
        BufferedReader br = new BufferedReader(sr);
        String testName = null;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                line = TextUtils.htmlEncode((String)line);
                boolean append = true;
                if (testName == null && (testName = this.getTestAndClassName(line)) != null) {
                    sb.append("<strong>");
                    sb.append(line);
                    sb.append("</strong>");
                    append = false;
                }
                if (append) {
                    sb.append(line);
                }
                sb.append("\n");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return sb.toString();
    }

    private String getTestAndClassName(String line) {
        String methodName;
        int dotIndex;
        int openingBracket;
        String testName = null;
        if ((line = line.trim()).startsWith("at") && (openingBracket = line.indexOf(40)) != -1 && (dotIndex = line.lastIndexOf(46, openingBracket)) != -1 && (methodName = line.substring(dotIndex + 1, openingBracket)).indexOf("test") == 0) {
            testName = methodName;
            int classDotIndex = line.lastIndexOf(46, dotIndex - 1);
            if (classDotIndex != -1) {
                String className = line.substring(classDotIndex + 1, dotIndex);
                testName = className + "." + testName;
            }
        }
        return testName;
    }
}

