/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewIssueAssertions {
    private final WebTester tester;

    public ViewIssueAssertions(WebTester tester) {
        this.tester = tester;
    }

    public void assertAsignee(String userFullName) {
        String assignee = this.getIssueDetailsValue("Assignee");
        if (!userFullName.equals(assignee)) {
            this.fail("Assignee is '" + assignee + "' but expected '" + userFullName + "'.");
        }
    }

    public void assertOutwardLinkPresent(String issueKey) {
        if (!this.getOutwardLinks().contains(issueKey)) {
            this.fail("Outward link to '" + issueKey + "' is not present.");
        }
    }

    public void assertOutwardLinkNotPresent(String issueKey) {
        if (this.getOutwardLinks().contains(issueKey)) {
            this.fail("Outward link to '" + issueKey + "' is present.");
        }
    }

    public List<String> getOutwardLinks() {
        WebTable outwardLinks_table = this.tester.getDialog().getWebTableBySummaryOrId("outwardLinks_table");
        return this.getLinkKeys(outwardLinks_table);
    }

    public void assertInwardLinkPresent(String issueKey) {
        if (!this.getInwardLinks().contains(issueKey)) {
            this.fail("Inward link to '" + issueKey + "' is not present.");
        }
    }

    public void assertInwardLinkNotPresent(String issueKey) {
        if (this.getInwardLinks().contains(issueKey)) {
            this.fail("Inward link to '" + issueKey + "' is present.");
        }
    }

    public List<String> getInwardLinks() {
        WebTable inwardLinks_table = this.tester.getDialog().getWebTableBySummaryOrId("inwardLinks_table");
        return this.getLinkKeys(inwardLinks_table);
    }

    private List<String> getLinkKeys(WebTable linksTable) {
        ArrayList<String> links = new ArrayList<String>();
        if (linksTable == null) {
            return links;
        }
        int rowCount = linksTable.getRowCount();
        for (int row = 1; row < rowCount; ++row) {
            String text = linksTable.getCellAsText(row, 1).trim();
            if (text.startsWith("|")) {
                text = text.substring(1).trim();
            }
            StringTokenizer st = new StringTokenizer(text);
            links.add(st.nextToken());
        }
        return links;
    }

    private void fail(String message) {
        throw new AssertionFailedError(message);
    }

    public void assertAffectsVersions(String expected) {
        TestCase.assertEquals((String)expected, (String)this.getAffectsVersionsText());
    }

    public void assertAffectsVersionsNone() {
        this.assertAffectsVersions("None");
    }

    public String getAffectsVersionsText() {
        return this.getIssueHeaderValue("Affects Version");
    }

    public void assertFixVersions(String expected) {
        TestCase.assertEquals((String)expected, (String)this.getFixVersionsText());
    }

    public void assertFixVersionsNone() {
        this.assertAffectsVersions("None");
    }

    public String getFixVersionsText() {
        return this.getIssueHeaderValue("Fix Version");
    }

    public String getComponentsText() {
        return this.getIssueHeaderValue("Component");
    }

    private String getIssueHeaderValue(String label) {
        return this.getTableValueForLabel("issue_header", label);
    }

    private String getIssueDetailsValue(String label) {
        return this.getTableValueForLabel("issuedetails", label);
    }

    public void assertEnvironmentEquals(String expected) {
        if (expected.length() == 0) {
            expected = null;
        }
        TestCase.assertEquals((String)expected, (String)this.getEnvironment());
    }

    private String getEnvironment() {
        return this.getTableValueForLabel("issueDetailsTable", "Environment:");
    }

    private String getTableValueForLabel(String tableId, String label) {
        WebTable webTable = this.tester.getDialog().getWebTableBySummaryOrId(tableId);
        if (webTable == null) {
            return null;
        }
        for (int row = 0; row < webTable.getRowCount(); ++row) {
            String thisLabel = webTable.getCellAsText(row, 0);
            if (thisLabel == null || !thisLabel.trim().startsWith(label)) continue;
            return TextKit.collapseWhitespace(webTable.getCellAsText(row, 1));
        }
        return null;
    }
}

