/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.LinkAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebLink;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkAssertionsImpl
extends AbstractFuncTestUtil
implements LinkAssertions {
    public LinkAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    @Override
    public void assertLinkLocationEndsWith(String linkText, String endsWith) {
        WebLink webLink = this.getLinkWithText(linkText);
        String urlString = webLink.getURLString().trim();
        if (!urlString.endsWith(endsWith)) {
            Assert.fail((String)("Location of link with text '" + linkText + "' expected to end with '" + endsWith + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkLocationEndsWith(WebLink link, String endsWith) {
        String urlString = link.getURLString().trim();
        if (!urlString.endsWith(endsWith)) {
            Assert.fail((String)("Location of link expected to end with '" + endsWith + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkAtNodeEndsWith(String xpath, String endsWith) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        Assert.assertTrue((String)("Node '" + xpath + "' does not exist."), (boolean)locator.exists());
        String href = locator.getNode().getAttributes().getNamedItem("href").getNodeValue();
        if (!href.endsWith(endsWith)) {
            Assert.fail((String)("Location of link expected to end with '" + endsWith + "' but points to '" + href + "'."));
        }
    }

    @Override
    public void assertLinkIdQueryStringContainsJqlQuery(String linkId, String expectedJqlQuery) {
        this.assertLinkQueryStringContainsJqlQuery(this.getLinkWithId(linkId), expectedJqlQuery);
    }

    @Override
    public void assertLinkTextQueryStringContainsJqlQuery(String xpath, String linkText, String expectedJqlQuery) {
        List<String> hrefs = this.getHrefsFromLinkNodeWithExactText(xpath, linkText);
        for (String href : hrefs) {
            boolean found = this.doesHrefContainsJqlQuery(href, expectedJqlQuery);
            if (!found) continue;
            return;
        }
        Assert.fail((String)String.format("Could not find any links with text '%s' in xpath '%s' that contained the jql '%s'", linkText, xpath, expectedJqlQuery));
    }

    @Override
    public void assertLinkQueryStringContainsJqlQuery(WebLink link, String expectedJqlQuery) {
        if (StringUtils.isEmpty((String)link.getURLString())) {
            Assert.fail((String)("No URL for link with id [" + link.getID() + "]"));
        }
        boolean foundSubString = this.doesHrefContainsJqlQuery(link.getURLString(), expectedJqlQuery);
        Assert.assertTrue((String)String.format("Could not find jql '%s' in URL '%s'", expectedJqlQuery, link.getURLString()), (boolean)foundSubString);
    }

    private boolean doesHrefContainsJqlQuery(String href, String expectedJqlQuery) {
        try {
            String urlSubString = "jqlQuery=" + URLEncoder.encode(expectedJqlQuery, "UTF-8");
            return href.indexOf(urlSubString) != -1;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void assertLinkIdLocationEndsWith(String linkId, String endsWith) {
        WebLink webLink = this.getLinkWithId(linkId);
        String urlString = webLink.getURLString().trim();
        if (!urlString.endsWith(endsWith)) {
            Assert.fail((String)("Location of link with id '" + linkId + "' expected to end with '" + endsWith + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkIdLocationMatchesRegex(String linkId, String regex) {
        WebLink webLink = this.getLinkWithId(linkId);
        String urlString = webLink.getURLString().trim();
        if (!urlString.matches(regex)) {
            Assert.fail((String)("Location of link with id '" + linkId + "' expected to match regex '" + regex + "' but points to '" + urlString + "'."));
        }
    }

    @Override
    public void assertLinkPresentWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a[text()=\"" + text + "\"]");
        Assert.assertTrue((String)("Could not find a single link with the exact text \"" + text + "\" using locator: " + locator), (locator.getNodes().length > 0 ? 1 : 0) != 0);
    }

    @Override
    public void assertLinkNotPresentWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a[text()=\"" + text + "\"]");
        Assert.assertTrue((String)("Found a link with the exact text \"" + text + "\" using locator: " + locator), (locator.getNodes().length == 0 ? 1 : 0) != 0);
    }

    private List<String> getHrefsFromLinkNodeWithExactText(String xpath, String text) {
        XPathLocator locator = new XPathLocator(this.tester, xpath + "//a");
        if (locator.getNodes().length == 0) {
            throw new IllegalArgumentException("Could not find any links with the text '" + text + "' from xpath '" + xpath + "'.");
        }
        ArrayList<Node> matchedNodes = new ArrayList<Node>();
        for (Node node : locator.getNodes()) {
            String nodeText = locator.getText(node);
            if (!text.equals(nodeText)) continue;
            matchedNodes.add(node);
        }
        ArrayList<String> hrefs = new ArrayList<String>();
        for (Node aNode : matchedNodes) {
            hrefs.add(aNode.getAttributes().getNamedItem("href").getNodeValue());
        }
        return hrefs;
    }

    private WebLink getLinkWithText(String text) {
        WebLink webLink;
        try {
            HttpUnitDialog dialog = this.tester.getDialog();
            if (!dialog.isLinkPresentWithText(text)) {
                Assert.fail((String)("Link with text'" + text + "' does not exist."));
            }
            webLink = dialog.getResponse().getLinkWith(text);
        }
        catch (SAXException e) {
            AssertionError error = new AssertionError((Object)("Link with text '" + text + "' does not exist."));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
        return webLink;
    }

    private WebLink getLinkWithId(String linkId) {
        WebLink webLink;
        try {
            HttpUnitDialog dialog = this.tester.getDialog();
            if (!dialog.isLinkPresent(linkId)) {
                Assert.fail((String)("Link with id'" + linkId + "' does not exist."));
            }
            webLink = dialog.getResponse().getLinkWithID(linkId);
        }
        catch (SAXException e) {
            AssertionError error = new AssertionError((Object)("Link with id '" + linkId + "' does not exist."));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
        return webLink;
    }
}

