/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.JiraFormAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class JiraFormAssertionsImpl
extends AbstractFuncTestUtil
implements JiraFormAssertions {
    private final TextAssertions textAssertions;

    public JiraFormAssertionsImpl(TextAssertions textAssertions, WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
        this.textAssertions = textAssertions;
    }

    public void assertFieldErrMsg(String expectedText) {
        Locator error = this.createFieldMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    public void assertFormErrMsg(String expectedText) {
        Locator error = this.createFormMessageLocator();
        this.textAssertions.assertTextPresent(error, expectedText);
    }

    public void assertNoErrorsPresent() {
        Locator errorLocator = this.createFieldMessageLocator();
        Assert.assertNull((String)"Expected no errors on the page, but there was a field with an error.", (Object)errorLocator.getNode());
        errorLocator = this.createFormMessageLocator();
        Assert.assertNull((String)"Expected no errors on the page, but the page had a global error.", (Object)errorLocator.getNode());
    }

    private Locator createFieldMessageLocator() {
        return new XPathLocator(this.tester, "//span[@class='errMsg']");
    }

    private Locator createFormMessageLocator() {
        return new XPathLocator(this.tester, "//div[@class='errorArea']");
    }
}

